/*
 * Decompiled with CFR 0.152.
 */
package de.rub.nds.tlsattacker.core.protocol.parser.extension;

import de.rub.nds.modifiablevariable.util.ArrayConverter;
import de.rub.nds.tlsattacker.core.exceptions.ParserException;
import de.rub.nds.tlsattacker.core.protocol.message.extension.ClientEsniInner;
import de.rub.nds.tlsattacker.core.protocol.message.extension.sni.ServerNamePair;
import de.rub.nds.tlsattacker.core.protocol.parser.Parser;
import de.rub.nds.tlsattacker.core.protocol.parser.extension.ServerNamePairParser;
import java.util.LinkedList;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class ClientEsniInnerParser
extends Parser<ClientEsniInner> {
    private static final Logger LOGGER = LogManager.getLogger();
    private final ClientEsniInner clientEsniInner = new ClientEsniInner();

    public ClientEsniInnerParser(int startposition, byte[] array) {
        super(startposition, array);
    }

    @Override
    public ClientEsniInner parse() {
        this.parseClientNonce(this.clientEsniInner);
        this.parseServerNameListLength(this.clientEsniInner);
        this.parseServerNameListByte(this.clientEsniInner);
        this.parsePadding(this.clientEsniInner);
        this.parseServerNameList(this.clientEsniInner);
        return this.clientEsniInner;
    }

    private void parseClientNonce(ClientEsniInner clientEsniInne) {
        byte[] clientNonce = this.parseByteArrayField(16);
        clientEsniInne.setClientNonce(clientNonce);
        LOGGER.debug("clientNonce: " + ArrayConverter.bytesToHexString((byte[])((byte[])clientEsniInne.getClientNonce().getValue())));
    }

    private void parseServerNameListLength(ClientEsniInner clientEsniInne) {
        int serverNameListLength = this.parseIntField(2);
        clientEsniInne.setServerNameListLength(serverNameListLength);
        LOGGER.debug("serverNameListLength: " + clientEsniInne.getServerNameListLength().getValue());
    }

    private void parseServerNameListByte(ClientEsniInner clientEsniInne) {
        byte[] serverNameListByte = this.parseByteArrayField((Integer)clientEsniInne.getServerNameListLength().getValue());
        clientEsniInne.setServerNameListBytes(serverNameListByte);
        LOGGER.debug("serverNameListByte: " + ArrayConverter.bytesToHexString((byte[])((byte[])clientEsniInne.getServerNameListBytes().getValue())));
    }

    private void parsePadding(ClientEsniInner clientEsniInne) {
        byte[] padding = this.parseByteArrayField(this.getBytesLeft());
        clientEsniInne.setPadding(padding);
        LOGGER.debug("padding: " + ArrayConverter.bytesToHexString((byte[])((byte[])clientEsniInne.getPadding().getValue())));
    }

    private void parseServerNameList(ClientEsniInner clientEsniInne) {
        int position = 0;
        LinkedList<ServerNamePair> serverNamePairList = new LinkedList<ServerNamePair>();
        while (position < (Integer)clientEsniInne.getServerNameListLength().getValue()) {
            ServerNamePairParser parser = new ServerNamePairParser(position, (byte[])clientEsniInne.getServerNameListBytes().getValue());
            serverNamePairList.add(parser.parse());
            if (position == parser.getPointer()) {
                throw new ParserException("Ran into infinite Loop while parsing ServerNamePair");
            }
            position = parser.getPointer();
        }
        clientEsniInne.setServerNameList(serverNamePairList);
    }
}

