/*
 * Decompiled with CFR 0.152.
 */
package de.rub.nds.tlsattacker.core.crypto.ec;

import java.math.BigInteger;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.bouncycastle.math.ec.rfc7748.X448;
import org.bouncycastle.util.Arrays;

public class ForgivingX448Curve {
    private static final Logger LOGGER = LogManager.getLogger();
    public static final int ELEMENT_SIZE = 56;

    public static byte[] computePublicKey(BigInteger privateKey) {
        return ForgivingX448Curve.computePublicKey(privateKey.toByteArray());
    }

    public static byte[] computePublicKey(byte[] privateKey) {
        X448.precompute();
        if (privateKey.length > 56) {
            LOGGER.debug("privatekey has is longer than 56 bytes. Using only first 56 bytes.");
            privateKey = Arrays.copyOfRange((byte[])privateKey, (int)0, (int)56);
        } else if (privateKey.length < 56) {
            LOGGER.debug("privatekey has is shorter than 56 bytes. Padding with 0x00...");
            privateKey = Arrays.copyOf((byte[])privateKey, (int)56);
        }
        byte[] publicKey = new byte[56];
        X448.scalarMultBase((byte[])privateKey, (int)0, (byte[])publicKey, (int)0);
        return publicKey;
    }

    public static byte[] computeSharedSecret(BigInteger privateKey, byte[] publicKey) {
        return ForgivingX448Curve.computeSharedSecret(privateKey.toByteArray(), publicKey);
    }

    public static byte[] computeSharedSecret(byte[] privateKey, byte[] publicKey) {
        if (privateKey.length > 56) {
            LOGGER.debug("privatekey is longer than 56 bytes. Using only first 56 bytes.");
            privateKey = Arrays.copyOfRange((byte[])privateKey, (int)0, (int)56);
        } else if (privateKey.length < 56) {
            LOGGER.debug("privatekey is shorter than 56 bytes. Padding with 0x00...");
            privateKey = Arrays.copyOf((byte[])privateKey, (int)56);
        }
        if (publicKey.length > 56) {
            LOGGER.debug("publicKey is longer than 56 bytes. Using only first 56 bytes.");
            publicKey = Arrays.copyOfRange((byte[])publicKey, (int)0, (int)56);
        } else if (publicKey.length < 56) {
            LOGGER.debug("publicKey is shorter than 56 bytes. Padding with 0x00...");
            publicKey = Arrays.copyOf((byte[])publicKey, (int)56);
        }
        byte[] sharedSecret = new byte[56];
        X448.scalarMult((byte[])privateKey, (int)0, (byte[])publicKey, (int)0, (byte[])sharedSecret, (int)0);
        return sharedSecret;
    }

    private ForgivingX448Curve() {
    }
}

