/*
 * Decompiled with CFR 0.152.
 */
package de.rub.nds.tlsattacker.core.certificate;

import de.rub.nds.modifiablevariable.util.ArrayConverter;
import de.rub.nds.modifiablevariable.util.ByteArrayAdapter;
import de.rub.nds.tlsattacker.core.certificate.PemUtil;
import de.rub.nds.tlsattacker.core.config.Config;
import de.rub.nds.tlsattacker.core.constants.CertificateKeyType;
import de.rub.nds.tlsattacker.core.constants.GOSTCurve;
import de.rub.nds.tlsattacker.core.constants.NamedGroup;
import de.rub.nds.tlsattacker.core.constants.ProtocolVersion;
import de.rub.nds.tlsattacker.core.constants.SignatureAndHashAlgorithm;
import de.rub.nds.tlsattacker.core.crypto.keys.CustomDHPrivateKey;
import de.rub.nds.tlsattacker.core.crypto.keys.CustomDSAPrivateKey;
import de.rub.nds.tlsattacker.core.crypto.keys.CustomDhPublicKey;
import de.rub.nds.tlsattacker.core.crypto.keys.CustomDsaPublicKey;
import de.rub.nds.tlsattacker.core.crypto.keys.CustomECPrivateKey;
import de.rub.nds.tlsattacker.core.crypto.keys.CustomEcPublicKey;
import de.rub.nds.tlsattacker.core.crypto.keys.CustomPrivateKey;
import de.rub.nds.tlsattacker.core.crypto.keys.CustomPublicKey;
import de.rub.nds.tlsattacker.core.crypto.keys.CustomRSAPrivateKey;
import de.rub.nds.tlsattacker.core.crypto.keys.CustomRsaPublicKey;
import de.rub.nds.tlsattacker.core.state.TlsContext;
import de.rub.nds.tlsattacker.core.util.CertificateUtils;
import de.rub.nds.tlsattacker.transport.ConnectionEndType;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Serializable;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.cert.CertificateException;
import java.util.Arrays;
import java.util.Objects;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlElements;
import javax.xml.bind.annotation.adapters.XmlJavaTypeAdapter;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.bouncycastle.asn1.ASN1ObjectIdentifier;
import org.bouncycastle.asn1.ASN1Sequence;
import org.bouncycastle.asn1.x509.AlgorithmIdentifier;
import org.bouncycastle.asn1.x9.ECNamedCurveTable;
import org.bouncycastle.crypto.tls.Certificate;

@XmlAccessorType(value=XmlAccessType.FIELD)
public class CertificateKeyPair
implements Serializable {
    private static final Logger LOGGER = LogManager.getLogger();
    private final CertificateKeyType certPublicKeyType;
    private final CertificateKeyType certSignatureType;
    private final GOSTCurve gostCurve;
    @XmlJavaTypeAdapter(value=ByteArrayAdapter.class)
    private final byte[] certificateBytes;
    @XmlElements(value={@XmlElement(type=CustomDhPublicKey.class, name="DhPublicKey"), @XmlElement(type=CustomDsaPublicKey.class, name="DsaPublicKey"), @XmlElement(type=CustomRsaPublicKey.class, name="RsaPublicKey"), @XmlElement(type=CustomEcPublicKey.class, name="EcPublicKey")})
    private final CustomPublicKey publicKey;
    @XmlElements(value={@XmlElement(type=CustomDHPrivateKey.class, name="DhPrivateKey"), @XmlElement(type=CustomDSAPrivateKey.class, name="DsaPrivateKey"), @XmlElement(type=CustomRSAPrivateKey.class, name="RsaPrivateKey"), @XmlElement(type=CustomECPrivateKey.class, name="EcPrivateKey")})
    private final CustomPrivateKey privateKey;
    private final NamedGroup signatureGroup;
    private final NamedGroup publicKeyGroup;

    private CertificateKeyPair() {
        this.certPublicKeyType = null;
        this.certSignatureType = null;
        this.certificateBytes = null;
        this.publicKey = null;
        this.privateKey = null;
        this.signatureGroup = null;
        this.publicKeyGroup = null;
        this.gostCurve = null;
    }

    public CertificateKeyPair(CertificateKeyType certPublicKeyType, CertificateKeyType certSignatureType, byte[] certificateBytes, CustomPublicKey publicKey, CustomPrivateKey privateKey, NamedGroup signatureGroup, NamedGroup publicKeyGroup) {
        this.certPublicKeyType = certPublicKeyType;
        this.certSignatureType = certSignatureType;
        this.certificateBytes = certificateBytes;
        this.publicKey = publicKey;
        this.privateKey = privateKey;
        this.signatureGroup = signatureGroup;
        this.publicKeyGroup = publicKeyGroup;
        this.gostCurve = null;
    }

    public CertificateKeyPair(Certificate cert, PrivateKey key) throws IOException {
        this.certPublicKeyType = this.getPublicKeyType(cert);
        this.certSignatureType = this.getSignatureType(cert);
        ByteArrayOutputStream stream = new ByteArrayOutputStream();
        cert.encode((OutputStream)stream);
        this.certificateBytes = stream.toByteArray();
        this.privateKey = CertificateUtils.parseCustomPrivateKey(key);
        this.publicKey = CertificateUtils.parseCustomPublicKey(CertificateUtils.parsePublicKey(cert));
        this.publicKeyGroup = this.getPublicNamedGroup(cert);
        this.signatureGroup = this.getSignatureNamedGroup(cert);
        this.gostCurve = this.certPublicKeyType == CertificateKeyType.GOST01 || this.certPublicKeyType == CertificateKeyType.GOST12 ? this.getGostCurve(cert) : null;
    }

    public CertificateKeyPair(Certificate cert) {
        this.certPublicKeyType = this.getPublicKeyType(cert);
        this.certSignatureType = this.getSignatureType(cert);
        ByteArrayOutputStream stream = new ByteArrayOutputStream();
        try {
            cert.encode((OutputStream)stream);
        }
        catch (IOException ex) {
            ex.printStackTrace();
        }
        this.certificateBytes = stream.toByteArray();
        this.privateKey = null;
        this.publicKey = CertificateUtils.parseCustomPublicKey(CertificateUtils.parsePublicKey(cert));
        this.publicKeyGroup = this.getPublicNamedGroup(cert);
        this.signatureGroup = this.getSignatureNamedGroup(cert);
        this.gostCurve = this.certPublicKeyType == CertificateKeyType.GOST01 || this.certPublicKeyType == CertificateKeyType.GOST12 ? this.getGostCurve(cert) : null;
    }

    public CertificateKeyPair(byte[] certificateBytes, PrivateKey privateKey, PublicKey publicKey) {
        this.certPublicKeyType = CertificateKeyType.RSA;
        this.certSignatureType = CertificateKeyType.RSA;
        this.certificateBytes = ArrayConverter.concatenate((byte[][])new byte[][]{ArrayConverter.intToBytes((int)(certificateBytes.length + 3), (int)3), ArrayConverter.intToBytes((int)certificateBytes.length, (int)3), certificateBytes});
        this.publicKeyGroup = null;
        this.signatureGroup = null;
        this.gostCurve = null;
        this.privateKey = CertificateUtils.parseCustomPrivateKey(privateKey);
        this.publicKey = CertificateUtils.parseCustomPublicKey(publicKey);
    }

    public CertificateKeyPair(Certificate cert, PrivateKey privateKey, PublicKey publicKey) throws IOException {
        this.certPublicKeyType = this.getPublicKeyType(cert);
        this.certSignatureType = this.getSignatureType(cert);
        ByteArrayOutputStream stream = new ByteArrayOutputStream();
        cert.encode((OutputStream)stream);
        this.certificateBytes = stream.toByteArray();
        this.publicKeyGroup = this.getPublicNamedGroup(cert);
        this.signatureGroup = this.getSignatureNamedGroup(cert);
        this.gostCurve = this.certPublicKeyType == CertificateKeyType.GOST01 || this.certPublicKeyType == CertificateKeyType.GOST12 ? this.getGostCurve(cert) : null;
        this.privateKey = CertificateUtils.parseCustomPrivateKey(privateKey);
        this.publicKey = CertificateUtils.parseCustomPublicKey(publicKey);
    }

    public CertificateKeyPair(CertificateKeyType certPublicKeyType, CertificateKeyType certSignatureType, File certFile, File privateKeyFile) throws CertificateException, IOException {
        this.certPublicKeyType = certPublicKeyType;
        this.certSignatureType = certSignatureType;
        Certificate certificate = PemUtil.readCertificate(certFile);
        this.publicKey = CertificateUtils.parseCustomPublicKey(PemUtil.readPublicKey(certFile));
        this.privateKey = CertificateUtils.parseCustomPrivateKey(PemUtil.readPrivateKey(privateKeyFile));
        this.certificateBytes = certificate.getCertificateAt(0).getEncoded();
        this.signatureGroup = this.getSignatureNamedGroup(certificate);
        this.publicKeyGroup = this.getPublicNamedGroup(certificate);
        this.gostCurve = certPublicKeyType == CertificateKeyType.GOST01 || certPublicKeyType == CertificateKeyType.GOST12 ? this.getGostCurve(certificate) : null;
    }

    private CertificateKeyType getPublicKeyType(Certificate cert) {
        if (cert.isEmpty()) {
            throw new IllegalArgumentException("Empty CertChain provided!");
        }
        AlgorithmIdentifier algorithm = cert.getCertificateAt(0).getSubjectPublicKeyInfo().getAlgorithm();
        switch (algorithm.getAlgorithm().getId()) {
            case "1.2.840.113549.1.1.1": {
                return CertificateKeyType.RSA;
            }
            case "1.2.840.10045.2.1": 
            case "1.2.840.10045.4.3.4": {
                return CertificateKeyType.ECDSA;
            }
            case "1.2.840.113549.1.3.1": {
                return CertificateKeyType.DH;
            }
            case "1.2.840.10040.4.1": {
                return CertificateKeyType.DSS;
            }
            case "1.2.643.2.2.19": {
                return CertificateKeyType.GOST01;
            }
            case "1.2.643.7.1.1.1.1": 
            case "1.2.643.7.1.1.1.2": {
                return CertificateKeyType.GOST12;
            }
        }
        LOGGER.warn("Unknown algorithm ID: " + algorithm.getAlgorithm().getId() + " using \"NONE\"");
        return CertificateKeyType.NONE;
    }

    private GOSTCurve getGostCurve(Certificate cert) {
        if (cert.isEmpty()) {
            throw new IllegalArgumentException("Empty CertChain provided!");
        }
        switch (((ASN1ObjectIdentifier)((ASN1Sequence)cert.getCertificateAt(0).getSubjectPublicKeyInfo().getAlgorithm().getParameters()).getObjectAt(0)).getId()) {
            case "1.2.643.2.2.35.1": {
                return GOSTCurve.GostR3410_2001_CryptoPro_A;
            }
            case "1.2.643.2.2.35.2": {
                return GOSTCurve.GostR3410_2001_CryptoPro_B;
            }
            case "1.2.643.2.2.35.3": {
                return GOSTCurve.GostR3410_2001_CryptoPro_C;
            }
            case "1.2.643.2.2.36.0": {
                return GOSTCurve.GostR3410_2001_CryptoPro_XchA;
            }
            case "1.2.643.2.2.36.1": {
                return GOSTCurve.GostR3410_2001_CryptoPro_XchB;
            }
            case "1.2.643.7.1.1.1.2": {
                return GOSTCurve.Tc26_Gost_3410_12_256_paramSetA;
            }
            case "1.2.643.7.1.2.1.2.1": {
                return GOSTCurve.Tc26_Gost_3410_12_512_paramSetA;
            }
            case "1.2.643.7.1.2.1.2.2": {
                return GOSTCurve.Tc26_Gost_3410_12_512_paramSetB;
            }
            case "1.2.643.7.1.1.1.5": {
                return GOSTCurve.Tc26_Gost_3410_12_512_paramSetC;
            }
        }
        return null;
    }

    private CertificateKeyType getSignatureType(Certificate cert) {
        if (cert.isEmpty()) {
            throw new IllegalArgumentException("Empty CertChain provided!");
        }
        AlgorithmIdentifier algorithm = cert.getCertificateAt(0).getSignatureAlgorithm();
        if (algorithm.getAlgorithm().getId().startsWith("1.2.840.113549.1.1.")) {
            return CertificateKeyType.RSA;
        }
        switch (algorithm.getAlgorithm().getId()) {
            case "1.2.840.10045.4.3.1": 
            case "1.2.840.10045.4.3.2": 
            case "1.2.840.10045.4.3.3": {
                return CertificateKeyType.ECDSA;
            }
            case "2.16.840.1.101.3.4.3.1": 
            case "2.16.840.1.101.3.4.3.2": 
            case "2.16.840.1.101.3.4.3.13": 
            case "2.16.840.1.101.3.4.3.14": 
            case "2.16.840.1.101.3.4.3.15": 
            case "2.16.840.1.101.3.4.3.16": {
                return CertificateKeyType.DSS;
            }
            case "1.2.643.2.2.3": {
                return CertificateKeyType.GOST01;
            }
            case "1.2.643.7.1.1.3.2": 
            case "1.2.643.7.1.1.3.3": {
                return CertificateKeyType.GOST12;
            }
        }
        LOGGER.warn("Unknown algorithm ID: " + algorithm.getAlgorithm().getId() + " using \"NONE\"");
        return CertificateKeyType.NONE;
    }

    private NamedGroup getSignatureNamedGroup(Certificate cert) {
        if (cert.isEmpty()) {
            throw new IllegalArgumentException("Empty CertChain provided!");
        }
        if (!(this.publicKey instanceof CustomEcPublicKey)) {
            return null;
        }
        try {
            ASN1ObjectIdentifier publicKeyParameters = (ASN1ObjectIdentifier)cert.getCertificateAt(0).getSubjectPublicKeyInfo().getAlgorithm().getParameters();
            return NamedGroup.fromJavaName(ECNamedCurveTable.getName((ASN1ObjectIdentifier)publicKeyParameters));
        }
        catch (Exception ex) {
            LOGGER.warn("Could not determine EC public key group", (Throwable)ex);
            return null;
        }
    }

    private NamedGroup getPublicNamedGroup(Certificate cert) {
        if (cert.isEmpty()) {
            throw new IllegalArgumentException("Empty CertChain provided!");
        }
        if (!(this.publicKey instanceof CustomEcPublicKey)) {
            return null;
        }
        try {
            ASN1ObjectIdentifier publicKeyParameters = (ASN1ObjectIdentifier)cert.getCertificateAt(0).getSubjectPublicKeyInfo().getAlgorithm().getParameters();
            return NamedGroup.fromJavaName(ECNamedCurveTable.getName((ASN1ObjectIdentifier)publicKeyParameters));
        }
        catch (Exception ex) {
            LOGGER.warn("Could not determine EC public key group", (Throwable)ex);
            return null;
        }
    }

    public CertificateKeyType getCertPublicKeyType() {
        return this.certPublicKeyType;
    }

    public CertificateKeyType getCertSignatureType() {
        return this.certSignatureType;
    }

    public byte[] getCertificateBytes() {
        return this.certificateBytes;
    }

    public CustomPublicKey getPublicKey() {
        return this.publicKey;
    }

    public CustomPrivateKey getPrivateKey() {
        return this.privateKey;
    }

    public NamedGroup getSignatureGroup() {
        return this.signatureGroup;
    }

    public NamedGroup getPublicKeyGroup() {
        return this.publicKeyGroup;
    }

    public GOSTCurve getGostCurve() {
        return this.gostCurve;
    }

    public void adjustInConfig(Config config, ConnectionEndType connectionEnd) {
        this.publicKey.adjustInConfig(config, connectionEnd);
        if (this.privateKey != null) {
            this.privateKey.adjustInConfig(config, connectionEnd);
        }
        config.setDefaultExplicitCertificateKeyPair(this);
        if (this.gostCurve != null) {
            config.setDefaultSelectedGostCurve(this.gostCurve);
        }
    }

    public void adjustInContext(TlsContext context, ConnectionEndType connectionEnd) {
        if (context.getSelectedProtocolVersion() != ProtocolVersion.TLS13) {
            this.publicKey.adjustInContext(context, connectionEnd);
        }
        if (this.privateKey != null) {
            this.privateKey.adjustInContext(context, connectionEnd);
        }
        context.setEcCertificateCurve(this.publicKeyGroup);
        if (context.getConfig().getAutoAdjustSignatureAndHashAlgorithm().booleanValue()) {
            SignatureAndHashAlgorithm sigHashAlgo = SignatureAndHashAlgorithm.forCertificateKeyPair(this, context.getChooser());
            if (sigHashAlgo == SignatureAndHashAlgorithm.GOSTR34102012_512_GOSTR34112012_512 || sigHashAlgo == SignatureAndHashAlgorithm.GOSTR34102012_256_GOSTR34112012_256 || sigHashAlgo == SignatureAndHashAlgorithm.GOSTR34102001_GOSTR3411) {
                context.setSelectedGostCurve(this.gostCurve);
                LOGGER.debug("Adjusting selected GOST curve:" + (Object)((Object)this.gostCurve));
            }
            LOGGER.debug("Setting selected SignatureAndHash algorithm to:" + (Object)((Object)sigHashAlgo));
            context.setSelectedSignatureAndHashAlgorithm(sigHashAlgo);
        }
    }

    public int hashCode() {
        int hash = 3;
        hash = 29 * hash + Objects.hashCode((Object)this.certPublicKeyType);
        hash = 29 * hash + Objects.hashCode((Object)this.certSignatureType);
        hash = 29 * hash + Arrays.hashCode(this.certificateBytes);
        hash = 29 * hash + Objects.hashCode(this.publicKey);
        hash = 29 * hash + Objects.hashCode(this.privateKey);
        hash = 29 * hash + Objects.hashCode((Object)this.signatureGroup);
        hash = 29 * hash + Objects.hashCode((Object)this.publicKeyGroup);
        return hash;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        CertificateKeyPair other = (CertificateKeyPair)obj;
        if (this.certPublicKeyType != other.certPublicKeyType) {
            return false;
        }
        if (this.certSignatureType != other.certSignatureType) {
            return false;
        }
        if (!Arrays.equals(this.certificateBytes, other.certificateBytes)) {
            return false;
        }
        if (!Objects.equals(this.publicKey, other.publicKey)) {
            return false;
        }
        if (!Objects.equals(this.privateKey, other.privateKey)) {
            return false;
        }
        if (this.signatureGroup != other.signatureGroup) {
            return false;
        }
        return this.publicKeyGroup == other.publicKeyGroup;
    }

    public boolean isCertificateParseable() {
        try {
            Certificate cert = Certificate.parse((InputStream)new ByteArrayInputStream(this.certificateBytes));
            return true;
        }
        catch (Exception E) {
            return false;
        }
    }

    public String toString() {
        return "CertificateKeyPair{certPublicKeyType=" + (Object)((Object)this.certPublicKeyType) + ", certSignatureType=" + (Object)((Object)this.certSignatureType) + ", certificateBytes=" + Arrays.toString(this.certificateBytes) + ", publicKey=" + this.publicKey + ", privateKey=" + this.privateKey + ", signatureGroup=" + (Object)((Object)this.signatureGroup) + ", publicKeyGroup=" + (Object)((Object)this.publicKeyGroup) + '}';
    }
}

