/*
 * Decompiled with CFR 0.152.
 */
package de.rub.nds.tlsattacker.attacks.padding;

import de.rub.nds.modifiablevariable.VariableModification;
import de.rub.nds.modifiablevariable.bytearray.ByteArrayDeleteModification;
import de.rub.nds.modifiablevariable.bytearray.ByteArrayExplicitValueModification;
import de.rub.nds.modifiablevariable.bytearray.ByteArrayModificationFactory;
import de.rub.nds.modifiablevariable.bytearray.ByteArrayXorModification;
import de.rub.nds.modifiablevariable.util.ArrayConverter;
import de.rub.nds.tlsattacker.attacks.padding.PaddingVectorGenerator;
import de.rub.nds.tlsattacker.attacks.padding.vector.PaddingVector;
import de.rub.nds.tlsattacker.attacks.padding.vector.PlainPaddingVector;
import de.rub.nds.tlsattacker.attacks.padding.vector.TrippleVector;
import de.rub.nds.tlsattacker.core.constants.AlgorithmResolver;
import de.rub.nds.tlsattacker.core.constants.CipherSuite;
import de.rub.nds.tlsattacker.core.constants.ProtocolVersion;
import java.util.LinkedList;
import java.util.List;

public class ShortPaddingGenerator
extends PaddingVectorGenerator {
    static final int DEFAULT_CIPHERTEXT_LENGTH = 80;
    static final int DEFAULT_PADDING_LENGTH = 4;

    @Override
    public List<PaddingVector> getVectors(CipherSuite suite, ProtocolVersion version) {
        LinkedList<PaddingVector> vectorList = new LinkedList<PaddingVector>();
        vectorList.addAll(this.createBasicMacVectors(suite, version));
        vectorList.addAll(this.createMissingMacByteVectors(suite, version));
        vectorList.addAll(this.createOnlyPaddingVectors(suite, version));
        vectorList.addAll(this.createClassicModifiedPadding(suite, version));
        return vectorList;
    }

    List<PaddingVector> createBasicMacVectors(CipherSuite suite, ProtocolVersion version) {
        LinkedList<PaddingVector> vectorList = new LinkedList<PaddingVector>();
        int macSize = AlgorithmResolver.getMacAlgorithm(version, suite).getSize();
        int i = 1;
        for (ByteArrayXorModification modification : this.createFlippedModifications(macSize)) {
            vectorList.add(new TrippleVector("BasicMac-" + modification.getStartPosition() + "-" + ArrayConverter.bytesToHexString((byte[])modification.getXor()), "BasicMac" + i, (VariableModification)new ByteArrayExplicitValueModification(new byte[80 - macSize - 4]), (VariableModification)modification, null));
            ++i;
        }
        return vectorList;
    }

    List<PaddingVector> createMissingMacByteVectors(CipherSuite suite, ProtocolVersion version) {
        LinkedList<PaddingVector> vectorList = new LinkedList<PaddingVector>();
        int macSize = AlgorithmResolver.getMacAlgorithm(version, suite).getSize();
        byte[] padding = this.createPaddingBytes(80 - macSize);
        vectorList.add(new TrippleVector("MissingMacByteFirst", "MissingMacByteFirst", (VariableModification)new ByteArrayExplicitValueModification(new byte[0]), (VariableModification)new ByteArrayDeleteModification(0, 1), (VariableModification)new ByteArrayExplicitValueModification(padding)));
        padding = this.createPaddingBytes(80 - macSize);
        vectorList.add(new TrippleVector("MissingMacByteLast", "MissingMacByteLast", (VariableModification)new ByteArrayExplicitValueModification(new byte[0]), (VariableModification)new ByteArrayDeleteModification(macSize - 1, 1), (VariableModification)new ByteArrayExplicitValueModification(padding)));
        return vectorList;
    }

    List<PaddingVector> createOnlyPaddingVectors(CipherSuite suite, ProtocolVersion version) {
        LinkedList<PaddingVector> vectorList = new LinkedList<PaddingVector>();
        byte[] plain = this.createPaddingBytes(79);
        vectorList.add(this.createVectorWithPlainData("Plain XF (0xXF=#padding bytes)", "PlainOnlyPadding", plain));
        plain = new byte[]{-1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1};
        vectorList.add(this.createVectorWithPlainData("Plain FF", "PlainTooMuchPadding", plain));
        return vectorList;
    }

    List<PaddingVector> createClassicModifiedPadding(CipherSuite suite, ProtocolVersion version) {
        int macSize = AlgorithmResolver.getMacAlgorithm(version, suite).getSize();
        int paddingValue = 80 - macSize - 1;
        int applicationLength = 0;
        List<PaddingVector> vectorList = this.createClassicModifiedPaddingWithValidMAC(applicationLength, paddingValue, "0");
        vectorList.addAll(this.createClassicModifiedPaddingWithInvalidMAC(applicationLength, paddingValue, "0"));
        paddingValue = 6;
        applicationLength = 80 - macSize - 7;
        vectorList.addAll(this.createClassicModifiedPaddingWithValidMAC(applicationLength, paddingValue, ""));
        vectorList.addAll(this.createClassicModifiedPaddingWithInvalidMAC(applicationLength, paddingValue, ""));
        return vectorList;
    }

    private List<PaddingVector> createClassicModifiedPaddingWithValidMAC(int applicationLength, int paddingValue, String suffix) {
        LinkedList<PaddingVector> vectorList = new LinkedList<PaddingVector>();
        byte[] padding = this.createPaddingBytes(paddingValue);
        padding[0] = (byte)(padding[0] ^ 0x80);
        vectorList.add(new TrippleVector("InvPadValMac-[0]-" + applicationLength + "-" + paddingValue, "InvPadValMacStart" + suffix, (VariableModification)new ByteArrayExplicitValueModification(new byte[applicationLength]), null, (VariableModification)new ByteArrayExplicitValueModification(padding)));
        padding = this.createPaddingBytes(paddingValue);
        int n = paddingValue / 2;
        padding[n] = (byte)(padding[n] ^ 8);
        vectorList.add(new TrippleVector("InvPadValMac-[" + paddingValue / 2 + "]-" + applicationLength + "-" + paddingValue, "InvPadValMacMid" + suffix, (VariableModification)new ByteArrayExplicitValueModification(new byte[applicationLength]), null, (VariableModification)new ByteArrayExplicitValueModification(padding)));
        padding = this.createPaddingBytes(paddingValue);
        int n2 = padding.length - 1;
        padding[n2] = (byte)(padding[n2] ^ 1);
        vectorList.add(new TrippleVector("InvPadValMac-[last]-" + applicationLength + "-" + paddingValue, "InvPadValMacEnd" + suffix, (VariableModification)new ByteArrayExplicitValueModification(new byte[applicationLength]), null, (VariableModification)new ByteArrayExplicitValueModification(padding)));
        return vectorList;
    }

    private List<PaddingVector> createClassicModifiedPaddingWithInvalidMAC(int applicationLength, int paddingValue, String suffix) {
        LinkedList<PaddingVector> vectorList = new LinkedList<PaddingVector>();
        byte[] padding = this.createPaddingBytes(paddingValue);
        vectorList.add(new TrippleVector("ValPadInvMac-[0]-" + applicationLength + "-" + paddingValue, "ValPadInvMacStart" + suffix, (VariableModification)new ByteArrayExplicitValueModification(new byte[applicationLength]), (VariableModification)new ByteArrayXorModification(new byte[]{1}, 0), (VariableModification)new ByteArrayExplicitValueModification(padding)));
        padding = this.createPaddingBytes(paddingValue);
        vectorList.add(new TrippleVector("ValPadInvMac-[8]-" + applicationLength + "-" + paddingValue, "ValPadInvMacMid" + suffix, (VariableModification)new ByteArrayExplicitValueModification(new byte[applicationLength]), (VariableModification)new ByteArrayXorModification(new byte[]{8}, 8), (VariableModification)new ByteArrayExplicitValueModification(padding)));
        padding = this.createPaddingBytes(paddingValue);
        vectorList.add(new TrippleVector("ValPadInvMac-[15]-" + applicationLength + "-" + paddingValue, "ValPadInvMacEnd" + suffix, (VariableModification)new ByteArrayExplicitValueModification(new byte[applicationLength]), (VariableModification)new ByteArrayXorModification(new byte[]{-128}, 15), (VariableModification)new ByteArrayExplicitValueModification(padding)));
        padding = this.createPaddingBytes(paddingValue);
        padding[0] = (byte)(padding[0] ^ 0x80);
        vectorList.add(new TrippleVector("InvPadInvMac-[0]-" + applicationLength + "-" + paddingValue, "InvPadInvMacStart" + suffix, (VariableModification)new ByteArrayExplicitValueModification(new byte[applicationLength]), (VariableModification)new ByteArrayXorModification(new byte[]{1}, 0), (VariableModification)new ByteArrayExplicitValueModification(padding)));
        padding = this.createPaddingBytes(paddingValue);
        int n = paddingValue / 2;
        padding[n] = (byte)(padding[n] ^ 8);
        vectorList.add(new TrippleVector("InvPadInvMac-[" + paddingValue / 2 + "]-" + applicationLength + "-" + paddingValue, "InvPadInvMacMid" + suffix, (VariableModification)new ByteArrayExplicitValueModification(new byte[applicationLength]), (VariableModification)new ByteArrayXorModification(new byte[]{1}, 0), (VariableModification)new ByteArrayExplicitValueModification(padding)));
        padding = this.createPaddingBytes(paddingValue);
        int n2 = padding.length - 1;
        padding[n2] = (byte)(padding[n2] ^ 1);
        vectorList.add(new TrippleVector("InvPadInvMac-[last]-" + applicationLength + "-" + paddingValue, "InvPadInvMacEnd" + suffix, (VariableModification)new ByteArrayExplicitValueModification(new byte[applicationLength]), (VariableModification)new ByteArrayXorModification(new byte[]{1}, 0), (VariableModification)new ByteArrayExplicitValueModification(padding)));
        return vectorList;
    }

    List<ByteArrayXorModification> createFlippedModifications(int byteLength) {
        LinkedList<ByteArrayXorModification> modificationList = new LinkedList<ByteArrayXorModification>();
        modificationList.add(new ByteArrayXorModification(new byte[]{1}, byteLength - 1));
        modificationList.add(new ByteArrayXorModification(new byte[]{8}, byteLength / 2));
        modificationList.add(new ByteArrayXorModification(new byte[]{-128}, 0));
        return modificationList;
    }

    private PaddingVector createVectorWithPlainData(String name, String identifier, byte[] plain) {
        return new PlainPaddingVector(name, identifier, (ByteArrayExplicitValueModification)ByteArrayModificationFactory.explicitValue((byte[])plain));
    }
}

