# coding: utf-8

"""
InfluxDB OSS API Service.

The InfluxDB v2 API provides a programmatic interface for all interactions with InfluxDB. Access the InfluxDB API using the `/api/v2/` endpoint.   # noqa: E501

OpenAPI spec version: 2.0.0
Generated by: https://openapi-generator.tech
"""


import pprint
import re  # noqa: F401


class MeasurementSchema(object):
    """NOTE: This class is auto generated by OpenAPI Generator.

    Ref: https://openapi-generator.tech

    Do not edit the class manually.
    """

    """
    Attributes:
      openapi_types (dict): The key is attribute name
                            and the value is attribute type.
      attribute_map (dict): The key is attribute name
                            and the value is json key in definition.
    """
    openapi_types = {
        'id': 'str',
        'org_id': 'str',
        'bucket_id': 'str',
        'name': 'str',
        'columns': 'list[MeasurementSchemaColumn]',
        'created_at': 'datetime',
        'updated_at': 'datetime'
    }

    attribute_map = {
        'id': 'id',
        'org_id': 'orgID',
        'bucket_id': 'bucketID',
        'name': 'name',
        'columns': 'columns',
        'created_at': 'createdAt',
        'updated_at': 'updatedAt'
    }

    def __init__(self, id=None, org_id=None, bucket_id=None, name=None, columns=None, created_at=None, updated_at=None):  # noqa: E501,D401,D403
        """MeasurementSchema - a model defined in OpenAPI."""  # noqa: E501
        self._id = None
        self._org_id = None
        self._bucket_id = None
        self._name = None
        self._columns = None
        self._created_at = None
        self._updated_at = None
        self.discriminator = None

        self.id = id
        if org_id is not None:
            self.org_id = org_id
        if bucket_id is not None:
            self.bucket_id = bucket_id
        self.name = name
        self.columns = columns
        self.created_at = created_at
        self.updated_at = updated_at

    @property
    def id(self):
        """Get the id of this MeasurementSchema.

        :return: The id of this MeasurementSchema.
        :rtype: str
        """  # noqa: E501
        return self._id

    @id.setter
    def id(self, id):
        """Set the id of this MeasurementSchema.

        :param id: The id of this MeasurementSchema.
        :type: str
        """  # noqa: E501
        if id is None:
            raise ValueError("Invalid value for `id`, must not be `None`")  # noqa: E501
        self._id = id

    @property
    def org_id(self):
        """Get the org_id of this MeasurementSchema.

        The ID of the organization.

        :return: The org_id of this MeasurementSchema.
        :rtype: str
        """  # noqa: E501
        return self._org_id

    @org_id.setter
    def org_id(self, org_id):
        """Set the org_id of this MeasurementSchema.

        The ID of the organization.

        :param org_id: The org_id of this MeasurementSchema.
        :type: str
        """  # noqa: E501
        self._org_id = org_id

    @property
    def bucket_id(self):
        """Get the bucket_id of this MeasurementSchema.

        The ID of the bucket that the measurement schema is associated with.

        :return: The bucket_id of this MeasurementSchema.
        :rtype: str
        """  # noqa: E501
        return self._bucket_id

    @bucket_id.setter
    def bucket_id(self, bucket_id):
        """Set the bucket_id of this MeasurementSchema.

        The ID of the bucket that the measurement schema is associated with.

        :param bucket_id: The bucket_id of this MeasurementSchema.
        :type: str
        """  # noqa: E501
        self._bucket_id = bucket_id

    @property
    def name(self):
        """Get the name of this MeasurementSchema.

        :return: The name of this MeasurementSchema.
        :rtype: str
        """  # noqa: E501
        return self._name

    @name.setter
    def name(self, name):
        """Set the name of this MeasurementSchema.

        :param name: The name of this MeasurementSchema.
        :type: str
        """  # noqa: E501
        if name is None:
            raise ValueError("Invalid value for `name`, must not be `None`")  # noqa: E501
        self._name = name

    @property
    def columns(self):
        """Get the columns of this MeasurementSchema.

        Ordered collection of column definitions.

        :return: The columns of this MeasurementSchema.
        :rtype: list[MeasurementSchemaColumn]
        """  # noqa: E501
        return self._columns

    @columns.setter
    def columns(self, columns):
        """Set the columns of this MeasurementSchema.

        Ordered collection of column definitions.

        :param columns: The columns of this MeasurementSchema.
        :type: list[MeasurementSchemaColumn]
        """  # noqa: E501
        if columns is None:
            raise ValueError("Invalid value for `columns`, must not be `None`")  # noqa: E501
        self._columns = columns

    @property
    def created_at(self):
        """Get the created_at of this MeasurementSchema.

        :return: The created_at of this MeasurementSchema.
        :rtype: datetime
        """  # noqa: E501
        return self._created_at

    @created_at.setter
    def created_at(self, created_at):
        """Set the created_at of this MeasurementSchema.

        :param created_at: The created_at of this MeasurementSchema.
        :type: datetime
        """  # noqa: E501
        if created_at is None:
            raise ValueError("Invalid value for `created_at`, must not be `None`")  # noqa: E501
        self._created_at = created_at

    @property
    def updated_at(self):
        """Get the updated_at of this MeasurementSchema.

        :return: The updated_at of this MeasurementSchema.
        :rtype: datetime
        """  # noqa: E501
        return self._updated_at

    @updated_at.setter
    def updated_at(self, updated_at):
        """Set the updated_at of this MeasurementSchema.

        :param updated_at: The updated_at of this MeasurementSchema.
        :type: datetime
        """  # noqa: E501
        if updated_at is None:
            raise ValueError("Invalid value for `updated_at`, must not be `None`")  # noqa: E501
        self._updated_at = updated_at

    def to_dict(self):
        """Return the model properties as a dict."""
        result = {}

        for attr, _ in self.openapi_types.items():
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], "to_dict") else item,
                    value.items()
                ))
            else:
                result[attr] = value

        return result

    def to_str(self):
        """Return the string representation of the model."""
        return pprint.pformat(self.to_dict())

    def __repr__(self):
        """For `print` and `pprint`."""
        return self.to_str()

    def __eq__(self, other):
        """Return true if both objects are equal."""
        if not isinstance(other, MeasurementSchema):
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        """Return true if both objects are not equal."""
        return not self == other
