info = {
    "name": "cs",
    "date_order": "DMY",
    "january": [
        "led",
        "leden",
        "ledna"
    ],
    "february": [
        "úno",
        "únor",
        "února"
    ],
    "march": [
        "bře",
        "březen",
        "března"
    ],
    "april": [
        "dub",
        "duben",
        "dubna"
    ],
    "may": [
        "kvě",
        "květen",
        "května"
    ],
    "june": [
        "červen",
        "června",
        "čvn",
        "Čer"
    ],
    "july": [
        "července",
        "červenec",
        "čvc",
        "Črc"
    ],
    "august": [
        "srp",
        "srpen",
        "srpna"
    ],
    "september": [
        "zář",
        "září"
    ],
    "october": [
        "říj",
        "říjen",
        "října"
    ],
    "november": [
        "lis",
        "listopad",
        "listopadu"
    ],
    "december": [
        "pro",
        "prosince",
        "prosinec"
    ],
    "monday": [
        "po",
        "pondělí",
        "Pon"
    ],
    "tuesday": [
        "út",
        "úterý",
        "Úte"
    ],
    "wednesday": [
        "st",
        "středa",
        "Stř",
        "Středu"
    ],
    "thursday": [
        "čt",
        "čtvrtek",
        "Čtv"
    ],
    "friday": [
        "pá",
        "pátek",
        "Pát"
    ],
    "saturday": [
        "so",
        "sobota",
        "Sob",
        "Sobotu"
    ],
    "sunday": [
        "ne",
        "neděle",
        "Ned",
        "Neděli"
    ],
    "am": [
        "dop"
    ],
    "pm": [
        "odp"
    ],
    "year": [
        "r",
        "rok",
        "roků",
        "roky"
    ],
    "month": [
        "měs",
        "měsíc",
        "měsíců",
        "měsíce",
        "měsícem"
    ],
    "week": [
        "týd",
        "týden",
        "týdnů",
        "týdny",
        "týdnem"
    ],
    "day": [
        "den",
        "dnů",
        "dny"
    ],
    "hour": [
        "h",
        "hodina",
        "hodin",
        "hodiny",
        "hodinou",
        "hodinu",
        "hodinami"
    ],
    "minute": [
        "min",
        "minuta",
        "minut",
        "minutami",
        "minuty"
    ],
    "second": [
        "s",
        "sekunda",
        "sekundy",
        "sekund",
        "vteřina",
        "vteřin",
        "vteřiny"
    ],
    "relative-type": {
        "0 day ago": [
            "dnes"
        ],
        "0 hour ago": [
            "tuto hodinu"
        ],
        "0 minute ago": [
            "tuto minutu"
        ],
        "0 month ago": [
            "tento měsíc"
        ],
        "0 second ago": [
            "nyní"
        ],
        "0 week ago": [
            "tento týd",
            "tento týden"
        ],
        "0 year ago": [
            "tento rok"
        ],
        "1 day ago": [
            "včera"
        ],
        "1 month ago": [
            "minulý měsíc"
        ],
        "1 week ago": [
            "minulý týd",
            "minulý týden"
        ],
        "1 year ago": [
            "minulý rok"
        ],
        "in 1 day": [
            "zítra"
        ],
        "in 1 month": [
            "příští měsíc"
        ],
        "in 1 week": [
            "příští týd",
            "příští týden"
        ],
        "in 1 year": [
            "příští rok"
        ],
        "2 day ago": [
            "předevčírem"
        ]
    },
    "relative-type-regex": {
        "\\1 day ago": [
            "před (\\d+[.,]?\\d*) dnem",
            "před (\\d+[.,]?\\d*) dny"
        ],
        "\\1 hour ago": [
            "před (\\d+[.,]?\\d*) h",
            "před (\\d+[.,]?\\d*) hodinami",
            "před (\\d+[.,]?\\d*) hodinou"
        ],
        "\\1 minute ago": [
            "před (\\d+[.,]?\\d*) min",
            "před (\\d+[.,]?\\d*) minutami",
            "před (\\d+[.,]?\\d*) minutou"
        ],
        "\\1 month ago": [
            "před (\\d+[.,]?\\d*) měs",
            "před (\\d+[.,]?\\d*) měsícem",
            "před (\\d+[.,]?\\d*) měsíci"
        ],
        "\\1 second ago": [
            "před (\\d+[.,]?\\d*) s",
            "před (\\d+[.,]?\\d*) sekundami",
            "před (\\d+[.,]?\\d*) sekundou"
        ],
        "\\1 week ago": [
            "před (\\d+[.,]?\\d*) týd",
            "před (\\d+[.,]?\\d*) týdnem",
            "před (\\d+[.,]?\\d*) týdny"
        ],
        "\\1 year ago": [
            "před (\\d+[.,]?\\d*) l",
            "před (\\d+[.,]?\\d*) lety",
            "před (\\d+[.,]?\\d*) r",
            "před (\\d+[.,]?\\d*) rokem"
        ],
        "in \\1 day": [
            "za (\\d+[.,]?\\d*) den",
            "za (\\d+[.,]?\\d*) dní"
        ],
        "in \\1 hour": [
            "za (\\d+[.,]?\\d*) h",
            "za (\\d+[.,]?\\d*) hodin",
            "za (\\d+[.,]?\\d*) hodinu"
        ],
        "in \\1 minute": [
            "za (\\d+[.,]?\\d*) min",
            "za (\\d+[.,]?\\d*) minut",
            "za (\\d+[.,]?\\d*) minutu"
        ],
        "in \\1 month": [
            "za (\\d+[.,]?\\d*) měs",
            "za (\\d+[.,]?\\d*) měsíc",
            "za (\\d+[.,]?\\d*) měsíců"
        ],
        "in \\1 second": [
            "za (\\d+[.,]?\\d*) s",
            "za (\\d+[.,]?\\d*) sekund",
            "za (\\d+[.,]?\\d*) sekundu"
        ],
        "in \\1 week": [
            "za (\\d+[.,]?\\d*) týd",
            "za (\\d+[.,]?\\d*) týden",
            "za (\\d+[.,]?\\d*) týdnů"
        ],
        "in \\1 year": [
            "za (\\d+[.,]?\\d*) l",
            "za (\\d+[.,]?\\d*) let",
            "za (\\d+[.,]?\\d*) r",
            "za (\\d+[.,]?\\d*) rok"
        ]
    },
    "locale_specific": {},
    "skip": [
        "přibližně",
        "v",
        " ",
        "'",
        ",",
        "-",
        ".",
        "/",
        ";",
        "@",
        "[",
        "]",
        "|",
        "，"
    ],
    "sentence_splitter_group": 1,
    "ago": [
        "před"
    ],
    "in": [
        "ve",
        "v"
    ],
    "simplifications": [
        {
            "teď": "0 sekunda"
        }
    ]
}
