"""
Setup Reactor

Example Config in Master or Minion config

.. code-block:: yaml

    engines:
      - reactor:
          refresh_interval: 60
          worker_threads: 10
          worker_hwm: 10000

    reactor:
      - 'salt/cloud/*/destroyed':
        - /srv/reactor/destroy/*.sls

"""

import salt.utils.reactor


def start(refresh_interval=None, worker_threads=None, worker_hwm=None):
    if refresh_interval is not None:
        __opts__["reactor_refresh_interval"] = refresh_interval
    if worker_threads is not None:
        __opts__["reactor_worker_threads"] = worker_threads
    if worker_hwm is not None:
        __opts__["reactor_worker_hwm"] = worker_hwm

    salt.utils.reactor.Reactor(__opts__).run()
