/*
 * Decompiled with CFR 0.152.
 */
package com.amazon.aes.webservices.client.cmd;

import com.amazon.aes.webservices.client.Jec2;
import com.amazon.aes.webservices.client.RequestResult;
import com.amazon.aes.webservices.client.RequestResultPair;
import com.amazon.aes.webservices.client.cmd.BaseCmd;
import com.amazon.aes.webservices.client.cmd.Outputter;
import com.amazonaws.services.ec2.model.VpcPeeringConnection;
import org.apache.commons.cli.OptionBuilder;
import org.apache.commons.cli.Options;

public class CreateVpcPeeringConnection
extends BaseCmd {
    public static String[] VPC_DESC = new String[]{"The ID of your VPC which you are creating a VPC Peering Connection with."};
    public static String[] PEER_VPC_DESC = new String[]{"The ID of the Peer VPC which you are creating a VPC Peering Connection with.", "If the VPC belongs to an account other than yours, you must also specify the Peer Owner ID (-o | --peer-owner-id)."};
    public static String[] PEER_OWNER_ID_DESC = new String[]{"The account ID of the owner of the Peer VPC you are peering with.Defaults to your account ID."};

    public CreateVpcPeeringConnection(String[] args) {
        super("ec2addpcx", "ec2-create-vpc-peering-connection");
        this.init(this.getOptions());
        this.parseOpts(args);
    }

    protected Options getOptions() {
        Options o = new Options();
        OptionBuilder.withLongOpt((String)"vpc");
        OptionBuilder.hasArg();
        OptionBuilder.withArgName((String)"VPC");
        OptionBuilder.withDescription((String)CreateVpcPeeringConnection.joinDescription(VPC_DESC));
        o.addOption(OptionBuilder.create((String)"c"));
        OptionBuilder.withLongOpt((String)"peer-vpc");
        OptionBuilder.hasArg();
        OptionBuilder.withArgName((String)"VPC");
        OptionBuilder.withDescription((String)CreateVpcPeeringConnection.joinDescription(PEER_VPC_DESC));
        o.addOption(OptionBuilder.create((String)"p"));
        OptionBuilder.withLongOpt((String)"peer-owner-id");
        OptionBuilder.hasArg();
        OptionBuilder.withArgName((String)"PEER_OWNER_ID");
        OptionBuilder.withDescription((String)CreateVpcPeeringConnection.joinDescription(PEER_OWNER_ID_DESC));
        o.addOption(OptionBuilder.create((String)"o"));
        return o;
    }

    @Override
    protected String getOptionString() {
        return "-c VPC -p VPC [-o PEER_OWNER_ID]";
    }

    @Override
    public void printDescription() {
        super.printDescription();
        System.out.println("     Creates a new VPC Peering Connection between two VPCs.");
    }

    @Override
    public void printOptions() {
        super.printOptions(true);
        super.printOption("vpc");
        super.printOption("peer-vpc");
        super.printOption("peer-owner-id");
    }

    @Override
    protected boolean invokeOnline(Jec2 jec2, Outputter out) throws Exception {
        this.assertOptionSet("vpc");
        this.assertOptionSet("peer-vpc");
        this.warnIfTooManyNonOptions();
        RequestResultPair result = jec2.createVpcPeeringConnection(this.getOptionValue("vpc"), this.getOptionValue("peer-vpc"), this.getOptionValue("peer-owner-id"));
        out.outputVpcPeeringConnection(System.out, (VpcPeeringConnection)result.getResponse());
        out.printRequestId(System.out, (RequestResult)result);
        return true;
    }

    public static void main(String[] args) {
        new CreateVpcPeeringConnection(args).invoke();
    }
}

