/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.xfire.spring.config;

import java.lang.reflect.Constructor;
import org.codehaus.xfire.XFireRuntimeException;
import org.codehaus.xfire.service.ServiceFactory;
import org.codehaus.xfire.service.binding.BindingProvider;
import org.codehaus.xfire.service.binding.ObjectServiceFactory;
import org.codehaus.xfire.transport.TransportManager;
import org.codehaus.xfire.util.ClassLoaderUtils;
import org.springframework.beans.factory.FactoryBean;

public class ServiceFactoryBean
implements FactoryBean {
    private static final String JSR181_FACTORY = "jsr181";
    private static final String COMMONS_FACTORY = "commons-attributes";
    private String name;
    private TransportManager transportManager;
    ObjectServiceFactory factory;

    public ServiceFactoryBean(String name) {
        this.name = name;
    }

    public TransportManager getTransportManager() {
        return this.transportManager;
    }

    public void setTransportManager(TransportManager transportManager) {
        this.transportManager = transportManager;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public Object getObject() throws Exception {
        if (this.factory == null) {
            this.initialize();
        }
        return this.factory;
    }

    public void initialize() throws Exception {
        String serviceFactory = this.name;
        this.factory = JSR181_FACTORY.equals(serviceFactory) || COMMONS_FACTORY.equals(serviceFactory) ? this.getAnnotationServiceFactory(serviceFactory) : this.loadServiceFactory(serviceFactory);
    }

    public Class getObjectType() {
        return ServiceFactory.class;
    }

    public boolean isSingleton() {
        return false;
    }

    protected ObjectServiceFactory getAnnotationServiceFactory(String annotationType) throws Exception {
        Class annotsClz = null;
        Class clz = this.loadClass("org.codehaus.xfire.annotations.AnnotationServiceFactory");
        if (JSR181_FACTORY.equals(annotationType)) {
            annotsClz = this.loadClass("org.codehaus.xfire.annotations.jsr181.Jsr181WebAnnotations");
        } else if (COMMONS_FACTORY.equals(annotationType)) {
            annotsClz = this.loadClass("org.codehaus.xfire.annotations.commons.CommonsWebAttributes");
        }
        Class webAnnot = this.loadClass("org.codehaus.xfire.annotations.WebAnnotations");
        Constructor con = clz.getConstructor(webAnnot, TransportManager.class, BindingProvider.class);
        return (ObjectServiceFactory)con.newInstance(annotsClz.newInstance(), this.getTransportManager(), null);
    }

    protected ObjectServiceFactory loadServiceFactory(String serviceFactoryName) {
        ObjectServiceFactory factory = null;
        if (serviceFactoryName.length() > 0) {
            try {
                Class clz = this.loadClass(serviceFactoryName);
                TransportManager tman = this.getTransportManager();
                Constructor con = null;
                Object[] arguments = null;
                try {
                    con = clz.getConstructor(TransportManager.class, BindingProvider.class);
                    arguments = new Object[]{tman, null};
                }
                catch (NoSuchMethodException e) {
                    try {
                        con = clz.getConstructor(TransportManager.class);
                        arguments = new Object[]{tman};
                    }
                    catch (NoSuchMethodException e1) {
                        con = clz.getConstructor(new Class[0]);
                        arguments = new Object[]{};
                    }
                }
                factory = (ObjectServiceFactory)con.newInstance(arguments);
            }
            catch (Exception e) {
                throw new XFireRuntimeException("Could not load service factory: " + serviceFactoryName, e);
            }
        }
        throw new XFireRuntimeException("serviceFactory element cannot be empty.");
        return factory;
    }

    protected Class loadClass(String className) throws Exception {
        if (className.endsWith("[]")) {
            className = "[L" + className.substring(0, className.length() - 2) + ";";
        }
        return ClassLoaderUtils.loadClass(className, this.getClass());
    }
}

