<?php

/**
 * ⚠️ Editing not allowed except for 'en' language.
 *
 * @see https://github.com/monicahq/monica/blob/main/docs/contribute/translate.md for translations.
 */

return [
    'sidebar_settings' => 'Ajustes de conta',
    'sidebar_personalization' => 'Personalização',
    'sidebar_settings_storage' => 'Armazenamento',
    'sidebar_settings_export' => 'Exportar dados',
    'sidebar_settings_users' => 'Usuários',
    'sidebar_settings_subscriptions' => 'Assinatura',
    'sidebar_settings_import' => 'Importar dados',
    'sidebar_settings_tags' => 'Gerenciar tags',
    'sidebar_settings_api' => 'API',
    'sidebar_settings_dav' => 'DAV Resources',
    'sidebar_settings_security' => 'Segurança',
    'sidebar_settings_auditlogs' => 'Registros de Auditoria',

    'title_general' => 'Informações Gerais',
    'title_i18n' => 'Configurações internacionais',
    'title_layout' => 'Layout',

    'me_title' => 'Eu como contato',
    'me_help' => 'Este é o contato que <em>te</em> representa em Monica',
    'me_select' => 'Selecione um contato',
    'me_no_contact' => 'Nenhum contato selecionado.',
    'me_select_click' => 'Clique aqui para selecionar um contato.',
    'me_remove_contact' => 'Remover a associação',
    'me_choose' => 'Escolha-se',
    'me_choose_placeholder' => 'Escolha-se',

    'export_title' => 'Exporte os dados da sua conta',
    'export_be_patient' => 'Click the button to start the export. It might take several minutes to process the export – please be patient and do not spam the button.',
    'export_title_sql' => 'Export to SQL',
    'export_sql_explanation' => 'Exporting your data in SQL format allows you to take your data and import it to your own Monica instance. This is only valuable if you do have your own server.',
    'export_sql_cta' => 'Export to SQL',
    'export_sql_link_instructions' => 'Note: <a href=":url">read the instructions</a> to learn more about importing this file to your instance.',
    'export_title_json' => 'Export to Json',
    'export_submitted' => 'Your export has been submitted, it will be available in a few moment…',
    'export_json_explanation' => 'Exporting your data in Json format for backup.',
    'export_json_beta' => 'Json export is in preview mode. Tell us what you think about it:',
    'export_json_cta' => 'Export to Json',
    'export_header_type' => 'Type',
    'export_header_timestamp' => 'Creation date',
    'export_header_status' => 'Status',
    'export_header_actions' => 'Actions',
    'export_last_title' => 'Last exports',
    'export_empty_title' => 'No exports yet',
    'export_type_json' => 'Json export',
    'export_type_sql' => 'SQL export',
    'export_status_todo' => 'Submitted',
    'export_status_doing' => 'Doing',
    'export_status_done' => 'Done',
    'export_status_failed' => 'Failed',
    'export_not_done' => 'Download impossible, this export is not done yet.',

    'firstname' => 'Nome',
    'lastname' => 'Sobrenome',
    'name_order' => 'Ordem de nome',
    'name_order_firstname_lastname' => '<First name> <Last name> – João Silva',
    'name_order_lastname_firstname' => '<Last name> <First name> – Silva João',
    'name_order_firstname_lastname_nickname' => '<First name> <Last name> (<Nickname>) – João Silva (Jão)',
    'name_order_firstname_nickname_lastname' => '<First name> (<Nickname>) <Last name> – João (Jão) Silva',
    'name_order_lastname_firstname_nickname' => '<Last name> <First name> (<Nickname>) – Silva João (Jão)',
    'name_order_lastname_nickname_firstname' => '<Last name> (<Nickname>) <First name> – Silva (Jão) João',
    'name_order_nickname_firstname_lastname' => '<Nickname> (<First name> <Last name>) – Jão (João Silva)',
    'name_order_nickname_lastname_firstname' => '<Nickname> (<Last name> <First name>) – Rambo (Doe John)',
    'name_order_nickname' => '<Nickname> – Jão',
    'currency' => 'Moeda',
    'name' => 'Seu nome: :name',
    'email' => 'Endereço de e-mail',
    'email_placeholder' => 'Digite o seu e-mail',
    'email_help' => 'Este é o email usado para fazer login, e é para cá que Monica enviará seus lembretes.',
    'timezone' => 'Fuso horário',
    'temperature_scale' => 'Escala de temperatura',
    'temperature_scale_fahrenheit' => 'Fahrenheit (°F)',
    'temperature_scale_celsius' => 'Celsius (°C)',
    'layout' => 'Layout',
    'layout_small' => 'Máximo 1200 pixels de largura',
    'layout_big' => 'Largura total do navegador',
    'save' => 'Atualizar preferências',
    'delete_title' => 'Excluir sua conta',
    'delete_desc' => 'Deseja excluir sua conta? A exclusão é permanente e todos os seus dados serão apagados permanentemente. Se você tiver uma assinatura, ela será cancelada imediatamente.',
    'delete_other_desc' => 'Your data in the main database will be deleted immediately. As described in our privacy policy, we carry out securely encrypted backups of the database every day.  These backups are kept for 30 days after which they are completely deleted. We cannot delete specific data from the backups we hold any earlier than this.  All of your data will be completely deleted no later than 31 days after your account’s deletion.',
    'reset_desc' => 'Gostaria de redefinir sua conta? Todos os seus contatos e dados serão removidos permanentemente, mas sua conta não será excluída.',
    'reset_title' => 'Redefinir sua conta',
    'reset_cta' => 'Redefinir conta',
    'reset_notice' => 'Tem certeza de que deseja redefinir sua conta? Isso é permanente e não pode ser desfeito.',
    'reset_success' => 'Sua conta foi redefinida com sucesso.',
    'delete_notice' => 'Tem certeza que deseja apagar sua conta? Isso é permanente e não pode ser desfeito. Todos os seus dados serão excluídos e não poderão ser recuperados.',
    'delete_cta' => 'Deletar conta',
    'settings_success' => 'Preferências atualizadas!',
    'locale' => 'Idioma usado no aplicativo',
    'locale_help' => 'Você quer ajudar a traduzir Monica ou adicionar um novo idioma? Por favor, siga <a href=":url" target="_blank" lang="en">este link para mais informações</a>.',
    'locale_ar' => 'Árabe',
    'locale_cs' => 'Tcheco',
    'locale_de' => 'Alemão',
    'locale_el' => 'Grego',
    'locale_en' => 'Inglês',
    'locale_en-GB' => 'Inglês (Reino Unido)',
    'locale_es' => 'Espanhol',
    'locale_fr' => 'Francês',
    'locale_he' => 'Hebraico',
    'locale_hr' => 'Croata',
    'locale_id' => 'Indonésio',
    'locale_it' => 'Italiano',
    'locale_ja' => 'Japonês',
    'locale_nl' => 'Nederlands',
    'locale_pt' => 'Português',
    'locale_pt-BR' => 'Português do Brasil',
    'locale_ru' => 'Russo',
    'locale_sv' => 'Sueco',
    'locale_vi' => 'Vietnamita',
    'locale_zh' => 'Chinês (Simplificado)',
    'locale_zh-TW' => 'Chinês Tradicional',
    'locale_tr' => 'Turco',

    'security_title' => 'Segurança',
    'security_help' => 'Altere as informações de segurança da sua conta.',
    'password_change' => 'Redefina sua senha',
    'password_current' => 'Senha atual',
    'password_current_placeholder' => 'Digite a sua senha atual',
    'password_new1' => 'Nova senha',
    'password_new1_placeholder' => 'Digite sua nova senha',
    'password_new2' => 'Confirme sua nova senha',
    'password_new2_placeholder' => 'Redigite sua nova senha',
    'password_btn' => 'Alterar senha',
    '2fa_title' => 'Autenticação de dois fatores',
    '2fa_otp_title' => 'Aplicativo para autenticação de dois fatores',
    '2fa_enable_title' => 'Ativar Autenticação de dois fatores',
    '2fa_enable_description' => 'Ative a autenticação de dois fatores para proteger sua conta.',
    '2fa_enable_otp' => 'Abra o seu aplicativo de autenticação de dois fatores e aponte o celular para essa tela para capturar o código QR:',
    '2fa_enable_otp_help' => 'Se o seu aplicativo móvel de Autenticação em Duas Etapas não suporte códigos de barras QR, digite o seguinte código:',
    '2fa_enable_otp_validate' => 'Por favor, confirme o novo dispositivo que você acabou de configurar:',
    '2fa_enable_success' => 'Autenticação de dois fatores ativada',
    '2fa_enable_error' => 'Erro ao tentar ativar a autenticação de dois fatores',
    '2fa_enable_error_already_set' => 'Autenticação de dois fatores já está ativada',
    '2fa_disable_title' => 'Desativar autenticação de dois fatores',
    '2fa_disable_description' => 'Desative a Autenticação em Duas Etapas para sua conta. Tenha cuidado, sua conta estará muito menos segura!',
    '2fa_disable_success' => 'Autenticação de Dois Fatores desativada',
    '2fa_disable_error' => 'Erro ao tentar desativar a Autenticação em Duas Etapas',

    'webauthn_title' => 'Chave de segurança — protocolo WebAuthn',
    'webauthn_enable_description' => 'Adicionar uma nova regra de segurança',
    'webauthn_key_name_help' => 'Dê um nome à sua chave.',
    'webauthn_key_name' => 'Nome da chave:',
    'webauthn_success' => 'Sua chave foi detectada e validada.',
    'webauthn_last_use' => 'Último uso: {timestamp}',
    'webauthn_delete_confirmation' => 'Você tem certeza que deseja excluir esta chave?',
    'webauthn_delete_success' => 'Chave excluída',
    'webauthn_insertKey' => 'Insira a sua chave de segurança.',
    'webauthn_buttonAdvise' => 'Se a sua chave de segurança tiver um botão, pressione-o.',
    'webauthn_noButtonAdvise' => 'Se não, remova-o e insira-o novamente.',
    'webauthn_not_supported' => 'Seu navegador atualmente não oferece suporte ao WebAuthn.',
    'webauthn_not_secured' => 'WebAuthn suporta apenas conexões seguras. Por favor, carregue esta página com o padrão https.',
    'webauthn_error_already_used' => 'Esta chave já está registrada. Não é necessário registrá-la novamente.',
    'webauthn_error_not_allowed' => 'A operação expirou ou não foi permitida.',

    'recovery_title' => 'Códigos de recuperação',
    'recovery_show' => 'Obter códigos de recuperação',
    'recovery_copy_help' => 'Copiar códigos para a área de transferência',
    'recovery_help_intro' => 'Estes são os seus códigos de recuperação:',
    'recovery_help_information' => 'Você pode usar cada código de recuperação uma única vez.',
    'recovery_clipboard' => 'Códigos copiados para a área de transferência.',
    'recovery_generate' => 'Gerar novos códigos…',
    'recovery_generate_help' => 'Gerar novos códigos invalidará os códigos gerados anteriormente.',
    'recovery_already_used_help' => 'Esse código já foi usado.',

    'users_list_title' => 'Usuários com acesso à sua conta',
    'users_list_add_user' => 'Convidar um novo usuário',
    'users_list_you' => 'É isso',
    'users_list_invitations_title' => 'Convites pendentes',
    'users_list_invitations_explanation' => 'Abaixo estão as pessoas que você convidou para se juntar a Monica como colaborador.',
    'users_list_invitations_invited_by' => 'convidado por :name',
    'users_list_invitations_sent_date' => 'enviado em :date',
    'users_blank_title' => 'Você é o único que tem acesso a essa conta.',
    'users_blank_add_title' => 'Você gostaria de convidar outra pessoa?',
    'users_blank_description' => 'Essa pessoa terá o mesmo acesso que você tem e poderá adicionar, editar ou excluir informações de contato.',
    'users_blank_cta' => 'Convidar alguém',
    'users_add_title' => 'Convide um novo usuário para sua conta por e-mail',
    'users_add_description' => 'Essa pessoa terá o mesmo acesso que você, incluindo convidar ou excluir outros usuários, incluindo você. Certifique-se de que você confia nessa pessoa antes de lhe dar acesso.',
    'users_add_email_field' => 'Digite o e-mail da pessoa que você deseja convidar',
    'users_add_confirmation' => 'Eu confirmo que eu quero convidar esse usuário para minha conta. Compreendo que esta pessoa terá acesso a TODOS os meus dados e verá exatamente o que eu vejo.',
    'users_add_cta' => 'Convidar usuário por e-mail',
    'users_accept_title' => 'Aceite o convite e crie uma nova conta',
    'users_error_please_confirm' => 'Por favor, confirme que você deseja convidar este usuário antes de prosseguir com o convite',
    'users_error_email_already_taken' => 'Este e-mail já está em uso. Por favor, escolha outro',
    'users_error_already_invited' => 'Você já convidou este usuário. Por favor, escolha outro endereço de e-mail.',
    'users_error_email_not_similar' => 'Este não é o e-mail da pessoa que te convidou.',
    'users_invitation_deleted_confirmation_message' => 'O convite foi excluído com sucesso',
    'users_invitations_delete_confirmation' => 'Tem certeza de que deseja excluir este convite?',
    'users_list_delete_confirmation' => 'Tem certeza que deseja excluir este usuário da sua conta?',
    'users_invitation_need_subscription' => 'Adicionar mais usuários requer uma assinatura.',

    'subscriptions_account_current_plan' => 'Seu plano atual',
    'subscriptions_account_current_legacy' => 'Plano atual, não pode mais ser selecionado:',
    'subscriptions_account_current_paid_plan' => 'Você está no plano :name. Muito obrigado por ser um assinante.',

    'subscriptions_account_next_billing_title' => 'Próximo pagamento',
    'subscriptions_account_next_billing' => 'Sua assinatura será renovada automaticamente em <strong>:date</strong>.',
    'subscriptions_account_bill_monthly' => 'Vamos cobrar <strong>:price</strong> por mais um <strong>mês</strong>.',
    'subscriptions_account_bill_annual' => 'Vamos cobrar <strong>:price</strong> por mais um <strong>ano</strong>.',
    'subscriptions_account_change' => 'Alterar Plano',

    'subscriptions_account_cancel_title' => 'Cancelar assinatura',
    'subscriptions_account_cancel_action' => 'Cancelar assinatura',
    'subscriptions_account_cancel' => 'Você pode <a href=":url">cancelar a assinatura</a> a qualquer momento.',
    'subscriptions_account_free_plan' => 'Você está no plano gratuito.',
    'subscriptions_account_free_plan_upgrade' => 'Você pode fazer um upgrade na sua conta para o plano :name, que custa $:price por mês. Aqui estão as vantagens:',
    'subscriptions_account_free_plan_benefits_users' => 'Número ilimitado de usuários',
    'subscriptions_account_free_plan_benefits_reminders' => 'Lembretes por email',
    'subscriptions_account_free_plan_benefits_import_data_vcard' => 'Importe seus contatos com vCard',
    'subscriptions_account_free_plan_benefits_support' => 'Apoie o projeto a longo prazo, para que possamos introduzir recursos mais importantes.',
    'subscriptions_account_upgrade' => 'Faça um upgrade na sua conta',
    'subscriptions_account_upgrade_title' => 'Faça um upgrade no Monica hoje e tenha relações mais significativas.',
    'subscriptions_account_upgrade_choice' => 'Escolha um plano abaixo e junte-se a :customers pessoas que fizeram upgrade em seu Monica.',
    'subscriptions_account_update_title' => 'Atualizar minha Assinatura',
    'subscriptions_account_update_description' => 'Aqui você pode alterar a frequência de pagamento da sua assinatura.',
    'subscriptions_account_update_information' => 'A cobrança do novo valor será feita imediatamente. Sua assinatura será estendida dependendo da sua escolha.',
    'subscriptions_account_invoices' => 'Faturas',
    'subscriptions_account_invoices_download' => 'Download',
    'subscriptions_account_invoices_subscription' => 'Assinatura de :startDate a :endDate',
    'subscriptions_account_payment' => 'Qual opção de pagamento melhor lhe agrada?',
    'subscriptions_account_confirm_payment' => 'Seu pagamento está incompleto, por favor <a href=":url">confirme seu pagamento</a>.',
    'subscriptions_downgrade_title' => 'Fazer downgrade da sua conta para o plano gratuito',
    'subscriptions_downgrade_limitations' => 'O plano gratuito tem limitações. Para poder fazer o downgrade, você precisa passar a lista de verificação abaixo:',
    'subscriptions_downgrade_rule_users' => 'Você deve ter apenas 1 usuário na sua conta',
    'subscriptions_downgrade_rule_users_constraint' => 'Você tem atualmente <a href=":url">1 usuário</a> na sua conta. No momento, você tem <a href=":url">:count usuários</a> na sua conta.',
    'subscriptions_downgrade_rule_invitations' => 'Você não deve ter nenhum convite pendente',
    'subscriptions_downgrade_rule_invitations_constraint' => 'Você tem atualmente <a href=":url">1 convite pendente</a>.➲ Você tem <a href=":url">:count convites pendentes</a>.',
    'subscriptions_downgrade_rule_contacts' => 'Você não pode ter mais de :number contatos ativos',
    'subscriptions_downgrade_rule_contacts_constraint' => 'Você tem atualmente <a href=":url">1 contato</a>.├Você tem <a href=":url">:count contatos</a>.',
    'subscriptions_downgrade_rule_contacts_archive' => 'Você também pode <a href=":url">arquivar todos os seus contatos</a> – para poder prosseguir com o processo de downgrade.',
    'subscriptions_downgrade_cta' => 'Fazer downgrade',
    'subscriptions_downgrade_success' => 'Você voltou para o Plano Grátis!',
    'subscriptions_downgrade_thanks' => 'Muito obrigado por experimentar o plano pago. Continuamos adicionando novas funcionalidades à Monica o tempo todo - então você pode querer voltar no futuro para ver se pode estar interessado em fazer uma assinatura novamente.',
    'subscriptions_back' => 'Voltar para as configurações',
    'subscriptions_upgrade_title' => 'Faça um upgrade na sua conta',
    'subscriptions_upgrade_choose' => 'Você escolheu o plano :plan.',
    'subscriptions_upgrade_infos' => 'Não poderíamos estar mais felizes. Insira as suas informações de pagamento abaixo.',
    'subscriptions_upgrade_name' => 'Nome no cartão',
    'subscriptions_upgrade_zip' => 'CEP ou código postal',
    'subscriptions_upgrade_credit' => 'Cartão de crédito ou débito',
    'subscriptions_upgrade_submit' => 'Pagar {amount}',
    'subscriptions_upgrade_charge' => 'Agora, será cobrado o seu cartão :price A próxima cobrança será em :date. Se você mudar de ideia, você pode cancelar a qualquer momento, sem perguntas.',
    'subscriptions_upgrade_charge_handled' => 'O pagamento é processado por <a href=":url">Stripe</a>. Nenhuma informação do cartão fica em nosso servidor.',
    'subscriptions_upgrade_success' => 'Obrigado! Você agora é assinante.',
    'subscriptions_upgrade_thanks' => 'Bem-vindo à comunidade de pessoas que tentam fazer do mundo um lugar melhor.',

    'subscriptions_payment_confirm_title' => 'Confirme o seu pagamento :amount',
    'subscriptions_payment_confirm_information' => 'A confirmação extra é necessária para processar o seu pagamento. Por favor, confirme seu pagamento preenchendo os detalhes de pagamento abaixo.',
    'subscriptions_payment_succeeded_title' => 'Pagamento realizado',
    'subscriptions_payment_succeeded' => 'Este pagamento já foi confirmado com sucesso.',
    'subscriptions_payment_cancelled_title' => 'Pagamento cancelado',
    'subscriptions_payment_cancelled' => 'Este pagamento foi cancelado.',
    'subscriptions_payment_error_name' => 'Por favor, forneça seu nome.',
    'subscriptions_payment_success' => 'O pagamento foi efetuado com sucesso.',

    'subscriptions_pdf_title' => 'Sua assinatura mensal :name',
    'subscriptions_plan_frequency_year' => ':amount / ano',
    'subscriptions_plan_frequency_month' => ':amount / mês',
    'subscriptions_plan_choose' => 'Escolha este plano',
    'subscriptions_plan_year_title' => 'Pagar anualmente',
    'subscriptions_plan_year_bonus' => 'Tranquilidade para um ano inteiro',
    'subscriptions_plan_month_title' => 'Pagar mensalmente',
    'subscriptions_plan_month_bonus' => 'Cancele a qualquer momento',
    'subscriptions_plan_include1' => 'Incluído na sua atualização:',
    'subscriptions_plan_include2' => 'Número ilimitado de contatos • Número ilimitado de usuários • Lembretes por e-mail • Importar com vCard • Personalização da página de contatos',
    'subscriptions_plan_include3' => '100% dos lucros revertem a favor do desenvolvimento deste grande projeto de código aberto.',
    'subscriptions_help_title' => 'Detalhes adicionais sobre os quais você pode estar curioso',
    'subscriptions_help_opensource_title' => 'O que é um projeto de código aberto?',
    'subscriptions_help_opensource_desc' => 'Monica é um projeto open source. Isso significa que é feito por uma comunidade que quer construir uma ferramenta excelente para o bem maior. Ser de código aberto significa que o código está disponível publicamente no GitHub e todos podem inspecioná-lo, modificá-lo ou aprimorá-lo. Todo o dinheiro que angariamos é dedicado à construção de melhores recursos, ao pagamento de servidores mais poderosos e a outros custos. Obrigado pela sua ajuda. Não poderíamos fazer isso sem você.',
    'subscriptions_help_limits_title' => 'Existe algum limite para o número de contatos que podemos ter no plano gratuito?',
    'subscriptions_help_limits_plan' => 'Sim. Planos grátis permitem que você gerencie :number contatos.',
    'subscriptions_help_discounts_title' => 'Vocês oferecem descontos para uso educacional ou uso sem fins lucrativos?',
    'subscriptions_help_discounts_desc' => 'Sim! Monica é gratuita para estudantes e gratuita para instituições sem fins lucrativos e de caridade. Basta contatar <a href=":support">o suporte</a> com um comprovante de seu status e aplicaremos este status especial na sua conta.',
    'subscriptions_help_change_title' => 'E se eu mudar de ideia?',
    'subscriptions_help_change_desc' => 'Você pode cancelar a qualquer momento, sem perguntas e todas feitas por você – sem necessidade de entrar em contato com o suporte. No entanto, não será reembolsado no período em curso.',

    'stripe_error_card' => 'Seu cartão foi recusado. A mensagem recusada é: :message',
    'stripe_error_api_connection' => 'A comunicação de rede com o Stripe falhou. Tente novamente mais tarde.',
    'stripe_error_rate_limit' => 'Muitas solicitações com o Stripe no momento. Tente novamente mais tarde.',
    'stripe_error_invalid_request' => 'Parâmetros inválidos. Tente novamente mais tarde.',
    'stripe_error_authentication' => 'Autenticação errada com Stripe',

    'import_title' => 'Importar contatos da sua conta',
    'import_cta' => 'Carregar contatos',
    'import_stat' => 'Você importou :number arquivos até agora.',
    'import_result_stat' => 'Cartão vCard enviado com 1 contato (:total_imported importado, :total_skipped ignorado)|Uploaded vCard com :total_contacts (:total_imported importado, :total_skipped ignorado)',
    'import_view_report' => 'Ver relatório',
    'import_in_progress' => 'A importação está em andamento. Recarregue a página em um minuto.',
    'import_upload_title' => 'Importe seus contatos de um arquivo vCard',
    'import_upload_rules_desc' => 'Temos, no entanto, algumas regras:',
    'import_upload_rule_format' => 'Oferecemos suporte a arquivos <code>.vcard</code> e <code>.vcf</code>.',
    'import_upload_rule_vcard' => 'Oferecemos suporte ao formato vCard 3.0, que é o formato padrão do macOS Contacts.app e Google Contacts.',
    'import_upload_rule_instructions' => 'Exportar instruções para <a href=":url1" target="_blank" rel="noopener noreferrer">macOS Contacts.app</a> e <a href=":url2" target="_blank" rel="noopener noreferrer">Google contacts</a>.',
    'import_upload_rule_multiple' => 'Se os seus contatos tiverem vários endereços de e-mail ou números de telefone, apenas a primeira entrada será salva.',
    'import_upload_rule_limit' => 'Os arquivos estão limitados a 10 MB.',
    'import_upload_rule_time' => 'Pode demorar até um minuto para carregar os contatos e processá-los. Por favor, seja paciente.',
    'import_upload_rule_cant_revert' => 'Certifique-se de que os dados estão precisos antes de fazer o upload, pois você não pode desfazer o upload.',
    'import_upload_form_file' => 'Seu arquivo <code>.vcf</code> ou <code>.vCard</code>:',
    'import_upload_behaviour' => 'Comportamento da importação:',
    'import_upload_behaviour_add' => 'Adicionar novos contatos e pular os contatos existentes',
    'import_upload_behaviour_replace' => 'Substituir os contatos existentes',
    'import_upload_behaviour_help' => 'Substituir irá substituir todos os dados encontrados no vCard, mas irá manter campos de contato existentes.',
    'import_report_title' => 'Importando relatório',
    'import_report_date' => 'Data da importação',
    'import_report_type' => 'Tipo de importação',
    'import_report_number_contacts' => 'Número de contatos no arquivo',
    'import_report_number_contacts_imported' => 'Número de contatos importados',
    'import_report_number_contacts_skipped' => 'Número de contatos ignorados',
    'import_report_status_imported' => 'Importado',
    'import_report_status_skipped' => 'Ignorado',
    'import_vcard_parse_error' => 'Erro ao analisar a entrada do vCard',
    'import_vcard_contact_exist' => 'O contato já existe',
    'import_vcard_contact_no_firstname' => 'Nenhum nome (obrigatório)',
    'import_vcard_file_not_found' => 'Arquivo não encontrado',
    'import_vcard_unknown_entry' => 'Nome de contato desconhecido',
    'import_vcard_file_no_entries' => 'O arquivo não contém entradas',
    'import_blank_title' => 'Você não importou nenhum contato ainda.',
    'import_blank_question' => 'Você gostaria de importar os contatos agora?',
    'import_blank_description' => 'Podemos importar arquivos vCard que você pode obter a partir dos Contatos do Google ou do seu Gerenciador de Contato.',
    'import_blank_cta' => 'Importar vCard',
    'import_need_subscription' => 'A importação de dados requer uma assinatura.',

    'tags_list_title' => 'Etiquetas',
    'tags_list_description' => 'Você pode organizar seus contatos configurando etiquetas (tags). As tags funcionam como pastas, mas você pode adicionar mais de uma tag a um contato. Para adicionar uma nova tag, adicione-a no próprio contato.',
    'tags_list_contact_number' => '1 contato|:count contatos',
    'tags_list_delete_success' => 'A tag foi excluída com sucesso',
    'tags_list_delete_confirmation' => 'Tem certeza que deseja excluir a etiqueta? Nenhum contato será excluído, apenas a etiqueta.',
    'tags_blank_title' => 'As tags são uma ótima maneira de categorizar seus contatos.',
    'tags_blank_description' => 'As tags funcionam como pastas, mas você pode adicionar mais de uma tag a um contato. Vá para um contato e marque um amigo, logo abaixo do nome. Depois de adicionar uma tag ao contato, volte aqui para gerenciar todas as tags da sua conta.',

    'api_title' => 'Acesso à API',
    'api_description' => 'A API pode ser usada para manipular os dados da Monica a partir de uma aplicação externa, como um aplicativo móvel por exemplo.',
    'api_help' => 'Para usar a API, um token é obrigatório. Você pode criar um token de acesso pessoal (autenticação pelo titular) ou autorizar um cliente OAuth para criá-lo para você. Veja a <a href=":url">documentação da API</a>.',
    'api_endpoint' => 'A API endpoint para esta instância de Monica é:',

    'api_personal_access_tokens' => 'Tokens de acesso pessoal',
    'api_pao_description' => 'Certifique-se de dar esse token para uma fonte em que você confia – pois ele permite que você acesse todos os seus dados.',
    'api_token_title' => 'Tokens de acesso pessoal',
    'api_token_create_new' => 'Criar novo token',
    'api_token_not_created' => 'Você não criou nenhum token de acesso pessoal.',
    'api_token_name' => 'Nome do token',
    'api_token_expire' => 'Expira em {date}',
    'api_token_delete' => 'Excluir',
    'api_token_create' => 'Criar Token',
    'api_token_scopes' => 'Escopos',
    'api_token_help' => 'Aqui está seu novo token de acesso pessoal. Esta é a única vez que ele será mostrado, então, não o perca! Agora você pode usar este token para fazer solicitações de API.',

    'api_oauth_clients' => 'Seus clientes OAuth',
    'api_oauth_clients_desc' => 'Esta seção permite registrar seus próprios clientes OAuth.',
    'api_oauth_clients_desc2' => 'Use este id de cliente para solicitar um novo token e converter códigos de autorização para tokens de acesso. Veja a <a href="{url}">documentação do Passaporte Laravel</a> para mais informações.',
    'api_oauth_title' => 'Clientes OAuth',
    'api_oauth_create_new' => 'Criar Novo Cliente',
    'api_oauth_edit' => 'Editar Cliente',
    'api_oauth_not_created' => 'Você não criou nenhum cliente OAuth.',
    'api_oauth_clientid' => 'ID do Cliente',
    'api_oauth_name' => 'Nome',
    'api_oauth_name_help' => 'Algo que seus usuários reconhecerão e confiarão.',
    'api_oauth_secret' => 'Segredo',
    'api_oauth_create' => 'Criar Cliente',
    'api_oauth_redirecturl' => 'URL de redirecionamento',
    'api_oauth_redirecturl_help' => 'URL de retorno de chamada de autorização do seu aplicativo.',

    'api_authorized_clients' => 'Lista de clientes autorizados',
    'api_authorized_clients_desc' => 'Esta seção lista todos os clientes que você tem autorização para acessar seus dados de aplicativos. Você pode revogar essa autorização a qualquer momento.',
    'api_authorized_clients_title' => 'Aplicativos autorizados',
    'api_authorized_clients_none' => 'Ainda não existem clientes autorizados.',
    'api_authorized_clients_name' => 'Nome',
    'api_authorized_clients_scopes' => 'Escopos',

    'personalization_tab_title' => 'Personalize sua conta',

    'personalization_title' => 'Aqui você encontrará configurações diferentes para configurar sua conta. Esses recursos são destinados a "usuários masters" que querem o controle máximo sobre a Monica.',
    'personalization_contact_field_type_title' => 'Tipos de campos de contato',
    'personalization_contact_field_type_add' => 'Adicionar novo tipo de campo',
    'personalization_contact_field_type_description' => 'Você pode configurar todos os diferentes tipos de campos de contato que você pode associar a todos os seus contatos. Por exemplo, se uma nova rede social surgir no futuro, você poderá adicionar esta nova forma de comunicação com os seus contatos aqui mesmo.',
    'personalization_contact_field_type_table_name' => 'Nome',
    'personalization_contact_field_type_table_protocol' => 'Protocolo',
    'personalization_contact_field_type_table_actions' => 'Ações',
    'personalization_contact_field_type_modal_title' => 'Adicionar um novo tipo de campo de contato',
    'personalization_contact_field_type_modal_edit_title' => 'Editar um tipo de campo de contato existente',
    'personalization_contact_field_type_modal_delete_title' => 'Excluir um tipo de campo de contato existente',
    'personalization_contact_field_type_modal_delete_description' => 'Tem certeza de que deseja excluir este tipo de campo de contato? Excluir este tipo de campo de contato irá excluir TODOS os dados com este tipo para todos os seus contatos.',
    'personalization_contact_field_type_modal_name' => 'Nome',
    'personalization_contact_field_type_modal_protocol' => 'Protocolo (opcional)',
    'personalization_contact_field_type_modal_protocol_help' => 'Cada novo tipo de campo de contato pode ser clicável. Se um protocolo for definido, nós o usaremos para acionar a ação definida.',
    'personalization_contact_field_type_modal_icon' => 'Ícone (opcional)',
    'personalization_contact_field_type_modal_icon_help' => 'Você pode associar um ícone com este tipo de campo de contato. Você precisa adicionar uma referência a um ícone do Font Awesome.',
    'personalization_contact_field_type_delete_success' => 'O tipo de campo de contato foi excluído com sucesso.',
    'personalization_contact_field_type_add_success' => 'O tipo de campo de contato foi adicionado com sucesso.',
    'personalization_contact_field_type_edit_success' => 'O tipo de campo de contato foi atualizado com sucesso.',

    'personalization_genders_title' => 'Tipos de gêneros',
    'personalization_genders_add' => 'Adicionar novo tipo de gênero',
    'personalization_genders_desc' => 'Você pode definir quantos gêneros precisar. Você precisa de pelo menos um tipo de gênero na sua conta.',
    'personalization_genders_modal_add' => 'Adicionar tipo de gênero',
    'personalization_genders_modal_edit' => 'Atualizar tipo de gênero',
    'personalization_genders_modal_name' => 'Nome',
    'personalization_genders_modal_name_help' => 'O nome usado para exibir o gênero em uma página de contato.',
    'personalization_genders_modal_sex' => 'Sexo',
    'personalization_genders_modal_sex_help' => 'Usado para definir as relações, e durante o processo de importação/exportação de cartões VCard.',
    'personalization_genders_modal_default' => 'Selecione o gênero padrão para um novo contato',
    'personalization_genders_modal_delete' => 'Excluir tipo de gênero',
    'personalization_genders_modal_delete_desc' => 'Tem certeza de que deseja excluir o gênero “{name}”?',
    'personalization_genders_modal_delete_question' => 'Atualmente, você tem {count} contato com este gênero. Se você excluir este gênero, qual deve ser o gênero deste contato?|Atualmente você tem {count} contatos com este gênero. Se você excluir este gênero, qual deve ser o gênero destes contatos?',
    'personalization_genders_modal_delete_question_default' => 'Este gênero é o padrão. Se você excluir este gênero, qual será o novo padrão?',
    'personalization_genders_modal_error' => 'Por favor, escolha um gênero da lista.',
    'personalization_genders_list_contact_number' => '{count} contato|{count} contatos',
    'personalization_genders_table_name' => 'Nome',
    'personalization_genders_table_sex' => 'Sexo',
    'personalization_genders_table_default' => 'Padrão',
    'personalization_genders_default' => 'Gênero padrão',
    'personalization_genders_make_default' => 'Alterar gênero padrão',
    'personalization_genders_select_default' => 'Selecionar gênero padrão',
    'personalization_genders_m' => 'Masculino',
    'personalization_genders_f' => 'Feminino',
    'personalization_genders_o' => 'Outros',
    'personalization_genders_u' => 'Desconhecido',
    'personalization_genders_n' => 'Nenhum ou não aplicável',

    'personalization_reminder_rule_save' => 'A alteração foi salva',
    'personalization_reminder_rule_title' => 'Regras do lembrete',
    'personalization_reminder_rule_line' => '{count} dia antes?|{count} dias antes',
    'personalization_reminder_rule_desc' => 'Para cada lembrete que você definiu, Monica pode enviar-lhe um e-mail por alguns dias antes do evento acontecer. Você pode ajustar estas configurações de notificação aqui. Estas notificações se aplicam apenas a lembretes mensais e anuais.',

    'personalization_module_save' => 'A alteração foi salva',
    'personalization_module_title' => 'Funcionalidades',
    'personalization_module_desc' => 'Você pode não precisar de todas as funcionalidades da Monica. Abaixo você pode alternar as funcionalidades específicas que são utilizadas em uma lista de contatos. Esta alteração afetará TODOS os seus contatos. Desativar um recurso não exclui nenhum dado, simplesmente oculta o recurso.',

    'personalisation_paid_upgrade' => 'Este é um recurso premium que requer uma assinatura paga para estar ativo. Atualize a sua conta visitando <a href=":url">Configurações > Assinatura</a>.',
    'personalisation_paid_upgrade_vue' => 'Este é um recurso premium que requer uma assinatura paga para estar ativo. Atualize a sua conta visitando <a href="{url}">Configurações > Assinatura</a>.',

    'reminder_time_to_send' => 'O horário do dia dos lembretes será enviado',
    'reminder_time_to_send_help' => 'Seu próximo lembrete está agendado para ser enviado no <span title="{dateTimeUtc}" class="reminder-info">{dateTime}</span>.',

    'personalization_activity_type_category_title' => 'Categorias do tipo atividade',
    'personalization_activity_type_category_add' => 'Adicionar uma nova categoria de tipo de atividade',
    'personalization_activity_type_category_table_name' => 'Nome',
    'personalization_activity_type_category_description' => 'Uma atividade com um dos seus contatos pode ter um tipo e uma categoria. Sua conta vem com um conjunto de tipos de categoria predefinidos por padrão, mas você pode personalizá-los aqui.',
    'personalization_activity_type_category_table_actions' => 'Ações',
    'personalization_activity_type_category_modal_add' => 'Adicionar uma nova categoria de tipo de atividade',
    'personalization_activity_type_category_modal_edit' => 'Editar uma categoria de tipo de atividade',
    'personalization_activity_type_category_modal_question' => 'Como devemos nomear esta nova categoria?',
    'personalization_activity_type_add_button' => 'Adicionar um novo tipo de atividade',
    'personalization_activity_type_modal_add' => 'Adicionar um novo tipo de atividade',
    'personalization_activity_type_modal_question' => 'Como devemos chamar este novo tipo de atividade?',
    'personalization_activity_type_modal_edit' => 'Editar um tipo de atividade',
    'personalization_activity_type_category_modal_delete' => 'Apagar uma categoria de tipo de atividade',
    'personalization_activity_type_category_modal_delete_desc' => 'Tem certeza que deseja excluir esta categoria? Excluirá todos os tipos de atividades associadas. As atividades que pertencem a esta categoria não serão afetadas por esta exclusão.',
    'personalization_activity_type_modal_delete' => 'Apagar um tipo de atividade',
    'personalization_activity_type_modal_delete_desc' => 'Tem certeza que deseja excluir este tipo de atividade? Atividades que pertencem a esta categoria não serão afetadas por esta exclusão.',
    'personalization_activity_type_modal_delete_error' => 'Não encontramos este tipo de atividade.',
    'personalization_activity_type_category_modal_delete_error' => 'Não conseguimos encontrar esta categoria de tipo de atividade.',

    'personalization_life_event_category_title' => 'Categorias de eventos pessoais',
    'personalization_live_event_category_table_name' => 'Nome',
    'personalization_life_event_category_description' => 'Um evento de vida pode ter um tipo e uma categoria. Sua conta vem com um conjunto de categorias e tipos predefinidos por padrão, mas você pode personalizar os tipos de eventos de vida aqui.',
    'personalization_live_event_category_table_actions' => 'Ações',
    'personalization_life_event_type_add_button' => 'Adicionar um novo tipo de evento de vida',
    'personalization_life_event_type_modal_add' => 'Adicionar um novo tipo de evento de vida',
    'personalization_life_event_type_modal_question' => 'Como devemos chamar este novo tipo de evento de vida?',
    'personalization_life_event_type_modal_edit' => 'Editar um tipo de evento de vida',
    'personalization_life_event_type_modal_delete' => 'Excluir um tipo de evento de vida',
    'personalization_life_event_type_modal_delete_desc' => 'Tem certeza que deseja excluir este tipo de evento de vida? Eventos de vida que pertencem a este tipo serão excluídos ao realizar esta ação.',
    'personalization_life_event_type_modal_delete_error' => 'Não foi possível encontrar este tipo de evento de vida.',

    'personalization_life_event_category_work_education' => 'Trabalho e educação',
    'personalization_life_event_category_family_relationships' => 'Família e relacionamentos',
    'personalization_life_event_category_home_living' => 'Casa e vida',
    'personalization_life_event_category_travel_experiences' => 'Viagem e experiências',
    'personalization_life_event_category_health_wellness' => 'Saúde e bem-estar',

    'personalization_life_event_type_new_job' => 'Novo trabalho',
    'personalization_life_event_type_retirement' => 'Aposentado',
    'personalization_life_event_type_new_school' => 'Nova escola',
    'personalization_life_event_type_study_abroad' => 'Estudos no exterior',
    'personalization_life_event_type_volunteer_work' => 'Trabalho voluntário',
    'personalization_life_event_type_published_book_or_paper' => 'Publicou um livro ou artigo',
    'personalization_life_event_type_military_service' => 'Serviço militar',
    'personalization_life_event_type_first_met' => 'Primeira reunião',
    'personalization_life_event_type_new_relationship' => 'Novo relacionamento',
    'personalization_life_event_type_engagement' => 'Envolvimento',
    'personalization_life_event_type_marriage' => 'Casamento',
    'personalization_life_event_type_anniversary' => 'Aniversário',
    'personalization_life_event_type_expecting_a_baby' => 'Esperando um bebê',
    'personalization_life_event_type_new_child' => 'Novo filho',
    'personalization_life_event_type_new_family_member' => 'Novo membro da família',
    'personalization_life_event_type_new_pet' => 'Novo pet',
    'personalization_life_event_type_end_of_relationship' => 'Fim do relacionamento',
    'personalization_life_event_type_loss_of_a_loved_one' => 'Perda de um ente querido',
    'personalization_life_event_type_moved' => 'Mudou-se',
    'personalization_life_event_type_bought_a_home' => 'Comprou uma casa',
    'personalization_life_event_type_home_improvement' => 'Melhoria na casa',
    'personalization_life_event_type_holidays' => 'Feriados',
    'personalization_life_event_type_new_vehicle' => 'Novo veículo',
    'personalization_life_event_type_new_roommate' => 'Novo colega de quarto',
    'personalization_life_event_type_overcame_an_illness' => 'Superou uma doença',
    'personalization_life_event_type_quit_a_habit' => 'Abandonou um hábito',
    'personalization_life_event_type_new_eating_habits' => 'Novos hábitos de alimentação',
    'personalization_life_event_type_weight_loss' => 'Perda de peso',
    'personalization_life_event_type_wear_glass_or_contact' => 'Começou a usar óculos ou lentes de contato',
    'personalization_life_event_type_broken_bone' => 'Quebrou um osso',
    'personalization_life_event_type_removed_braces' => 'Retirou o aparelho ortodôntico',
    'personalization_life_event_type_surgery' => 'Fez uma cirurgia',
    'personalization_life_event_type_dentist' => 'Fez um tratamento dental',
    'personalization_life_event_type_new_sport' => 'Começou a praticar um novo esporte',
    'personalization_life_event_type_new_hobby' => 'Começou um novo passatempo',
    'personalization_life_event_type_new_instrument' => 'Começou a aprender um novo instrumento',
    'personalization_life_event_type_new_language' => 'Começou a aprender um novo idioma',
    'personalization_life_event_type_tattoo_or_piercing' => 'Tatuagem ou piercing',
    'personalization_life_event_type_new_license' => 'Nova CNH',
    'personalization_life_event_type_travel' => 'Viagem',
    'personalization_life_event_type_achievement_or_award' => 'Conquista ou prêmio',
    'personalization_life_event_type_changed_beliefs' => 'Crenças alteradas',
    'personalization_life_event_type_first_word' => 'Primeira palavra',
    'personalization_life_event_type_first_kiss' => 'Primeiro beijo',

    'storage_title' => 'Armazenamento',
    'storage_account_info' => 'O limite de sua conta é :accountLimit MB. Seu uso atual é :currentAccountSize MB (cerca de :percentUsage%).',
    'storage_upgrade_notice' => 'Faça um upgrade de sua conta para poder enviar documentos e fotos.',
    'storage_description' => 'Aqui você pode ver todos os documentos e fotos enviados sobre seus contatos.',

    'dav_title' => 'WebDAV',
    'dav_description' => 'Aqui você pode encontrar todas as configurações para usar os recursos WebDAV para exportações CardDAV e CalDAV.',
    'dav_copy_help' => 'Copiar para a área de transferência',
    'dav_clipboard_copied' => 'Valor copiado para a área de transferência',
    'dav_url_base' => 'Url base para todos os recursos de CardDAV e CalDAV:',
    'dav_connect_help' => 'Você pode conectar seus contatos e/ou agendas com esta url base no seu telefone ou computador.',
    'dav_connect_help2' => 'Use seu login (e-mail) e crie um token API como a senha para autenticar.',
    'dav_url_carddav' => 'URL CardDAV para recurso de Contatos:',
    'dav_url_caldav_birthdays' => 'URL CalDAV para recursos de aniversário:',
    'dav_url_caldav_tasks' => 'URL CalDAV para recursos de Tarefas:',
    'dav_title_carddav' => 'CardDAV',
    'dav_title_caldav' => 'CalDAV',
    'dav_carddav_export' => 'Exportar contatos em um único arquivo',
    'dav_caldav_birthdays_export' => 'Exportar todos os aniversários em um só arquivo',
    'dav_caldav_tasks_export' => 'Exportar todas as tarefas em um único arquivo',

    'archive_title' => 'Arquivar todos os contatos da sua conta',
    'archive_desc' => 'Isto irá arquivar todos os contatos da sua conta.',
    'archive_cta' => 'Arquivar todos os seus contatos',

    'logs_title' => 'Tudo o que aconteceu com esta conta',
    'logs_actor' => 'Ator',
    'logs_timestamp' => 'Timestamp',
    'logs_description' => 'Descrição',
    'logs_subject' => 'Assunto',
    'logs_size' => 'Tamanho (Kb)',
    'logs_object' => 'Objeto',
];
