/*
 * Decompiled with CFR 0.152.
 */
package org.apache.axis.tools.ant.foreach;

import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;
import org.apache.axis.tools.ant.foreach.ParamSet;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.Task;
import org.apache.tools.ant.taskdefs.Ant;
import org.apache.tools.ant.taskdefs.Java;
import org.apache.tools.ant.taskdefs.Property;
import org.apache.tools.ant.types.Commandline;
import org.apache.tools.ant.types.Path;

public class ForeachTask
extends Task {
    private Ant callee;
    private Java callee2;
    private String subTarget;
    private Vector params = new Vector();
    private Hashtable properties = new Hashtable();
    private boolean inheritAll = true;
    private boolean inheritRefs = false;
    private boolean fork = false;
    private boolean verbose = false;

    public void init() {
    }

    public void setInheritAll(boolean inherit) {
        this.inheritAll = inherit;
    }

    public void setInheritRefs(boolean inheritRefs) {
        this.inheritRefs = inheritRefs;
    }

    public void setTarget(String target) {
        this.subTarget = target;
    }

    public void setFork(boolean f) {
        this.fork = f;
    }

    public void setVerbose(boolean verbose) {
        this.verbose = verbose;
    }

    public ParamSet createParam() {
        ParamSet param = new ParamSet();
        this.params.addElement(param);
        return param;
    }

    private void buildProperty(String propName, String propValue) {
        this.properties.put(propName, propValue);
    }

    private void executeTarget() {
        if (this.subTarget == null) {
            throw new BuildException("Attribute target is required.", this.getLocation());
        }
        if (this.fork) {
            this.executeForkedAntTask();
        } else {
            this.executeAntTask();
        }
    }

    private void executeForkedAntTask() {
        this.callee2 = (Java)this.getProject().createTask("java");
        this.callee2.setOwningTarget(this.getOwningTarget());
        this.callee2.setTaskName(this.getTaskName());
        this.callee2.setLocation(this.getLocation());
        this.callee2.setClassname("org.apache.tools.ant.Main");
        this.callee2.setAppend(true);
        this.callee2.setFork(true);
        this.callee2.createJvmarg().setValue("-Xbootclasspath/p:" + System.getProperty("sun.boot.class.path"));
        String systemClassPath = System.getProperty("java.class.path");
        this.callee2.setClasspath(new Path(this.getProject(), systemClassPath));
        String args = "-buildfile " + this.properties.get("file");
        Commandline.Argument arguments = this.callee2.createArg();
        arguments.setLine(args);
        if (this.verbose) {
            this.callee2.createArg().setValue("-verbose");
        }
        if (this.callee2.executeJava() != 0) {
            throw new BuildException("Execution of ANT Task failed");
        }
    }

    private void executeAntTask() {
        this.callee = (Ant)this.getProject().createTask("ant");
        this.callee.setOwningTarget(this.getOwningTarget());
        this.callee.setTaskName(this.getTaskName());
        this.callee.init();
        this.callee.setAntfile(this.getProject().getProperty("ant.file"));
        this.callee.setTarget(this.subTarget);
        this.callee.setInheritAll(this.inheritAll);
        this.callee.setInheritRefs(this.inheritRefs);
        Enumeration keys = this.properties.keys();
        while (keys.hasMoreElements()) {
            String key = (String)keys.nextElement();
            String val = (String)this.properties.get(key);
            Property prop = this.callee.createProperty();
            prop.setName(key);
            prop.setValue(val);
        }
        this.callee.execute();
        System.gc();
        System.gc();
        System.gc();
    }

    private void executeParameters(int paramNumber) {
        if (paramNumber == this.params.size()) {
            this.executeTarget();
        } else {
            ParamSet paramSet = (ParamSet)this.params.elementAt(paramNumber);
            Enumeration values = paramSet.getValues(this.getProject());
            while (values.hasMoreElements()) {
                String val = (String)values.nextElement();
                this.buildProperty(paramSet.getName(), val);
                this.executeParameters(paramNumber + 1);
            }
        }
    }

    public void execute() {
        if (this.subTarget == null) {
            throw new BuildException("Attribute target is required.", this.getLocation());
        }
        this.executeParameters(0);
    }
}

