/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.common.message;

import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.apache.kafka.common.errors.UnsupportedVersionException;
import org.apache.kafka.common.protocol.ApiMessage;
import org.apache.kafka.common.protocol.Message;
import org.apache.kafka.common.protocol.MessageUtil;
import org.apache.kafka.common.protocol.ObjectSerializationCache;
import org.apache.kafka.common.protocol.Readable;
import org.apache.kafka.common.protocol.Writable;
import org.apache.kafka.common.protocol.types.ArrayOf;
import org.apache.kafka.common.protocol.types.Field;
import org.apache.kafka.common.protocol.types.RawTaggedField;
import org.apache.kafka.common.protocol.types.RawTaggedFieldWriter;
import org.apache.kafka.common.protocol.types.Schema;
import org.apache.kafka.common.protocol.types.Struct;
import org.apache.kafka.common.protocol.types.Type;
import org.apache.kafka.common.utils.ByteUtils;
import org.apache.kafka.common.utils.Bytes;

public class ProduceRequestData
implements ApiMessage {
    private String transactionalId;
    private short acks;
    private int timeoutMs;
    private List<TopicProduceData> topics;
    private List<RawTaggedField> _unknownTaggedFields;
    public static final Schema SCHEMA_0;
    public static final Schema SCHEMA_1;
    public static final Schema SCHEMA_2;
    public static final Schema SCHEMA_3;
    public static final Schema SCHEMA_4;
    public static final Schema SCHEMA_5;
    public static final Schema SCHEMA_6;
    public static final Schema SCHEMA_7;
    public static final Schema SCHEMA_8;
    public static final Schema[] SCHEMAS;

    public ProduceRequestData(Readable _readable, short _version) {
        this.read(_readable, _version);
    }

    public ProduceRequestData(Struct struct, short _version) {
        this.fromStruct(struct, _version);
    }

    public ProduceRequestData() {
        this.transactionalId = "";
        this.acks = 0;
        this.timeoutMs = 0;
        this.topics = new ArrayList<TopicProduceData>();
    }

    @Override
    public short apiKey() {
        return 0;
    }

    @Override
    public short lowestSupportedVersion() {
        return 0;
    }

    @Override
    public short highestSupportedVersion() {
        return 8;
    }

    @Override
    public void read(Readable _readable, short _version) {
        if (_version >= 3) {
            short length = _readable.readShort();
            if (length < 0) {
                this.transactionalId = null;
            } else {
                if (length > Short.MAX_VALUE) {
                    throw new RuntimeException("string field transactionalId had invalid length " + length);
                }
                this.transactionalId = _readable.readString(length);
            }
        } else {
            this.transactionalId = "";
        }
        this.acks = _readable.readShort();
        this.timeoutMs = _readable.readInt();
        int arrayLength = _readable.readInt();
        if (arrayLength < 0) {
            throw new RuntimeException("non-nullable field topics was serialized as null");
        }
        ArrayList<TopicProduceData> newCollection = new ArrayList<TopicProduceData>(arrayLength);
        for (int i = 0; i < arrayLength; ++i) {
            newCollection.add(new TopicProduceData(_readable, _version));
        }
        this.topics = newCollection;
        this._unknownTaggedFields = null;
    }

    @Override
    public void write(Writable _writable, ObjectSerializationCache _cache, short _version) {
        Object _stringBytes;
        int _numTaggedFields = 0;
        if (_version >= 3) {
            if (this.transactionalId == null) {
                _writable.writeShort((short)-1);
            } else {
                _stringBytes = _cache.getSerializedValue(this.transactionalId);
                _writable.writeShort((short)((byte[])_stringBytes).length);
                _writable.writeByteArray((byte[])_stringBytes);
            }
        } else if (!this.transactionalId.equals("")) {
            throw new UnsupportedVersionException("Attempted to write a non-default transactionalId at version " + _version);
        }
        _writable.writeShort(this.acks);
        _writable.writeInt(this.timeoutMs);
        _writable.writeInt(this.topics.size());
        _stringBytes = this.topics.iterator();
        while (_stringBytes.hasNext()) {
            TopicProduceData topicsElement = (TopicProduceData)_stringBytes.next();
            topicsElement.write(_writable, _cache, _version);
        }
        RawTaggedFieldWriter _rawWriter = RawTaggedFieldWriter.forFields(this._unknownTaggedFields);
        if ((_numTaggedFields += _rawWriter.numFields()) > 0) {
            throw new UnsupportedVersionException("Tagged fields were set, but version " + _version + " of this message does not support them.");
        }
    }

    @Override
    public void fromStruct(Struct struct, short _version) {
        this._unknownTaggedFields = null;
        this.transactionalId = _version >= 3 ? struct.getString("transactional_id") : "";
        this.acks = struct.getShort("acks");
        this.timeoutMs = struct.getInt("timeout_ms");
        Object[] _nestedObjects = struct.getArray("topics");
        this.topics = new ArrayList<TopicProduceData>(_nestedObjects.length);
        for (Object nestedObject : _nestedObjects) {
            this.topics.add(new TopicProduceData((Struct)nestedObject, _version));
        }
    }

    @Override
    public Struct toStruct(short _version) {
        Object _taggedFields = null;
        Struct struct = new Struct(SCHEMAS[_version]);
        if (_version >= 3) {
            struct.set("transactional_id", (Object)this.transactionalId);
        }
        struct.set("acks", (Object)this.acks);
        struct.set("timeout_ms", (Object)this.timeoutMs);
        Struct[] _nestedObjects = new Struct[this.topics.size()];
        int i = 0;
        for (TopicProduceData element : this.topics) {
            _nestedObjects[i++] = element.toStruct(_version);
        }
        struct.set("topics", (Object)_nestedObjects);
        return struct;
    }

    @Override
    public int size(ObjectSerializationCache _cache, short _version) {
        int _size = 0;
        int _numTaggedFields = 0;
        if (_version >= 3) {
            if (this.transactionalId == null) {
                _size += 2;
            } else {
                byte[] _stringBytes = this.transactionalId.getBytes(StandardCharsets.UTF_8);
                if (_stringBytes.length > Short.MAX_VALUE) {
                    throw new RuntimeException("'transactionalId' field is too long to be serialized");
                }
                _cache.cacheSerializedValue(this.transactionalId, _stringBytes);
                _size += _stringBytes.length + 2;
            }
        }
        _size += 2;
        _size += 4;
        int _arraySize = 0;
        _arraySize += 4;
        for (TopicProduceData topicsElement : this.topics) {
            _arraySize += topicsElement.size(_cache, _version);
        }
        _size += _arraySize;
        if (this._unknownTaggedFields != null) {
            _numTaggedFields += this._unknownTaggedFields.size();
            for (RawTaggedField _field : this._unknownTaggedFields) {
                _size += ByteUtils.sizeOfUnsignedVarint(_field.tag());
                _size += ByteUtils.sizeOfUnsignedVarint(_field.size());
                _size += _field.size();
            }
        }
        if (_numTaggedFields > 0) {
            throw new UnsupportedVersionException("Tagged fields were set, but version " + _version + " of this message does not support them.");
        }
        return _size;
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof ProduceRequestData)) {
            return false;
        }
        ProduceRequestData other = (ProduceRequestData)obj;
        if (this.transactionalId == null ? other.transactionalId != null : !this.transactionalId.equals(other.transactionalId)) {
            return false;
        }
        if (this.acks != other.acks) {
            return false;
        }
        if (this.timeoutMs != other.timeoutMs) {
            return false;
        }
        return !(this.topics == null ? other.topics != null : !this.topics.equals(other.topics));
    }

    public int hashCode() {
        int hashCode = 0;
        hashCode = 31 * hashCode + (this.transactionalId == null ? 0 : this.transactionalId.hashCode());
        hashCode = 31 * hashCode + this.acks;
        hashCode = 31 * hashCode + this.timeoutMs;
        hashCode = 31 * hashCode + (this.topics == null ? 0 : this.topics.hashCode());
        return hashCode;
    }

    public String toString() {
        return "ProduceRequestData(transactionalId=" + (this.transactionalId == null ? "null" : "'" + this.transactionalId.toString() + "'") + ", acks=" + this.acks + ", timeoutMs=" + this.timeoutMs + ", topics=" + MessageUtil.deepToString(this.topics.iterator()) + ")";
    }

    public String transactionalId() {
        return this.transactionalId;
    }

    public short acks() {
        return this.acks;
    }

    public int timeoutMs() {
        return this.timeoutMs;
    }

    public List<TopicProduceData> topics() {
        return this.topics;
    }

    @Override
    public List<RawTaggedField> unknownTaggedFields() {
        if (this._unknownTaggedFields == null) {
            this._unknownTaggedFields = new ArrayList<RawTaggedField>(0);
        }
        return this._unknownTaggedFields;
    }

    public ProduceRequestData setTransactionalId(String v) {
        this.transactionalId = v;
        return this;
    }

    public ProduceRequestData setAcks(short v) {
        this.acks = v;
        return this;
    }

    public ProduceRequestData setTimeoutMs(int v) {
        this.timeoutMs = v;
        return this;
    }

    public ProduceRequestData setTopics(List<TopicProduceData> v) {
        this.topics = v;
        return this;
    }

    static {
        SCHEMA_2 = SCHEMA_1 = (SCHEMA_0 = new Schema(new Field("acks", Type.INT16, "The number of acknowledgments the producer requires the leader to have received before considering a request complete. Allowed values: 0 for no acknowledgments, 1 for only the leader and -1 for the full ISR."), new Field("timeout_ms", Type.INT32, "The timeout to await a response in miliseconds."), new Field("topics", new ArrayOf(TopicProduceData.SCHEMA_0), "Each topic to produce to.")));
        SCHEMA_8 = SCHEMA_7 = (SCHEMA_6 = (SCHEMA_5 = (SCHEMA_4 = (SCHEMA_3 = new Schema(new Field("transactional_id", Type.NULLABLE_STRING, "The transactional ID, or null if the producer is not transactional."), new Field("acks", Type.INT16, "The number of acknowledgments the producer requires the leader to have received before considering a request complete. Allowed values: 0 for no acknowledgments, 1 for only the leader and -1 for the full ISR."), new Field("timeout_ms", Type.INT32, "The timeout to await a response in miliseconds."), new Field("topics", new ArrayOf(TopicProduceData.SCHEMA_0), "Each topic to produce to."))))));
        SCHEMAS = new Schema[]{SCHEMA_0, SCHEMA_1, SCHEMA_2, SCHEMA_3, SCHEMA_4, SCHEMA_5, SCHEMA_6, SCHEMA_7, SCHEMA_8};
    }

    public static class PartitionProduceData
    implements Message {
        private int partitionIndex;
        private byte[] records;
        private List<RawTaggedField> _unknownTaggedFields;
        public static final Schema SCHEMA_0;
        public static final Schema SCHEMA_1;
        public static final Schema SCHEMA_2;
        public static final Schema SCHEMA_3;
        public static final Schema SCHEMA_4;
        public static final Schema SCHEMA_5;
        public static final Schema SCHEMA_6;
        public static final Schema SCHEMA_7;
        public static final Schema SCHEMA_8;
        public static final Schema[] SCHEMAS;

        public PartitionProduceData(Readable _readable, short _version) {
            this.read(_readable, _version);
        }

        public PartitionProduceData(Struct struct, short _version) {
            this.fromStruct(struct, _version);
        }

        public PartitionProduceData() {
            this.partitionIndex = 0;
            this.records = Bytes.EMPTY;
        }

        @Override
        public short lowestSupportedVersion() {
            return 0;
        }

        @Override
        public short highestSupportedVersion() {
            return 8;
        }

        @Override
        public void read(Readable _readable, short _version) {
            if (_version > 8) {
                throw new UnsupportedVersionException("Can't read version " + _version + " of PartitionProduceData");
            }
            this.partitionIndex = _readable.readInt();
            int length = _readable.readInt();
            if (length < 0) {
                this.records = null;
            } else {
                byte[] newBytes = new byte[length];
                _readable.readArray(newBytes);
                this.records = newBytes;
            }
            this._unknownTaggedFields = null;
        }

        @Override
        public void write(Writable _writable, ObjectSerializationCache _cache, short _version) {
            if (_version > 8) {
                throw new UnsupportedVersionException("Can't write version " + _version + " of PartitionProduceData");
            }
            int _numTaggedFields = 0;
            _writable.writeInt(this.partitionIndex);
            if (this.records == null) {
                _writable.writeInt(-1);
            } else {
                _writable.writeInt(this.records.length);
                _writable.writeByteArray(this.records);
            }
            RawTaggedFieldWriter _rawWriter = RawTaggedFieldWriter.forFields(this._unknownTaggedFields);
            if ((_numTaggedFields += _rawWriter.numFields()) > 0) {
                throw new UnsupportedVersionException("Tagged fields were set, but version " + _version + " of this message does not support them.");
            }
        }

        @Override
        public void fromStruct(Struct struct, short _version) {
            if (_version > 8) {
                throw new UnsupportedVersionException("Can't read version " + _version + " of PartitionProduceData");
            }
            this._unknownTaggedFields = null;
            this.partitionIndex = struct.getInt("partition_index");
            this.records = struct.getByteArray("records");
        }

        @Override
        public Struct toStruct(short _version) {
            if (_version > 8) {
                throw new UnsupportedVersionException("Can't write version " + _version + " of PartitionProduceData");
            }
            Object _taggedFields = null;
            Struct struct = new Struct(SCHEMAS[_version]);
            struct.set("partition_index", (Object)this.partitionIndex);
            struct.setByteArray("records", this.records);
            return struct;
        }

        @Override
        public int size(ObjectSerializationCache _cache, short _version) {
            int _size = 0;
            int _numTaggedFields = 0;
            if (_version > 8) {
                throw new UnsupportedVersionException("Can't size version " + _version + " of PartitionProduceData");
            }
            _size += 4;
            if (this.records == null) {
                _size += 4;
            } else {
                int _bytesSize = this.records.length;
                _size += (_bytesSize += 4);
            }
            if (this._unknownTaggedFields != null) {
                _numTaggedFields += this._unknownTaggedFields.size();
                for (RawTaggedField _field : this._unknownTaggedFields) {
                    _size += ByteUtils.sizeOfUnsignedVarint(_field.tag());
                    _size += ByteUtils.sizeOfUnsignedVarint(_field.size());
                    _size += _field.size();
                }
            }
            if (_numTaggedFields > 0) {
                throw new UnsupportedVersionException("Tagged fields were set, but version " + _version + " of this message does not support them.");
            }
            return _size;
        }

        public boolean equals(Object obj) {
            if (!(obj instanceof PartitionProduceData)) {
                return false;
            }
            PartitionProduceData other = (PartitionProduceData)obj;
            if (this.partitionIndex != other.partitionIndex) {
                return false;
            }
            return Arrays.equals(this.records, other.records);
        }

        public int hashCode() {
            int hashCode = 0;
            hashCode = 31 * hashCode + this.partitionIndex;
            hashCode = 31 * hashCode + Arrays.hashCode(this.records);
            return hashCode;
        }

        public String toString() {
            return "PartitionProduceData(partitionIndex=" + this.partitionIndex + ", records=" + Arrays.toString(this.records) + ")";
        }

        public int partitionIndex() {
            return this.partitionIndex;
        }

        public byte[] records() {
            return this.records;
        }

        @Override
        public List<RawTaggedField> unknownTaggedFields() {
            if (this._unknownTaggedFields == null) {
                this._unknownTaggedFields = new ArrayList<RawTaggedField>(0);
            }
            return this._unknownTaggedFields;
        }

        public PartitionProduceData setPartitionIndex(int v) {
            this.partitionIndex = v;
            return this;
        }

        public PartitionProduceData setRecords(byte[] v) {
            this.records = v;
            return this;
        }

        static {
            SCHEMA_8 = SCHEMA_7 = (SCHEMA_6 = (SCHEMA_5 = (SCHEMA_4 = (SCHEMA_3 = (SCHEMA_2 = (SCHEMA_1 = (SCHEMA_0 = new Schema(new Field("partition_index", Type.INT32, "The partition index."), new Field("records", Type.NULLABLE_BYTES, "The record data to be produced.")))))))));
            SCHEMAS = new Schema[]{SCHEMA_0, SCHEMA_1, SCHEMA_2, SCHEMA_3, SCHEMA_4, SCHEMA_5, SCHEMA_6, SCHEMA_7, SCHEMA_8};
        }
    }

    public static class TopicProduceData
    implements Message {
        private String name;
        private List<PartitionProduceData> partitions;
        private List<RawTaggedField> _unknownTaggedFields;
        public static final Schema SCHEMA_0;
        public static final Schema SCHEMA_1;
        public static final Schema SCHEMA_2;
        public static final Schema SCHEMA_3;
        public static final Schema SCHEMA_4;
        public static final Schema SCHEMA_5;
        public static final Schema SCHEMA_6;
        public static final Schema SCHEMA_7;
        public static final Schema SCHEMA_8;
        public static final Schema[] SCHEMAS;

        public TopicProduceData(Readable _readable, short _version) {
            this.read(_readable, _version);
        }

        public TopicProduceData(Struct struct, short _version) {
            this.fromStruct(struct, _version);
        }

        public TopicProduceData() {
            this.name = "";
            this.partitions = new ArrayList<PartitionProduceData>();
        }

        @Override
        public short lowestSupportedVersion() {
            return 0;
        }

        @Override
        public short highestSupportedVersion() {
            return 8;
        }

        @Override
        public void read(Readable _readable, short _version) {
            if (_version > 8) {
                throw new UnsupportedVersionException("Can't read version " + _version + " of TopicProduceData");
            }
            short length = _readable.readShort();
            if (length < 0) {
                throw new RuntimeException("non-nullable field name was serialized as null");
            }
            if (length > Short.MAX_VALUE) {
                throw new RuntimeException("string field name had invalid length " + length);
            }
            this.name = _readable.readString(length);
            int arrayLength = _readable.readInt();
            if (arrayLength < 0) {
                throw new RuntimeException("non-nullable field partitions was serialized as null");
            }
            ArrayList<PartitionProduceData> newCollection = new ArrayList<PartitionProduceData>(arrayLength);
            for (int i = 0; i < arrayLength; ++i) {
                newCollection.add(new PartitionProduceData(_readable, _version));
            }
            this.partitions = newCollection;
            this._unknownTaggedFields = null;
        }

        @Override
        public void write(Writable _writable, ObjectSerializationCache _cache, short _version) {
            if (_version > 8) {
                throw new UnsupportedVersionException("Can't write version " + _version + " of TopicProduceData");
            }
            int _numTaggedFields = 0;
            Object _stringBytes = _cache.getSerializedValue(this.name);
            _writable.writeShort((short)((byte[])_stringBytes).length);
            _writable.writeByteArray((byte[])_stringBytes);
            _writable.writeInt(this.partitions.size());
            _stringBytes = this.partitions.iterator();
            while (_stringBytes.hasNext()) {
                PartitionProduceData partitionsElement = (PartitionProduceData)_stringBytes.next();
                partitionsElement.write(_writable, _cache, _version);
            }
            RawTaggedFieldWriter _rawWriter = RawTaggedFieldWriter.forFields(this._unknownTaggedFields);
            if ((_numTaggedFields += _rawWriter.numFields()) > 0) {
                throw new UnsupportedVersionException("Tagged fields were set, but version " + _version + " of this message does not support them.");
            }
        }

        @Override
        public void fromStruct(Struct struct, short _version) {
            if (_version > 8) {
                throw new UnsupportedVersionException("Can't read version " + _version + " of TopicProduceData");
            }
            this._unknownTaggedFields = null;
            this.name = struct.getString("name");
            Object[] _nestedObjects = struct.getArray("partitions");
            this.partitions = new ArrayList<PartitionProduceData>(_nestedObjects.length);
            for (Object nestedObject : _nestedObjects) {
                this.partitions.add(new PartitionProduceData((Struct)nestedObject, _version));
            }
        }

        @Override
        public Struct toStruct(short _version) {
            if (_version > 8) {
                throw new UnsupportedVersionException("Can't write version " + _version + " of TopicProduceData");
            }
            Object _taggedFields = null;
            Struct struct = new Struct(SCHEMAS[_version]);
            struct.set("name", (Object)this.name);
            Struct[] _nestedObjects = new Struct[this.partitions.size()];
            int i = 0;
            for (PartitionProduceData element : this.partitions) {
                _nestedObjects[i++] = element.toStruct(_version);
            }
            struct.set("partitions", (Object)_nestedObjects);
            return struct;
        }

        @Override
        public int size(ObjectSerializationCache _cache, short _version) {
            int _size = 0;
            int _numTaggedFields = 0;
            if (_version > 8) {
                throw new UnsupportedVersionException("Can't size version " + _version + " of TopicProduceData");
            }
            byte[] _stringBytes = this.name.getBytes(StandardCharsets.UTF_8);
            if (_stringBytes.length > Short.MAX_VALUE) {
                throw new RuntimeException("'name' field is too long to be serialized");
            }
            _cache.cacheSerializedValue(this.name, _stringBytes);
            _size += _stringBytes.length + 2;
            int _arraySize = 0;
            _arraySize += 4;
            for (PartitionProduceData partitionsElement : this.partitions) {
                _arraySize += partitionsElement.size(_cache, _version);
            }
            _size += _arraySize;
            if (this._unknownTaggedFields != null) {
                _numTaggedFields += this._unknownTaggedFields.size();
                for (RawTaggedField _field : this._unknownTaggedFields) {
                    _size += ByteUtils.sizeOfUnsignedVarint(_field.tag());
                    _size += ByteUtils.sizeOfUnsignedVarint(_field.size());
                    _size += _field.size();
                }
            }
            if (_numTaggedFields > 0) {
                throw new UnsupportedVersionException("Tagged fields were set, but version " + _version + " of this message does not support them.");
            }
            return _size;
        }

        public boolean equals(Object obj) {
            if (!(obj instanceof TopicProduceData)) {
                return false;
            }
            TopicProduceData other = (TopicProduceData)obj;
            if (this.name == null ? other.name != null : !this.name.equals(other.name)) {
                return false;
            }
            return !(this.partitions == null ? other.partitions != null : !this.partitions.equals(other.partitions));
        }

        public int hashCode() {
            int hashCode = 0;
            hashCode = 31 * hashCode + (this.name == null ? 0 : this.name.hashCode());
            hashCode = 31 * hashCode + (this.partitions == null ? 0 : this.partitions.hashCode());
            return hashCode;
        }

        public String toString() {
            return "TopicProduceData(name=" + (this.name == null ? "null" : "'" + this.name.toString() + "'") + ", partitions=" + MessageUtil.deepToString(this.partitions.iterator()) + ")";
        }

        public String name() {
            return this.name;
        }

        public List<PartitionProduceData> partitions() {
            return this.partitions;
        }

        @Override
        public List<RawTaggedField> unknownTaggedFields() {
            if (this._unknownTaggedFields == null) {
                this._unknownTaggedFields = new ArrayList<RawTaggedField>(0);
            }
            return this._unknownTaggedFields;
        }

        public TopicProduceData setName(String v) {
            this.name = v;
            return this;
        }

        public TopicProduceData setPartitions(List<PartitionProduceData> v) {
            this.partitions = v;
            return this;
        }

        static {
            SCHEMA_8 = SCHEMA_7 = (SCHEMA_6 = (SCHEMA_5 = (SCHEMA_4 = (SCHEMA_3 = (SCHEMA_2 = (SCHEMA_1 = (SCHEMA_0 = new Schema(new Field("name", Type.STRING, "The topic name."), new Field("partitions", new ArrayOf(PartitionProduceData.SCHEMA_0), "Each partition to produce to.")))))))));
            SCHEMAS = new Schema[]{SCHEMA_0, SCHEMA_1, SCHEMA_2, SCHEMA_3, SCHEMA_4, SCHEMA_5, SCHEMA_6, SCHEMA_7, SCHEMA_8};
        }
    }
}

