/*
 * Decompiled with CFR 0.152.
 */
package nokogiri;

import nokogiri.NokogiriService;
import nokogiri.XmlDocument;
import nokogiri.internals.NokogiriHelpers;
import nokogiri.internals.SaveContextVisitor;
import org.jruby.Ruby;
import org.jruby.RubyClass;
import org.jruby.RubyObject;
import org.jruby.RubyString;
import org.jruby.anno.JRubyClass;
import org.jruby.anno.JRubyMethod;
import org.jruby.runtime.ThreadContext;
import org.jruby.runtime.builtin.IRubyObject;
import org.w3c.dom.Attr;
import org.w3c.dom.Document;
import org.w3c.dom.Node;

@JRubyClass(name={"Nokogiri::XML::Namespace"})
public class XmlNamespace
extends RubyObject {
    private Attr attr;
    private IRubyObject prefix;
    private IRubyObject href;
    private String prefixString;
    private String hrefString;

    public XmlNamespace(Ruby ruby, RubyClass rubyClass) {
        super(ruby, rubyClass);
    }

    public Node getNode() {
        return this.attr;
    }

    public String getPrefix() {
        return this.prefixString;
    }

    public String getHref() {
        return this.hrefString;
    }

    void deleteHref() {
        this.hrefString = "http://www.w3.org/XML/1998/namespace";
        this.href = NokogiriHelpers.stringOrNil(this.getRuntime(), this.hrefString);
        this.attr.getOwnerElement().removeAttributeNode(this.attr);
    }

    public void init(Attr attr, IRubyObject iRubyObject, IRubyObject iRubyObject2, IRubyObject iRubyObject3) {
        this.init(attr, iRubyObject, iRubyObject2, (String)iRubyObject.toJava(String.class), (String)iRubyObject2.toJava(String.class), iRubyObject3);
    }

    public void init(Attr attr, IRubyObject iRubyObject, IRubyObject iRubyObject2, String string, String string2, IRubyObject iRubyObject3) {
        this.attr = attr;
        this.prefix = iRubyObject;
        this.href = iRubyObject2;
        this.prefixString = string;
        this.hrefString = string2;
        this.setInstanceVariable("@document", iRubyObject3);
    }

    public static XmlNamespace createFromAttr(Ruby ruby, Attr attr) {
        IRubyObject iRubyObject;
        String string = NokogiriHelpers.getLocalNameForNamespace(attr.getName());
        if (string == null) {
            iRubyObject = ruby.getNil();
            string = "";
        } else {
            iRubyObject = RubyString.newString((Ruby)ruby, (String)string);
        }
        String string2 = attr.getValue();
        RubyString rubyString = RubyString.newString((Ruby)ruby, (String)string2);
        XmlDocument xmlDocument = (XmlDocument)NokogiriHelpers.getCachedNodeOrCreate(ruby, attr.getOwnerDocument());
        xmlDocument.initializeNamespaceCacheIfNecessary();
        XmlNamespace xmlNamespace = xmlDocument.getNamespaceCache().get(string, string2);
        if (xmlNamespace != null) {
            return xmlNamespace;
        }
        XmlNamespace xmlNamespace2 = (XmlNamespace)NokogiriService.XML_NAMESPACE_ALLOCATOR.allocate(ruby, NokogiriHelpers.getNokogiriClass(ruby, "Nokogiri::XML::Namespace"));
        xmlNamespace2.init(attr, iRubyObject, (IRubyObject)rubyString, string, string2, (IRubyObject)xmlDocument);
        xmlDocument.getNamespaceCache().put(xmlNamespace2, attr.getOwnerElement());
        return xmlNamespace2;
    }

    public static XmlNamespace createFromPrefixAndHref(Node node, IRubyObject iRubyObject, IRubyObject iRubyObject2) {
        String string = iRubyObject.isNil() ? "" : (String)iRubyObject.toJava(String.class);
        String string2 = (String)iRubyObject2.toJava(String.class);
        Ruby ruby = iRubyObject.getRuntime();
        Document document = node.getOwnerDocument();
        XmlDocument xmlDocument = (XmlDocument)NokogiriHelpers.getCachedNodeOrCreate(ruby, document);
        xmlDocument.initializeNamespaceCacheIfNecessary();
        XmlNamespace xmlNamespace = xmlDocument.getNamespaceCache().get(string, string2);
        if (xmlNamespace != null) {
            return xmlNamespace;
        }
        XmlNamespace xmlNamespace2 = (XmlNamespace)NokogiriService.XML_NAMESPACE_ALLOCATOR.allocate(ruby, NokogiriHelpers.getNokogiriClass(ruby, "Nokogiri::XML::Namespace"));
        String string3 = "xmlns";
        if (!"".equals(string)) {
            string3 = string3 + ":" + string;
        }
        Attr attr = document.createAttribute(string3);
        attr.setNodeValue(string2);
        xmlNamespace2.init(attr, iRubyObject, iRubyObject2, string, string2, (IRubyObject)xmlDocument);
        xmlDocument.getNamespaceCache().put(xmlNamespace2, node);
        return xmlNamespace2;
    }

    public static XmlNamespace createDefaultNamespace(Ruby ruby, Node node) {
        String string = node.getPrefix();
        String string2 = node.getNamespaceURI();
        Document document = node.getOwnerDocument();
        XmlDocument xmlDocument = (XmlDocument)NokogiriHelpers.getCachedNodeOrCreate(ruby, document);
        XmlNamespace xmlNamespace = xmlDocument.getNamespaceCache().get(string, string2);
        if (xmlNamespace != null) {
            return xmlNamespace;
        }
        XmlNamespace xmlNamespace2 = (XmlNamespace)NokogiriService.XML_NAMESPACE_ALLOCATOR.allocate(ruby, NokogiriHelpers.getNokogiriClass(ruby, "Nokogiri::XML::Namespace"));
        IRubyObject iRubyObject = NokogiriHelpers.stringOrNil(ruby, string);
        IRubyObject iRubyObject2 = NokogiriHelpers.stringOrNil(ruby, string2);
        xmlNamespace2.init((Attr)node, iRubyObject, iRubyObject2, string, string2, (IRubyObject)xmlDocument);
        xmlDocument.getNamespaceCache().put(xmlNamespace2, node);
        return xmlNamespace2;
    }

    public Object clone() throws CloneNotSupportedException {
        return super.clone();
    }

    public boolean isEmpty() {
        return this.prefix.isNil() && this.href.isNil();
    }

    @JRubyMethod
    public IRubyObject href(ThreadContext threadContext) {
        return this.href;
    }

    @JRubyMethod
    public IRubyObject prefix(ThreadContext threadContext) {
        return this.prefix;
    }

    public void accept(ThreadContext threadContext, SaveContextVisitor saveContextVisitor) {
        String string = " " + this.prefix + "=\"" + this.href + "\"";
        saveContextVisitor.enter(string);
        saveContextVisitor.leave(string);
    }
}

