/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.cloud.autoscaling;

import java.io.PrintWriter;
import java.io.StringWriter;
import java.lang.invoke.MethodHandles;
import java.util.Collection;
import java.util.Date;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.StringJoiner;
import org.apache.solr.client.solrj.SolrRequest;
import org.apache.solr.client.solrj.cloud.SolrCloudManager;
import org.apache.solr.client.solrj.cloud.autoscaling.AutoScalingConfig;
import org.apache.solr.client.solrj.cloud.autoscaling.TriggerEventProcessorStage;
import org.apache.solr.client.solrj.request.UpdateRequest;
import org.apache.solr.cloud.autoscaling.ActionContext;
import org.apache.solr.cloud.autoscaling.TriggerEvent;
import org.apache.solr.cloud.autoscaling.TriggerListenerBase;
import org.apache.solr.cloud.autoscaling.TriggerValidationException;
import org.apache.solr.common.SolrException;
import org.apache.solr.common.SolrInputDocument;
import org.apache.solr.common.cloud.ClusterState;
import org.apache.solr.common.cloud.DocCollection;
import org.apache.solr.common.params.SolrParams;
import org.apache.solr.common.util.NamedList;
import org.apache.solr.common.util.Utils;
import org.apache.solr.core.SolrResourceLoader;
import org.apache.solr.util.IdUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SystemLogListener
extends TriggerListenerBase {
    private static final Logger log = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());
    public static final String SOURCE_FIELD = "source_s";
    public static final String EVENT_SOURCE_FIELD = "event.source_s";
    public static final String EVENT_TYPE_FIELD = "event.type_s";
    public static final String STAGE_FIELD = "stage_s";
    public static final String ACTION_FIELD = "action_s";
    public static final String MESSAGE_FIELD = "message_t";
    public static final String BEFORE_ACTIONS_FIELD = "before.actions_ss";
    public static final String AFTER_ACTIONS_FIELD = "after.actions_ss";
    public static final String COLLECTIONS_FIELD = "collections_ss";
    public static final String SOURCE = SystemLogListener.class.getSimpleName();
    public static final String DOC_TYPE = "autoscaling_event";
    private String collection = ".system";

    @Override
    public void configure(SolrResourceLoader loader, SolrCloudManager cloudManager, AutoScalingConfig.TriggerListenerConfig config) throws TriggerValidationException {
        super.configure(loader, cloudManager, config);
        this.collection = config.properties.getOrDefault("collection", ".system");
    }

    @Override
    public void onEvent(TriggerEvent event, TriggerEventProcessorStage stage, String actionName, ActionContext context, Throwable error, String message) throws Exception {
        try {
            ClusterState clusterState = this.cloudManager.getClusterStateProvider().getClusterState();
            DocCollection coll = clusterState.getCollectionOrNull(this.collection);
            if (coll == null) {
                log.debug("Collection {} missing, skip sending event {}", (Object)this.collection, (Object)event);
                return;
            }
            SolrInputDocument doc = new SolrInputDocument(new String[0]);
            doc.addField("type", (Object)DOC_TYPE);
            doc.addField(SOURCE_FIELD, (Object)SOURCE);
            doc.addField("id", (Object)IdUtils.timeRandomId());
            doc.addField("event.id_s", (Object)event.getId());
            doc.addField(EVENT_TYPE_FIELD, (Object)event.getEventType().toString());
            doc.addField(EVENT_SOURCE_FIELD, (Object)event.getSource());
            doc.addField("event.time_l", (Object)event.getEventTime());
            doc.addField("timestamp", (Object)new Date());
            this.addMap("event.property.", doc, event.getProperties());
            doc.addField(STAGE_FIELD, (Object)stage.toString());
            if (actionName != null) {
                doc.addField(ACTION_FIELD, (Object)actionName);
            }
            if (message != null) {
                doc.addField(MESSAGE_FIELD, (Object)message);
            }
            this.addError(doc, error);
            String eventJson = Utils.toJSONString((Object)event);
            doc.addField("event_str", (Object)eventJson);
            if (context != null) {
                this.addOperations(doc, (List)context.getProperties().get("operations"));
                this.addResponses(doc, (List)context.getProperties().get("responses"));
                this.addActions(BEFORE_ACTIONS_FIELD, doc, (List)context.getProperties().get(TriggerEventProcessorStage.BEFORE_ACTION.toString()));
                this.addActions(AFTER_ACTIONS_FIELD, doc, (List)context.getProperties().get(TriggerEventProcessorStage.AFTER_ACTION.toString()));
                String contextJson = Utils.toJSONString((Object)context);
                doc.addField("context_str", (Object)contextJson);
            }
            UpdateRequest req = new UpdateRequest();
            req.add(doc);
            req.setParam("collection", this.collection);
            this.cloudManager.request((SolrRequest)req);
        }
        catch (Exception e) {
            if (e instanceof SolrException && e.getMessage().contains("Collection not found")) {
                log.info("Collection {} missing, skip sending event {}", (Object)this.collection, (Object)event);
            }
            log.warn("Exception sending event. Collection: {}, event: {}, exception: {}", new Object[]{this.collection, event, e});
        }
    }

    private void addActions(String field, SolrInputDocument doc, List<String> actions) {
        if (actions == null) {
            return;
        }
        actions.forEach(a -> doc.addField(field, a));
    }

    private void addMap(String prefix, SolrInputDocument doc, Map<String, Object> map) {
        map.forEach((k, v) -> {
            if (v instanceof Collection) {
                for (Object o : (Collection)v) {
                    doc.addField(prefix + k + "_ss", (Object)String.valueOf(o));
                }
            } else {
                doc.addField(prefix + k + "_ss", (Object)String.valueOf(v));
            }
        });
    }

    private void addOperations(SolrInputDocument doc, List<SolrRequest> operations) {
        if (operations == null || operations.isEmpty()) {
            return;
        }
        HashSet<String> collections = new HashSet<String>();
        for (SolrRequest req : operations) {
            SolrParams params = req.getParams();
            if (params == null) continue;
            if (params.get("collection") != null) {
                collections.add(params.get("collection"));
            }
            StringJoiner paramJoiner = new StringJoiner(" ");
            paramJoiner.setEmptyValue("");
            Iterator it = params.getParameterNamesIterator();
            while (it.hasNext()) {
                String[] values;
                String name = (String)it.next();
                for (String value : values = params.getParams(name)) {
                    paramJoiner.add(name + "=" + value);
                }
            }
            String paramString = paramJoiner.toString();
            if (paramString.isEmpty()) continue;
            doc.addField("operations.params_ts", (Object)paramString);
        }
        if (!collections.isEmpty()) {
            doc.addField(COLLECTIONS_FIELD, collections);
        }
    }

    private void addResponses(SolrInputDocument doc, List<NamedList<Object>> responses) {
        if (responses == null || responses.isEmpty()) {
            return;
        }
        for (NamedList<Object> rsp : responses) {
            Object o = rsp.get("success");
            if (o != null) {
                doc.addField("responses_ts", (Object)("success " + o));
                continue;
            }
            o = rsp.get("failure");
            if (o != null) {
                doc.addField("responses_ts", (Object)("failure " + o));
                continue;
            }
            doc.addField("responses_ts", (Object)Utils.toJSONString(rsp));
        }
    }

    private void addError(SolrInputDocument doc, Throwable error) {
        if (error == null) {
            return;
        }
        StringWriter sw = new StringWriter();
        PrintWriter pw = new PrintWriter(sw);
        error.printStackTrace(pw);
        pw.flush();
        pw.close();
        doc.addField("error.message_t", (Object)error.getMessage());
        doc.addField("error.details_t", (Object)sw.toString());
    }
}

