/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derby.impl.sql.compile;

import org.apache.derby.iapi.error.StandardException;
import org.apache.derby.iapi.services.io.FormatableBitSet;
import org.apache.derby.iapi.sql.compile.Visitor;
import org.apache.derby.iapi.sql.dictionary.ConglomerateDescriptor;
import org.apache.derby.iapi.sql.dictionary.ConstraintDescriptorList;
import org.apache.derby.iapi.sql.dictionary.DataDictionary;
import org.apache.derby.iapi.sql.dictionary.SchemaDescriptor;
import org.apache.derby.iapi.sql.dictionary.TableDescriptor;
import org.apache.derby.iapi.sql.execute.ConstantAction;
import org.apache.derby.impl.sql.compile.ColumnDefinitionNode;
import org.apache.derby.impl.sql.compile.DDLStatementNode;
import org.apache.derby.impl.sql.compile.FromList;
import org.apache.derby.impl.sql.compile.TableElementList;
import org.apache.derby.impl.sql.execute.ColumnInfo;
import org.apache.derby.impl.sql.execute.ConstraintConstantAction;
import org.apache.derby.impl.sql.execute.CreateConstraintConstantAction;

public class AlterTableNode
extends DDLStatementNode {
    public TableElementList tableElementList = null;
    public char lockGranularity;
    private boolean updateStatistics = false;
    private boolean updateStatisticsAll = false;
    private boolean dropStatistics;
    private boolean dropStatisticsAll;
    private String indexNameForStatistics;
    public boolean compressTable = false;
    public boolean sequential = false;
    public boolean purge = false;
    public boolean defragment = false;
    public boolean truncateEndOfTable = false;
    public int behavior;
    public TableDescriptor baseTable;
    protected int numConstraints;
    private int changeType = 0;
    private boolean truncateTable = false;
    protected SchemaDescriptor schemaDescriptor = null;
    protected ColumnInfo[] colInfos = null;
    protected ConstraintConstantAction[] conActions = null;

    public void init(Object object) throws StandardException {
        this.initAndCheck(object);
        this.truncateTable = true;
        this.schemaDescriptor = this.getSchemaDescriptor();
    }

    public void init(Object object, Object object2) throws StandardException {
        this.initAndCheck(object);
        this.sequential = (Boolean)object2;
        this.compressTable = true;
        this.schemaDescriptor = this.getSchemaDescriptor();
    }

    public void init(Object object, Object object2, Object object3, Object object4) throws StandardException {
        this.initAndCheck(object);
        this.purge = (Boolean)object2;
        this.defragment = (Boolean)object3;
        this.truncateEndOfTable = (Boolean)object4;
        this.compressTable = true;
        this.schemaDescriptor = this.getSchemaDescriptor(true, false);
    }

    public void init(Object object, Object object2, Object object3, Object object4, Object object5) throws StandardException {
        this.initAndCheck(object);
        int[] nArray = (int[])object2;
        this.changeType = nArray[0];
        switch (this.changeType) {
            case 1: 
            case 2: 
            case 3: 
            case 4: {
                this.tableElementList = (TableElementList)object3;
                this.lockGranularity = ((Character)object4).charValue();
                int[] nArray2 = (int[])object5;
                this.behavior = nArray2[0];
                break;
            }
            case 5: {
                this.updateStatisticsAll = (Boolean)object3;
                this.indexNameForStatistics = (String)object4;
                this.updateStatistics = true;
                break;
            }
            case 6: {
                this.dropStatisticsAll = (Boolean)object3;
                this.indexNameForStatistics = (String)object4;
                this.dropStatistics = true;
                break;
            }
            default: {
                throw StandardException.newException("0A000.S");
            }
        }
        this.schemaDescriptor = this.getSchemaDescriptor();
    }

    public String toString() {
        return "";
    }

    public void printSubNodes(int n) {
    }

    public String statementToString() {
        if (this.truncateTable) {
            return "TRUNCATE TABLE";
        }
        return "ALTER TABLE";
    }

    public int getChangeType() {
        return this.changeType;
    }

    public void bindStatement() throws StandardException {
        Object object;
        DataDictionary dataDictionary = this.getDataDictionary();
        int n = 0;
        int n2 = 0;
        int n3 = 0;
        int n4 = 0;
        this.baseTable = this.compressTable && (this.purge || this.defragment || this.truncateEndOfTable) ? this.getTableDescriptor(false) : this.getTableDescriptor();
        if (this.baseTable.getTableType() == 3) {
            throw StandardException.newException("42995");
        }
        this.getCompilerContext().createDependency(this.baseTable);
        if (this.changeType == 1 && this.tableElementList != null) {
            for (int i = 0; i < this.tableElementList.size(); ++i) {
                if (!(this.tableElementList.elementAt(i) instanceof ColumnDefinitionNode) || ((ColumnDefinitionNode)(object = (ColumnDefinitionNode)this.tableElementList.elementAt(i))).hasGenerationClause() && ((ColumnDefinitionNode)object).getType() == null) continue;
                if (((ColumnDefinitionNode)object).getType() == null) {
                    throw StandardException.newException("42XA9", ((ColumnDefinitionNode)object).getColumnName());
                }
                if (!((ColumnDefinitionNode)object).getType().getTypeId().isStringTypeId()) continue;
                ((ColumnDefinitionNode)object).setCollationType(this.schemaDescriptor.getCollationType());
            }
        }
        if (this.tableElementList != null) {
            this.tableElementList.validate(this, dataDictionary, this.baseTable);
            if (this.tableElementList.countNumberOfColumns() + this.baseTable.getNumberOfColumns() > 1012) {
                throw StandardException.newException("54011", (Object)String.valueOf(this.tableElementList.countNumberOfColumns() + this.baseTable.getNumberOfColumns()), (Object)this.getRelativeName(), (Object)String.valueOf(1012));
            }
            n4 = this.tableElementList.countConstraints(2) + this.tableElementList.countConstraints(6) + this.tableElementList.countConstraints(3);
            n = this.tableElementList.countConstraints(4);
            n2 = this.tableElementList.countConstraints(6);
            n3 = this.tableElementList.countGenerationClauses();
        }
        if (n4 + this.baseTable.getTotalNumberOfIndexes() > Short.MAX_VALUE) {
            throw StandardException.newException("42Z9F", (Object)String.valueOf(n4 + this.baseTable.getTotalNumberOfIndexes()), (Object)this.getRelativeName(), (Object)String.valueOf(Short.MAX_VALUE));
        }
        if (n > 0 || n3 > 0 || n2 > 0) {
            FromList fromList = this.makeFromList(dataDictionary, this.tableElementList, false);
            object = this.baseTable.makeColumnMap(this.baseTable.getGeneratedColumns());
            if (n3 > 0) {
                this.tableElementList.bindAndValidateGenerationClauses(this.schemaDescriptor, fromList, (FormatableBitSet)object, this.baseTable);
            }
            if (n > 0) {
                this.tableElementList.bindAndValidateCheckConstraints(fromList);
            }
            if (n2 > 0) {
                this.tableElementList.validateForeignKeysOnGenerationClauses(fromList, (FormatableBitSet)object);
            }
        }
        if (this.tableElementList != null) {
            this.tableElementList.validatePrimaryKeyNullability();
        }
        if (this.updateStatistics && !this.updateStatisticsAll || this.dropStatistics && !this.dropStatisticsAll) {
            ConglomerateDescriptor conglomerateDescriptor = null;
            if (this.schemaDescriptor.getUUID() != null) {
                conglomerateDescriptor = dataDictionary.getConglomerateDescriptor(this.indexNameForStatistics, this.schemaDescriptor, false);
            }
            if (conglomerateDescriptor == null) {
                throw StandardException.newException("42X65", this.schemaDescriptor.getSchemaName() + "." + this.indexNameForStatistics);
            }
        }
        this.getCompilerContext().createDependency(this.baseTable);
    }

    public boolean referencesSessionSchema() throws StandardException {
        return this.isSessionSchema(this.baseTable.getSchemaName());
    }

    public ConstantAction makeConstantAction() throws StandardException {
        this.prepConstantAction();
        return this.getGenericConstantActionFactory().getAlterTableConstantAction(this.schemaDescriptor, this.getRelativeName(), this.baseTable.getUUID(), this.baseTable.getHeapConglomerateId(), 0, this.colInfos, this.conActions, this.lockGranularity, this.compressTable, this.behavior, this.sequential, this.truncateTable, this.purge, this.defragment, this.truncateEndOfTable, this.updateStatistics, this.updateStatisticsAll, this.dropStatistics, this.dropStatisticsAll, this.indexNameForStatistics);
    }

    private void prepConstantAction() throws StandardException {
        if (this.tableElementList != null) {
            this.genColumnInfo();
        }
        if (this.numConstraints > 0) {
            this.conActions = new ConstraintConstantAction[this.numConstraints];
            this.tableElementList.genConstraintActions(false, this.conActions, this.getRelativeName(), this.schemaDescriptor, this.getDataDictionary());
            for (int i = 0; i < this.conActions.length; ++i) {
                DataDictionary dataDictionary;
                ConstraintDescriptorList constraintDescriptorList;
                int n;
                ConstraintConstantAction constraintConstantAction = this.conActions[i];
                if (!(constraintConstantAction instanceof CreateConstraintConstantAction) || (n = constraintConstantAction.getConstraintType()) != 2 || (constraintDescriptorList = (dataDictionary = this.getDataDictionary()).getConstraintDescriptors(this.baseTable)).getPrimaryKey() == null) continue;
                throw StandardException.newException("X0Y58.S", this.baseTable.getQualifiedName());
            }
        }
    }

    public void genColumnInfo() throws StandardException {
        this.colInfos = new ColumnInfo[this.tableElementList.countNumberOfColumns()];
        this.numConstraints = this.tableElementList.genColumnInfos(this.colInfos);
    }

    void acceptChildren(Visitor visitor) throws StandardException {
        super.acceptChildren(visitor);
        if (this.tableElementList != null) {
            this.tableElementList.accept(visitor);
        }
    }
}

