/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.analytics.function.mapping;

import org.apache.solr.analytics.ExpressionFactory;
import org.apache.solr.analytics.function.mapping.LambdaFunction;
import org.apache.solr.analytics.value.AnalyticsValueStream;
import org.apache.solr.analytics.value.DoubleValueStream;
import org.apache.solr.analytics.value.FloatValueStream;
import org.apache.solr.analytics.value.IntValueStream;
import org.apache.solr.analytics.value.LongValueStream;
import org.apache.solr.common.SolrException;

public class AbsoluteValueFunction {
    public static final String name = "abs";
    public static final ExpressionFactory.CreatorFunction creatorFunction = params -> {
        if (params.length != 1) {
            throw new SolrException(SolrException.ErrorCode.BAD_REQUEST, "The abs function requires 1 paramaters, " + params.length + " found.");
        }
        AnalyticsValueStream param = params[0];
        if (param instanceof IntValueStream) {
            return LambdaFunction.createIntLambdaFunction(name, x -> x < 0 ? x * -1 : x, (IntValueStream)param);
        }
        if (param instanceof LongValueStream) {
            return LambdaFunction.createLongLambdaFunction(name, x -> x < 0L ? x * -1L : x, (LongValueStream)param);
        }
        if (param instanceof FloatValueStream) {
            return LambdaFunction.createFloatLambdaFunction(name, x -> x < 0.0f ? x * -1.0f : x, (FloatValueStream)param);
        }
        if (param instanceof DoubleValueStream) {
            return LambdaFunction.createDoubleLambdaFunction(name, x -> x < 0.0 ? x * -1.0 : x, (DoubleValueStream)param);
        }
        throw new SolrException(SolrException.ErrorCode.BAD_REQUEST, "The abs function requires a numeric parameter, " + param.getExpressionStr() + " found.");
    };
}

