/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.store.hdfs;

import java.io.Closeable;
import java.io.IOException;
import java.lang.invoke.MethodHandles;
import java.net.URI;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import java.util.concurrent.atomic.AtomicLong;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FSDataInputStream;
import org.apache.hadoop.fs.FileAlreadyExistsException;
import org.apache.hadoop.fs.FileContext;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Options;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hdfs.DistributedFileSystem;
import org.apache.hadoop.hdfs.protocol.HdfsConstants;
import org.apache.lucene.store.BaseDirectory;
import org.apache.lucene.store.IOContext;
import org.apache.lucene.store.IndexInput;
import org.apache.lucene.store.IndexOutput;
import org.apache.lucene.store.LockFactory;
import org.apache.solr.common.util.IOUtils;
import org.apache.solr.store.blockcache.CustomBufferedIndexInput;
import org.apache.solr.store.hdfs.HdfsFileWriter;
import org.apache.solr.store.hdfs.HdfsLockFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HdfsDirectory
extends BaseDirectory {
    private static final Logger log = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());
    public static final int DEFAULT_BUFFER_SIZE = 4096;
    private static final String LF_EXT = ".lf";
    protected final Path hdfsDirPath;
    protected final Configuration configuration;
    private final FileSystem fileSystem;
    private final FileContext fileContext;
    private final int bufferSize;
    private final AtomicLong nextTempFileCounter = new AtomicLong();

    public HdfsDirectory(Path hdfsDirPath, Configuration configuration) throws IOException {
        this(hdfsDirPath, HdfsLockFactory.INSTANCE, configuration, 4096);
    }

    public HdfsDirectory(Path hdfsDirPath, LockFactory lockFactory, Configuration configuration, int bufferSize) throws IOException {
        super(lockFactory);
        this.hdfsDirPath = hdfsDirPath;
        this.configuration = configuration;
        this.bufferSize = bufferSize;
        this.fileSystem = FileSystem.get((URI)hdfsDirPath.toUri(), (Configuration)configuration);
        this.fileContext = FileContext.getFileContext((URI)hdfsDirPath.toUri(), (Configuration)configuration);
        if (this.fileSystem instanceof DistributedFileSystem) {
            while (((DistributedFileSystem)this.fileSystem).setSafeMode(HdfsConstants.SafeModeAction.SAFEMODE_GET, true)) {
                log.warn("The NameNode is in SafeMode - Solr will wait 5 seconds and try again.");
                try {
                    Thread.sleep(5000L);
                }
                catch (InterruptedException e) {
                    Thread.interrupted();
                }
            }
        }
        try {
            boolean success;
            if (!this.fileSystem.exists(hdfsDirPath) && !(success = this.fileSystem.mkdirs(hdfsDirPath))) {
                throw new RuntimeException("Could not create directory: " + hdfsDirPath);
            }
        }
        catch (Exception e) {
            IOUtils.closeQuietly((Closeable)this.fileSystem);
            throw new RuntimeException("Problem creating directory: " + hdfsDirPath, e);
        }
        log.warn("HDFS support in Solr has been deprecated as of 8.6. See SOLR-14021 for details.");
    }

    public void close() throws IOException {
        log.info("Closing hdfs directory {}", (Object)this.hdfsDirPath);
        this.fileSystem.close();
        this.isOpen = false;
    }

    public boolean isClosed() {
        return !this.isOpen;
    }

    public IndexOutput createOutput(String name, IOContext context) throws IOException {
        try {
            return new HdfsFileWriter(this.getFileSystem(), new Path(this.hdfsDirPath, name), name);
        }
        catch (FileAlreadyExistsException e) {
            java.nio.file.FileAlreadyExistsException ex = new java.nio.file.FileAlreadyExistsException(e.getMessage());
            ex.initCause(e);
            throw ex;
        }
    }

    public IndexOutput createTempOutput(String prefix, String suffix, IOContext context) throws IOException {
        while (true) {
            try {
                String name = HdfsDirectory.getTempFileName((String)prefix, (String)suffix, (long)this.nextTempFileCounter.getAndIncrement());
                return new HdfsFileWriter(this.getFileSystem(), new Path(this.hdfsDirPath, name), name);
            }
            catch (FileAlreadyExistsException fileAlreadyExistsException) {
                continue;
            }
            break;
        }
    }

    private String[] getNormalNames(List<String> files) {
        int size = files.size();
        for (int i = 0; i < size; ++i) {
            String str = files.get(i);
            files.set(i, this.toNormalName(str));
        }
        return files.toArray(new String[0]);
    }

    private String toNormalName(String name) {
        if (name.endsWith(LF_EXT)) {
            return name.substring(0, name.length() - 3);
        }
        return name;
    }

    public IndexInput openInput(String name, IOContext context) throws IOException {
        return new HdfsIndexInput(name, this.getFileSystem(), new Path(this.hdfsDirPath, name), this.bufferSize);
    }

    public void deleteFile(String name) throws IOException {
        Path path = new Path(this.hdfsDirPath, name);
        log.debug("Deleting {}", (Object)path);
        this.getFileSystem().delete(path, false);
    }

    public void rename(String source, String dest) throws IOException {
        Path sourcePath = new Path(this.hdfsDirPath, source);
        Path destPath = new Path(this.hdfsDirPath, dest);
        this.fileContext.rename(sourcePath, destPath, new Options.Rename[0]);
    }

    public void syncMetaData() throws IOException {
    }

    public long fileLength(String name) throws IOException {
        FileStatus fileStatus = this.fileSystem.getFileStatus(new Path(this.hdfsDirPath, name));
        return fileStatus.getLen();
    }

    public long fileModified(String name) throws IOException {
        FileStatus fileStatus = this.getFileSystem().getFileStatus(new Path(this.hdfsDirPath, name));
        return fileStatus.getModificationTime();
    }

    public String[] listAll() throws IOException {
        FileStatus[] listStatus = this.getFileSystem().listStatus(this.hdfsDirPath);
        ArrayList<String> files = new ArrayList<String>();
        if (listStatus == null) {
            return new String[0];
        }
        for (FileStatus status : listStatus) {
            files.add(status.getPath().getName());
        }
        return this.getNormalNames(files);
    }

    public Path getHdfsDirPath() {
        return this.hdfsDirPath;
    }

    public FileSystem getFileSystem() {
        return this.fileSystem;
    }

    public Configuration getConfiguration() {
        return this.configuration;
    }

    public Set<String> getPendingDeletions() {
        return Collections.emptySet();
    }

    public void sync(Collection<String> names) throws IOException {
        if (log.isDebugEnabled()) {
            log.debug("Sync called on {}", (Object)Arrays.toString(names.toArray()));
        }
    }

    public int hashCode() {
        return this.hdfsDirPath.hashCode();
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof HdfsDirectory)) {
            return false;
        }
        return this.hdfsDirPath.equals((Object)((HdfsDirectory)((Object)obj)).hdfsDirPath);
    }

    public String toString() {
        return ((Object)((Object)this)).getClass().getSimpleName() + "@" + this.hdfsDirPath + " lockFactory=" + this.lockFactory;
    }

    public static class HdfsIndexInput
    extends CustomBufferedIndexInput {
        private static final Logger log = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());
        private final Path path;
        private final FSDataInputStream inputStream;
        private final long length;
        private boolean clone = false;

        public HdfsIndexInput(String name, FileSystem fileSystem, Path path, int bufferSize) throws IOException {
            super(name, bufferSize);
            this.path = path;
            log.debug("Opening normal index input on {}", (Object)path);
            FileStatus fileStatus = fileSystem.getFileStatus(path);
            this.length = fileStatus.getLen();
            this.inputStream = fileSystem.open(path, bufferSize);
        }

        @Override
        protected void readInternal(byte[] b, int offset, int length) throws IOException {
            this.inputStream.readFully(this.getFilePointer(), b, offset, length);
        }

        @Override
        protected void seekInternal(long pos) throws IOException {
        }

        @Override
        protected void closeInternal() throws IOException {
            log.debug("Closing normal index input on {}", (Object)this.path);
            if (!this.clone) {
                this.inputStream.close();
            }
        }

        public long length() {
            return this.length;
        }

        @Override
        public IndexInput clone() {
            HdfsIndexInput clone = (HdfsIndexInput)super.clone();
            clone.clone = true;
            return clone;
        }
    }
}

