/*
 * Decompiled with CFR 0.152.
 */
package com.carrotsearch.ant.tasks.junit4.dependencies.org.objectweb.asm;

import com.carrotsearch.ant.tasks.junit4.dependencies.org.objectweb.asm.AnnotationVisitor;
import com.carrotsearch.ant.tasks.junit4.dependencies.org.objectweb.asm.AnnotationWriter;
import com.carrotsearch.ant.tasks.junit4.dependencies.org.objectweb.asm.Attribute;
import com.carrotsearch.ant.tasks.junit4.dependencies.org.objectweb.asm.ByteVector;
import com.carrotsearch.ant.tasks.junit4.dependencies.org.objectweb.asm.FieldVisitor;
import com.carrotsearch.ant.tasks.junit4.dependencies.org.objectweb.asm.SymbolTable;
import com.carrotsearch.ant.tasks.junit4.dependencies.org.objectweb.asm.TypePath;
import com.carrotsearch.ant.tasks.junit4.dependencies.org.objectweb.asm.TypeReference;

final class FieldWriter
extends FieldVisitor {
    private final SymbolTable symbolTable;
    private final int accessFlags;
    private final int nameIndex;
    private final int descriptorIndex;
    private int signatureIndex;
    private int constantValueIndex;
    private AnnotationWriter lastRuntimeVisibleAnnotation;
    private AnnotationWriter lastRuntimeInvisibleAnnotation;
    private AnnotationWriter lastRuntimeVisibleTypeAnnotation;
    private AnnotationWriter lastRuntimeInvisibleTypeAnnotation;
    private Attribute firstAttribute;

    FieldWriter(SymbolTable symbolTable, int n, String string, String string2, String string3, Object object) {
        super(393216);
        this.symbolTable = symbolTable;
        this.accessFlags = n;
        this.nameIndex = symbolTable.addConstantUtf8(string);
        this.descriptorIndex = symbolTable.addConstantUtf8(string2);
        if (string3 != null) {
            this.signatureIndex = symbolTable.addConstantUtf8(string3);
        }
        if (object != null) {
            this.constantValueIndex = symbolTable.addConstant((Object)object).index;
        }
    }

    public AnnotationVisitor visitAnnotation(String string, boolean bl) {
        ByteVector byteVector = new ByteVector();
        byteVector.putShort(this.symbolTable.addConstantUtf8(string)).putShort(0);
        if (bl) {
            this.lastRuntimeVisibleAnnotation = new AnnotationWriter(this.symbolTable, byteVector, this.lastRuntimeVisibleAnnotation);
            return this.lastRuntimeVisibleAnnotation;
        }
        this.lastRuntimeInvisibleAnnotation = new AnnotationWriter(this.symbolTable, byteVector, this.lastRuntimeInvisibleAnnotation);
        return this.lastRuntimeInvisibleAnnotation;
    }

    public AnnotationVisitor visitTypeAnnotation(int n, TypePath typePath, String string, boolean bl) {
        ByteVector byteVector = new ByteVector();
        TypeReference.putTarget(n, byteVector);
        TypePath.put(typePath, byteVector);
        byteVector.putShort(this.symbolTable.addConstantUtf8(string)).putShort(0);
        if (bl) {
            this.lastRuntimeVisibleTypeAnnotation = new AnnotationWriter(this.symbolTable, byteVector, this.lastRuntimeVisibleTypeAnnotation);
            return this.lastRuntimeVisibleTypeAnnotation;
        }
        this.lastRuntimeInvisibleTypeAnnotation = new AnnotationWriter(this.symbolTable, byteVector, this.lastRuntimeInvisibleTypeAnnotation);
        return this.lastRuntimeInvisibleTypeAnnotation;
    }

    public void visitAttribute(Attribute attribute) {
        attribute.nextAttribute = this.firstAttribute;
        this.firstAttribute = attribute;
    }

    public void visitEnd() {
    }
}

