/*
 * Decompiled with CFR 0.152.
 */
package com.sun.xml.bind.serializer;

import com.sun.xml.bind.serializer.NamespaceContext2;
import com.sun.xml.bind.serializer.PrefixCallback;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import org.xml.sax.SAXException;

public class NamespaceContextImpl
implements NamespaceContext2 {
    private int iota = 1;
    private String[] nsStack = new String[16];
    private int nsLen = 0;
    private int[] idxStack = new int[16];
    private int idxLen = 0;
    private final HashMap associationHistory = new HashMap();

    public NamespaceContextImpl() {
        this.addBinding(null, "");
        this.addBinding("xml", "http://www.w3.org/XML/1998/namespace");
        this.addBinding("xmlns", "http://www.w3.org/2000/xmlns/");
    }

    public String declareNamespace(String namespaceUri, boolean requirePrefix) {
        for (int i = this.nsLen - 2; i >= 0; i -= 2) {
            if (!this.nsStack[i + 1].equals(namespaceUri) || this.nsStack[i] == null && requirePrefix) continue;
            if ("".equals(this.nsStack[i])) {
                throw new InternalError();
            }
            return this.nsStack[i];
        }
        String prefix = this.assignPrefix(namespaceUri, requirePrefix);
        this.addBinding(prefix, namespaceUri);
        if ("".equals(prefix)) {
            throw new InternalError();
        }
        return prefix;
    }

    public String getPrefix(String namespaceUri) {
        return this.declareNamespace(namespaceUri, false);
    }

    public String getNamespaceURI(String prefix) {
        for (int i = this.nsLen - 2; i >= 0; i -= 2) {
            if (!this.nsStack[i].equals(prefix)) continue;
            return this.nsStack[i + 1];
        }
        return null;
    }

    public Iterator getPrefixes(String namespaceUri) {
        for (int i = this.nsLen - 2; i >= 0; i -= 2) {
            if (!this.nsStack[i + 1].equals(namespaceUri)) continue;
            ArrayList<String> al = new ArrayList<String>();
            al.add(this.nsStack[i]);
            return Collections.unmodifiableList(al).iterator();
        }
        return Collections.unmodifiableList(new ArrayList()).iterator();
    }

    public void startElement() {
        if (this.idxStack.length == this.idxLen) {
            int[] buf = new int[this.idxStack.length * 2];
            System.arraycopy(this.idxStack, 0, buf, 0, this.idxStack.length);
            this.idxStack = buf;
        }
        this.idxStack[this.idxLen++] = this.nsLen;
    }

    public void endElement() {
        this.nsLen = this.getStartIndex();
        --this.idxLen;
    }

    public void iterateDeclaredPrefixes(PrefixCallback callback) throws SAXException {
        for (int i = this.getStartIndex(); i < this.nsLen; i += 2) {
            String p = this.nsStack[i];
            if (p == null) continue;
            callback.onPrefixMapping(p, this.nsStack[i + 1]);
        }
    }

    private void addBinding(String prefix, String namespaceUri) {
        if (prefix != null && prefix.length() == 0) {
            throw new InternalError();
        }
        if (this.nsStack.length == this.nsLen) {
            String[] buf = new String[this.nsStack.length * 2];
            System.arraycopy(this.nsStack, 0, buf, 0, this.nsStack.length);
            this.nsStack = buf;
        }
        this.nsStack[this.nsLen++] = prefix;
        this.nsStack[this.nsLen++] = namespaceUri;
    }

    private String assignPrefix(String namespaceUri, boolean prefixRequired) {
        String prefix = (String)this.associationHistory.get(namespaceUri);
        if (prefix == null) {
            prefix = "ns" + this.iota++;
            this.associationHistory.put(namespaceUri, prefix);
        }
        return prefix;
    }

    private int getStartIndex() {
        return this.idxStack[this.idxLen - 1];
    }
}

