/*
 * Decompiled with CFR 0.152.
 */
package ca.odell.glazedlists.calculation;

import ca.odell.glazedlists.EventList;
import ca.odell.glazedlists.calculation.AbstractCalculation;
import ca.odell.glazedlists.event.ListEvent;
import ca.odell.glazedlists.event.ListEventListener;
import java.util.ArrayList;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractEventListCalculation<N, E>
extends AbstractCalculation<N>
implements ListEventListener<E> {
    private final EventList<E> source;
    private final List<E> snapshot;

    protected AbstractEventListCalculation(N initialValue, EventList<E> source) {
        super(initialValue);
        this.source = source;
        this.snapshot = new ArrayList<E>(source);
        for (E element : this.snapshot) {
            this.inserted(element);
        }
        this.source.addListEventListener(this);
    }

    @Override
    public void dispose() {
        this.source.removeListEventListener(this);
    }

    protected abstract void inserted(E var1);

    protected abstract void deleted(E var1);

    protected abstract void updated(E var1, E var2);

    @Override
    public void listChanged(ListEvent<E> listChanges) {
        Object oldValue = this.getValue();
        EventList<E> source = listChanges.getSourceList();
        while (listChanges.next()) {
            int index = listChanges.getIndex();
            switch (listChanges.getType()) {
                case 2: {
                    Object element = source.get(index);
                    this.snapshot.add(index, element);
                    this.inserted(element);
                    break;
                }
                case 0: {
                    this.deleted(this.snapshot.remove(index));
                    break;
                }
                case 1: {
                    Object newElement = source.get(index);
                    E oldElement = this.snapshot.set(index, newElement);
                    this.updated(oldElement, newElement);
                    break;
                }
            }
        }
        Object newValue = this.getValue();
        this.fireValueChange(oldValue, newValue);
    }
}

