/*
 * Decompiled with CFR 0.152.
 */
package au.com.trgtd.email;

import au.com.trgtd.email.Pop3;
import com.sun.mail.pop3.POP3SSLStore;
import java.util.List;
import java.util.Properties;
import java.util.Vector;
import java.util.logging.Logger;
import javax.mail.FetchProfile;
import javax.mail.Flags;
import javax.mail.Folder;
import javax.mail.Message;
import javax.mail.MessagingException;
import javax.mail.Session;
import javax.mail.Store;
import javax.mail.URLName;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class EmailUtils {
    private static final Logger LOG = Logger.getLogger("au.com.trgtd.email.EmailUtils");
    private static final String SSL_FACTORY = "javax.net.ssl.SSLSocketFactory";
    private Session session = null;
    private Store store = null;
    private String server;
    private String username;
    private String password;
    private boolean useSSL;
    private int port;
    private Folder folder;

    public void setServer(String server) {
        this.server = server;
    }

    public void setUserPass(String username, String password) {
        this.username = username;
        this.password = password;
    }

    public void setUseSSL(boolean useSSL) {
        this.useSSL = useSSL;
    }

    public void setPort(int port) {
        this.port = port;
    }

    public void connect() throws Exception {
        assert (this.server != null);
        assert (this.username != null);
        assert (this.password != null);
        Properties pop3Props = new Properties();
        if (this.useSSL && this.port > 0) {
            pop3Props.setProperty("mail.pop3.socketFactory.class", SSL_FACTORY);
            pop3Props.setProperty("mail.pop3.socketFactory.fallback", "false");
            pop3Props.setProperty("mail.pop3.port", Integer.toString(this.port));
            pop3Props.setProperty("mail.pop3.socketFactory.port", Integer.toString(this.port));
            URLName url = new URLName("pop3", this.server, this.port, "", this.username, this.password);
            this.session = Session.getInstance((Properties)pop3Props, null);
            this.store = new POP3SSLStore(this.session, url);
            this.store.connect();
        } else {
            Properties props = new Properties();
            this.session = Session.getDefaultInstance((Properties)props, null);
            this.store = this.session.getStore("pop3");
            this.store.connect(this.server, this.username, this.password);
        }
    }

    public void openFolder(String folderName) throws Exception {
        this.folder = this.store.getDefaultFolder();
        this.folder = this.folder.getFolder(folderName);
        if (this.folder == null) {
            throw new Exception("Invalid folder");
        }
        try {
            this.folder.open(2);
        }
        catch (MessagingException ex) {
            this.folder.open(1);
        }
    }

    public int getMessageCount() throws Exception {
        return this.folder.getMessageCount();
    }

    public int getNewMessageCount() throws Exception {
        return this.folder.getNewMessageCount();
    }

    public void disconnect() throws Exception {
        this.store.close();
    }

    public List<Message> getNewMessages() {
        Vector<Message> result = new Vector<Message>();
        try {
            Message[] messages = this.folder.getMessages();
            FetchProfile fp = new FetchProfile();
            fp.add(FetchProfile.Item.ENVELOPE);
            this.folder.fetch(messages, fp);
            for (Message message : messages) {
                if (message.isSet(Flags.Flag.DELETED)) continue;
                result.add(message);
            }
            return result;
        }
        catch (Exception e) {
            e.printStackTrace();
            return result;
        }
    }

    public String getSubject(Message msg) {
        try {
            return msg == null ? "" : msg.getSubject();
        }
        catch (Exception e) {
            e.printStackTrace();
            return "";
        }
    }

    public String getBody(Message msg) {
        try {
            return Pop3.Tools.getBody(msg);
        }
        catch (Exception ex) {
            LOG.info("Exception getting body of message. ");
            ex.printStackTrace();
            return "";
        }
    }

    public void delete(Message msg) {
        try {
            msg.setFlag(Flags.Flag.DELETED, true);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void closeFolder(boolean expunge) {
        try {
            this.folder.close(expunge);
        }
        catch (MessagingException e) {
            e.printStackTrace();
        }
    }
}

