/*
 * Decompiled with CFR 0.152.
 */
package org.jdesktop.swingx.plaf.basic;

import java.awt.Color;
import javax.swing.BorderFactory;
import javax.swing.Icon;
import javax.swing.UIManager;
import javax.swing.border.Border;
import javax.swing.border.CompoundBorder;
import org.jdesktop.swingx.JXMonthView;
import org.jdesktop.swingx.border.IconBorder;
import org.jdesktop.swingx.plaf.UIManagerExt;
import org.jdesktop.swingx.plaf.basic.CalendarState;
import org.jdesktop.swingx.renderer.CellContext;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class CalendarCellContext
extends CellContext<JXMonthView> {
    private CalendarState dayState;

    CalendarCellContext() {
    }

    public void installMonthContext(JXMonthView component, Object value, boolean selected, boolean focused, CalendarState dayState) {
        super.installContext(component, value, -1, -1, selected, focused, true, true);
        this.dayState = dayState;
    }

    public CalendarState getCalendarState() {
        return this.dayState;
    }

    @Override
    protected Color getForeground() {
        if (CalendarState.LEADING == this.dayState) {
            return UIManagerExt.getColor(this.getUIPrefix() + "leadingDayForeground");
        }
        if (CalendarState.TRAILING == this.dayState) {
            return UIManagerExt.getColor(this.getUIPrefix() + "trailingDayForeground");
        }
        if (CalendarState.TITLE == this.dayState && this.getComponent() != null) {
            return ((JXMonthView)this.getComponent()).getMonthStringForeground();
        }
        return super.getForeground();
    }

    @Override
    protected Color getBackground() {
        if (CalendarState.TITLE == this.dayState && this.getComponent() != null) {
            return ((JXMonthView)this.getComponent()).getMonthStringBackground();
        }
        return super.getBackground();
    }

    @Override
    protected Color getSelectionBackground() {
        if (CalendarState.LEADING == this.dayState || CalendarState.TRAILING == this.dayState) {
            return this.getBackground();
        }
        return this.getComponent() != null ? ((JXMonthView)this.getComponent()).getSelectionBackground() : null;
    }

    @Override
    protected Color getSelectionForeground() {
        if (CalendarState.LEADING == this.dayState || CalendarState.TRAILING == this.dayState) {
            return this.getForeground();
        }
        return this.getComponent() != null ? ((JXMonthView)this.getComponent()).getSelectionForeground() : null;
    }

    @Override
    protected Border getBorder() {
        if (this.getComponent() == null) {
            return super.getBorder();
        }
        if (CalendarState.TITLE == this.dayState) {
            return this.getTitleBorder();
        }
        if (this.isToday()) {
            int x = ((JXMonthView)this.getComponent()).getBoxPaddingX();
            int y = ((JXMonthView)this.getComponent()).getBoxPaddingY();
            Border todayBorder = BorderFactory.createLineBorder(((JXMonthView)this.getComponent()).getTodayBackground());
            Border empty = BorderFactory.createEmptyBorder(y - 1, x - 1, y - 1, x - 1);
            return BorderFactory.createCompoundBorder(todayBorder, empty);
        }
        return BorderFactory.createEmptyBorder(((JXMonthView)this.getComponent()).getBoxPaddingY(), ((JXMonthView)this.getComponent()).getBoxPaddingX(), ((JXMonthView)this.getComponent()).getBoxPaddingY(), ((JXMonthView)this.getComponent()).getBoxPaddingX());
    }

    private Border getTitleBorder() {
        if (((JXMonthView)this.getComponent()).isTraversable()) {
            Icon downIcon = UIManager.getIcon("JXMonthView.monthDownFileName");
            Icon upIcon = UIManager.getIcon("JXMonthView.monthUpFileName");
            IconBorder up = new IconBorder(upIcon, 3, ((JXMonthView)this.getComponent()).getBoxPaddingX());
            IconBorder down = new IconBorder(downIcon, 7, ((JXMonthView)this.getComponent()).getBoxPaddingX());
            CompoundBorder compound = BorderFactory.createCompoundBorder(up, down);
            Border empty = BorderFactory.createEmptyBorder(2 * ((JXMonthView)this.getComponent()).getBoxPaddingY(), 0, 2 * ((JXMonthView)this.getComponent()).getBoxPaddingY(), 0);
            return BorderFactory.createCompoundBorder(compound, empty);
        }
        return BorderFactory.createEmptyBorder(((JXMonthView)this.getComponent()).getBoxPaddingY(), ((JXMonthView)this.getComponent()).getBoxPaddingX(), ((JXMonthView)this.getComponent()).getBoxPaddingY(), ((JXMonthView)this.getComponent()).getBoxPaddingX());
    }

    protected boolean isToday() {
        return CalendarState.TODAY == this.dayState;
    }

    @Override
    protected String getUIPrefix() {
        return "JXMonthView.";
    }
}

