/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.epubcheck.opf;

import com.adobe.epubcheck.opf.OPFItem;
import com.google.common.base.Function;
import com.google.common.base.Optional;
import com.google.common.base.Preconditions;
import com.google.common.base.Predicates;
import com.google.common.collect.FluentIterable;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Iterables;
import com.google.common.collect.Maps;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public final class OPFItems {
    private final List<OPFItem> items;
    private final List<OPFItem> spine;
    private final Map<String, OPFItem> itemsById;
    private final Map<String, OPFItem> itemsByPath;

    public Optional<OPFItem> getItemById(String id) {
        return Optional.fromNullable((Object)this.itemsById.get(id));
    }

    public Optional<OPFItem> getItemByPath(String path) {
        return Optional.fromNullable((Object)this.itemsByPath.get(path));
    }

    public List<OPFItem> getSpineItems() {
        return this.spine;
    }

    public List<OPFItem> getItems() {
        return this.items;
    }

    private OPFItems(Iterable<OPFItem> items, Iterable<String> spineIDs) {
        this.items = ImmutableList.copyOf((Iterable)((Iterable)Preconditions.checkNotNull(items)));
        HashMap itemsById = Maps.newHashMap();
        HashMap itemsByPath = Maps.newHashMap();
        for (OPFItem item : this.items) {
            itemsById.put(item.getId(), item);
            itemsByPath.put(item.getPath(), item);
        }
        this.itemsById = ImmutableMap.copyOf((Map)itemsById);
        this.itemsByPath = ImmutableMap.copyOf((Map)itemsByPath);
        this.spine = FluentIterable.from(spineIDs).transform((Function)new Function<String, OPFItem>(){

            public OPFItem apply(String id) {
                return (OPFItem)OPFItems.this.itemsById.get(id.trim());
            }
        }).filter(Predicates.notNull()).toList();
    }

    public static OPFItems build(Iterable<OPFItem.Builder> itemBuilders, Iterable<String> spineIDs) {
        return new OPFItems(Iterables.transform((Iterable)((Iterable)Preconditions.checkNotNull(itemBuilders)), (Function)new Function<OPFItem.Builder, OPFItem>(){

            public OPFItem apply(OPFItem.Builder builder) {
                return builder.build();
            }
        }), (Iterable)Preconditions.checkNotNull(spineIDs));
    }
}

