# Contributing

Contributions are accepted via [pull requests](https://github.com/php-ds/ext/pulls). If you would like to report a bug, please create an [issue](https://github.com/php-ds/ext/issues) instead.

## Issues

- **How to reproduce** - Provide an easy way to reproduce the bug. This makes it easier for others to debug.

- **Platform details** - Specify your platform and your PHP version, eg. "PHP 7.0.2 on Ubuntu 14.04 64x".

## Pull Requests

- **Add tests** - Your patch won't be accepted if it doesn't have tests where appropriate.

- **Document any change in behaviour** - Make sure the README and any other relevant documentation updated.

- **One pull request per feature** - If you want to do more than one thing, send multiple pull requests.

- **Send coherent history** - Make sure each individual commit in your pull request is meaningful. If you had to make multiple intermediate commits while developing, please squash them before submitting.

- **Coding style** - Try to match the style of the rest of the source wherever possible. Your patch won't be accepted if the style is significantly different.
