/*
 * Decompiled with CFR 0.152.
 */
package jdk.jshell.execution;

import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.HashMap;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import jdk.jshell.spi.ExecutionControl;
import jdk.jshell.spi.ExecutionControlProvider;
import jdk.jshell.spi.ExecutionEnv;

public class FailOverExecutionControlProvider
implements ExecutionControlProvider {
    private Logger logger = null;

    @Override
    public String name() {
        return "failover";
    }

    @Override
    public Map<String, String> defaultParameters() {
        HashMap<String, String> dp = new HashMap<String, String>();
        dp.put("0", "jdi");
        for (int i = 1; i <= 9; ++i) {
            dp.put("" + i, "");
        }
        return dp;
    }

    @Override
    public ExecutionControl generate(ExecutionEnv env, Map<String, String> parameters) throws Throwable {
        Throwable thrown = null;
        for (int i = 0; i <= 9; ++i) {
            String param = parameters.get("" + i);
            if (param == null || param.isEmpty()) continue;
            try {
                ExecutionControl ec = ExecutionControl.generate(env, param);
                this.logger().finest(String.format("FailOverExecutionControlProvider: Success %s -- %d = %s\n", this.name(), i, param));
                return ec;
            }
            catch (Throwable ex) {
                this.logger().warning(String.format("FailOverExecutionControlProvider: Failure %s -- %d = %s -- %s\n", this.name(), i, param, ex.toString()));
                StringWriter writer = new StringWriter();
                PrintWriter log = new PrintWriter(writer);
                log.println("FailOverExecutionControlProvider:");
                ex.printStackTrace(log);
                log.flush();
                this.logger().fine(writer.toString());
                if (thrown != null) continue;
                thrown = ex;
            }
        }
        this.logger().severe("FailOverExecutionControlProvider: Terminating, failovers exhausted");
        if (thrown == null) {
            throw new IllegalArgumentException("All least one parameter must be set to a provider.");
        }
        throw thrown;
    }

    private Logger logger() {
        if (this.logger == null) {
            this.logger = Logger.getLogger("jdk.jshell.execution");
            this.logger.setLevel(Level.ALL);
        }
        return this.logger;
    }
}

