/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.git.ui.repository;

import org.netbeans.libs.git.GitBranch;
import org.netbeans.modules.git.ui.repository.Bundle;

public class Revision {
    private final String revision;
    private final String name;
    private final String shortMessage;
    private final String fullMessage;
    public static final Revision LOCAL = new Revision(Bundle.LBL_Revision_LOCAL_name(), Bundle.LBL_Revision_LOCAL_name()){

        @Override
        public String toString(boolean shorten) {
            return this.getRevision();
        }
    };
    public static final Revision HEAD = new Revision("HEAD", Bundle.LBL_Revision_HEAD_name()){

        @Override
        public String toString(boolean shorten) {
            return this.getRevision();
        }
    };

    public Revision(String revision, String name) {
        this(revision, name, null, null);
    }

    public Revision(String revision, String name, String shortMessage, String fullMessage) {
        this.revision = revision;
        this.name = name;
        this.shortMessage = shortMessage;
        this.fullMessage = fullMessage;
    }

    public String getCommitId() {
        return this.revision;
    }

    public String getRevision() {
        return this.name;
    }

    public String toString() {
        return this.toString(false);
    }

    public String toString(boolean shorten) {
        StringBuilder sb = new StringBuilder();
        if (this.name != null && !this.name.equals(this.revision)) {
            sb.append(this.name).append(" (").append(shorten ? this.revision.substring(0, 7) : this.revision).append(")");
        } else if (shorten && this.revision.length() > 7) {
            sb.append(this.revision.substring(0, 7));
        } else {
            sb.append(this.revision);
        }
        if (this.shortMessage != null && !this.shortMessage.isEmpty()) {
            sb.append(" - ").append(this.shortMessage);
        }
        return sb.toString();
    }

    public final boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (!(obj instanceof Revision)) {
            return false;
        }
        Revision other = (Revision)obj;
        return this.name.equals(other.name) && this.revision.equals(other.revision);
    }

    public final int hashCode() {
        int hash = 7;
        hash = 97 * hash + (this.revision != null ? this.revision.hashCode() : 0);
        hash = 97 * hash + (this.name != null ? this.name.hashCode() : 0);
        return hash;
    }

    public String getShortMessage() {
        return this.shortMessage;
    }

    public String getFullMessage() {
        return this.fullMessage;
    }

    public static final class BranchReference
    extends Revision {
        private final String branchName;
        private final String commitId;

        public BranchReference(GitBranch branch) {
            this(branch.getName(), branch.getId());
        }

        public BranchReference(String branchName, String commitId) {
            super(commitId, branchName);
            this.branchName = branchName;
            this.commitId = commitId;
        }

        @Override
        public String toString(boolean shorten) {
            if (shorten) {
                return this.branchName;
            }
            return this.branchName + " (" + this.commitId.substring(0, 7) + ")";
        }
    }
}

