/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.git;

import java.awt.Color;
import java.awt.Image;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.File;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.EnumSet;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.WeakHashMap;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.regex.Pattern;
import javax.swing.Action;
import org.netbeans.libs.git.GitBranch;
import org.netbeans.libs.git.GitRepositoryState;
import org.netbeans.libs.git.GitTag;
import org.netbeans.modules.git.Bundle;
import org.netbeans.modules.git.FileInformation;
import org.netbeans.modules.git.FileStatusCache;
import org.netbeans.modules.git.Git;
import org.netbeans.modules.git.GitModuleConfig;
import org.netbeans.modules.git.options.AnnotationColorProvider;
import org.netbeans.modules.git.ui.actions.AddAction;
import org.netbeans.modules.git.ui.actions.ContextHolder;
import org.netbeans.modules.git.ui.blame.AnnotateAction;
import org.netbeans.modules.git.ui.checkout.RevertChangesAction;
import org.netbeans.modules.git.ui.commit.CommitAction;
import org.netbeans.modules.git.ui.conflicts.ResolveConflictsAction;
import org.netbeans.modules.git.ui.history.SearchHistoryAction;
import org.netbeans.modules.git.ui.menu.BranchMenu;
import org.netbeans.modules.git.ui.menu.CheckoutMenu;
import org.netbeans.modules.git.ui.menu.DiffMenu;
import org.netbeans.modules.git.ui.menu.IgnoreMenu;
import org.netbeans.modules.git.ui.menu.PatchesMenu;
import org.netbeans.modules.git.ui.menu.RemoteMenu;
import org.netbeans.modules.git.ui.menu.RepositoryMenu;
import org.netbeans.modules.git.ui.menu.RevertMenu;
import org.netbeans.modules.git.ui.menu.ShelveMenu;
import org.netbeans.modules.git.ui.repository.OpenGlobalConfigurationAction;
import org.netbeans.modules.git.ui.repository.RepositoryBrowserAction;
import org.netbeans.modules.git.ui.repository.RepositoryInfo;
import org.netbeans.modules.git.ui.status.StatusAction;
import org.netbeans.modules.git.utils.GitUtils;
import org.netbeans.modules.versioning.spi.VCSAnnotator;
import org.netbeans.modules.versioning.spi.VCSContext;
import org.netbeans.modules.versioning.spi.VersioningSupport;
import org.netbeans.modules.versioning.util.SystemActionBridge;
import org.netbeans.modules.versioning.util.Utils;
import org.openide.filesystems.FileUtil;
import org.openide.nodes.Node;
import org.openide.util.ContextAwareAction;
import org.openide.util.ImageUtilities;
import org.openide.util.Lookup;
import org.openide.util.NbBundle;
import org.openide.util.actions.SystemAction;
import org.openide.util.lookup.Lookups;

public class Annotator
extends VCSAnnotator
implements PropertyChangeListener {
    private static final EnumSet<FileInformation.Status> STATUS_IS_IMPORTANT = EnumSet.noneOf(FileInformation.Status.class);
    private static final EnumSet<FileInformation.Status> STATUS_BADGEABLE = EnumSet.complementOf(EnumSet.of(FileInformation.Status.NOTVERSIONED_EXCLUDED, FileInformation.Status.NOTVERSIONED_NOTMANAGED, FileInformation.Status.UNKNOWN));
    private static String projectFormat;
    private static final Pattern lessThan;
    private static final String badgeModified = "org/netbeans/modules/git/resources/icons/modified-badge.png";
    private static final String badgeConflicts = "org/netbeans/modules/git/resources/icons/conflicts-badge.png";
    private static final String tooltipBranch;
    private static final String toolTipModified;
    private static final String toolTipConflict;
    private final FileStatusCache cache;
    public static final String ACTIONS_PATH_PREFIX = "Actions/Git/";
    static final String DEFAULT_ANNOTATION_PROJECT = "[{repository_state} {branch} {tracking_status}]";
    private static final String LABEL_VARIABLE_TRACKING = "tracking_status";
    private static final LabelVariables PROJECT_ANNOTATION_VARIABLES;
    private final Map<RepositoryInfo, Set<File>> filesWithRepositoryAnnotations = new WeakHashMap<RepositoryInfo, Set<File>>(3);

    public Annotator() {
        this.cache = Git.getInstance().getFileStatusCache();
    }

    public Action[] getActions(VCSContext context, VCSAnnotator.ActionDestination destination) {
        Set<File> roots = GitUtils.getRepositoryRoots(context);
        boolean noneVersioned = roots == null || roots.isEmpty();
        LinkedList<Action> actions = new LinkedList<Action>();
        if (destination.equals((Object)VCSAnnotator.ActionDestination.MainMenu)) {
            if (noneVersioned) {
                this.addAction("org-netbeans-modules-git-ui-clone-CloneAction", null, actions, true);
                this.addAction("org-netbeans-modules-git-ui-init-InitAction", null, actions, true);
                actions.add(null);
                actions.add((Action)SystemAction.get(RepositoryBrowserAction.class));
                actions.add((Action)SystemAction.get(OpenGlobalConfigurationAction.class));
            } else {
                actions.add((Action)SystemAction.get(StatusAction.class));
                actions.add(new DiffMenu(destination, null));
                actions.add((Action)SystemAction.get(AddAction.class));
                actions.add((Action)SystemAction.get(CommitAction.class));
                actions.add(new CheckoutMenu(VCSAnnotator.ActionDestination.MainMenu, null));
                actions.add((Action)SystemAction.get(RevertChangesAction.class));
                actions.add((Action)SystemAction.get(AnnotateAction.class));
                actions.add((Action)SystemAction.get(SearchHistoryAction.class));
                actions.add((Action)SystemAction.get(ResolveConflictsAction.class));
                actions.add(null);
                actions.add(new IgnoreMenu(null));
                actions.add(new PatchesMenu(VCSAnnotator.ActionDestination.MainMenu, null));
                actions.add(null);
                actions.add(new BranchMenu(VCSAnnotator.ActionDestination.MainMenu, null, null));
                actions.add(new RemoteMenu(VCSAnnotator.ActionDestination.MainMenu, null, null));
                actions.add(new RevertMenu(VCSAnnotator.ActionDestination.MainMenu, null));
                actions.add(null);
                actions.add(new RepositoryMenu(VCSAnnotator.ActionDestination.MainMenu, null));
            }
            Utils.setAcceleratorBindings((String)ACTIONS_PATH_PREFIX, (Action[])actions.toArray(new Action[actions.size()]));
        } else {
            Lookup lkp = context.getElements();
            if (noneVersioned) {
                this.addAction("org-netbeans-modules-git-ui-init-InitAction", context, actions);
            } else {
                Node[] nodes = context.getElements().lookupAll(Node.class).toArray(new Node[0]);
                actions.add((Action)SystemActionBridge.createAction((Action)SystemAction.get(StatusAction.class), (String)NbBundle.getMessage(StatusAction.class, (String)"LBL_StatusAction.popupName"), (Lookup)lkp));
                actions.add(new DiffMenu(VCSAnnotator.ActionDestination.PopupMenu, lkp));
                actions.add((Action)SystemActionBridge.createAction((Action)SystemAction.get(AddAction.class), (String)NbBundle.getMessage(AddAction.class, (String)"LBL_AddAction.popupName"), (Lookup)lkp));
                actions.add((Action)SystemActionBridge.createAction((Action)SystemAction.get(CommitAction.class), (String)NbBundle.getMessage(CommitAction.class, (String)"LBL_CommitAction.popupName"), (Lookup)lkp));
                actions.add(new CheckoutMenu(VCSAnnotator.ActionDestination.PopupMenu, lkp));
                actions.add((Action)SystemActionBridge.createAction((Action)SystemAction.get(RevertChangesAction.class), (String)NbBundle.getMessage(RevertChangesAction.class, (String)"LBL_RevertChangesAction_PopupName"), (Lookup)lkp));
                actions.add((Action)SystemActionBridge.createAction((Action)SystemAction.get(AnnotateAction.class), (String)(((AnnotateAction)SystemAction.get(AnnotateAction.class)).visible(nodes) ? NbBundle.getMessage(AnnotateAction.class, (String)"LBL_HideAnnotateAction_PopupName") : NbBundle.getMessage(AnnotateAction.class, (String)"LBL_ShowAnnotateAction_PopupName")), (Lookup)lkp));
                actions.add((Action)SystemActionBridge.createAction((Action)SystemAction.get(SearchHistoryAction.class), (String)NbBundle.getMessage(SearchHistoryAction.class, (String)"LBL_SearchHistoryAction_PopupName"), (Lookup)lkp));
                actions.add((Action)SystemActionBridge.createAction((Action)SystemAction.get(ResolveConflictsAction.class), (String)NbBundle.getMessage(ResolveConflictsAction.class, (String)"LBL_ResolveConflictsAction_PopupName"), (Lookup)lkp));
                actions.add(null);
                actions.add(new IgnoreMenu(lkp));
                actions.add(new PatchesMenu(VCSAnnotator.ActionDestination.PopupMenu, lkp));
                actions.add(null);
                actions.add(new BranchMenu(VCSAnnotator.ActionDestination.PopupMenu, lkp, context));
                actions.add(new RemoteMenu(VCSAnnotator.ActionDestination.PopupMenu, lkp, context));
                actions.add(new RevertMenu(VCSAnnotator.ActionDestination.PopupMenu, lkp));
                actions.add(null);
                actions.add(new RepositoryMenu(VCSAnnotator.ActionDestination.PopupMenu, lkp));
                actions.add(null);
                actions.add(new ShelveMenu(VCSAnnotator.ActionDestination.PopupMenu, lkp, context));
            }
        }
        return actions.toArray(new Action[actions.size()]);
    }

    public void refreshFormat() {
        projectFormat = null;
        Git.getInstance().refreshAllAnnotations();
    }

    public LabelVariable[] getProjectVariables() {
        return PROJECT_ANNOTATION_VARIABLES.toArray(new LabelVariable[PROJECT_ANNOTATION_VARIABLES.size()]);
    }

    private void addAction(String name, VCSContext context, List<Action> actions) {
        this.addAction(name, context, actions, false);
    }

    private void addAction(String name, VCSContext context, List<Action> actions, boolean accelerate) {
        Action action = accelerate ? Utils.getAcceleratedAction((String)(ACTIONS_PATH_PREFIX + name + ".instance")) : (Action)FileUtil.getConfigObject((String)(ACTIONS_PATH_PREFIX + name + ".instance"), Action.class);
        if (action instanceof ContextAwareAction) {
            action = ((ContextAwareAction)action).createContextAwareInstance(Lookups.singleton((Object)new ContextHolder(context)));
        }
        if (action != null) {
            actions.add(action);
        }
    }

    public Image annotateIcon(Image icon, VCSContext context) {
        boolean folderAnnotation = false;
        for (File file : context.getRootFiles()) {
            if (!file.isDirectory()) continue;
            folderAnnotation = true;
            Utils.addFolderToLog((File)file);
            break;
        }
        if (!folderAnnotation && context.getRootFiles().size() > 1) {
            boolean bl = folderAnnotation = !Utils.isFromMultiFileDataObject((VCSContext)context);
        }
        if (!folderAnnotation) {
            return this.annotateFileIcon(context, icon);
        }
        return this.annotateFolderIcon(context, icon);
    }

    public String annotateName(String name, VCSContext context) {
        FileInformation mostImportantInfo = null;
        File mostImportantFile = null;
        boolean folderAnnotation = false;
        for (File file : context.getRootFiles()) {
            FileInformation info = this.cache.getStatus(file);
            if (!info.containsStatus(STATUS_IS_IMPORTANT) || !Annotator.isMoreImportant(info, mostImportantInfo)) continue;
            mostImportantInfo = info;
            mostImportantFile = file;
            folderAnnotation = info.isDirectory();
        }
        if (!folderAnnotation && context.getRootFiles().size() > 1) {
            boolean bl = folderAnnotation = !Utils.isFromMultiFileDataObject((VCSContext)context);
        }
        if (mostImportantInfo == null) {
            return null;
        }
        return folderAnnotation ? this.annotateFolderNameHtml(name, context, mostImportantInfo, mostImportantFile) : this.annotateNameHtml(name, mostImportantInfo, mostImportantFile);
    }

    private static boolean isMoreImportant(FileInformation a, FileInformation b) {
        if (b == null) {
            return true;
        }
        if (a == null) {
            return false;
        }
        return a.getComparableStatus() < b.getComparableStatus();
    }

    private Image annotateFileIcon(VCSContext context, Image icon) throws IllegalArgumentException {
        FileInformation mostImportantInfo = null;
        for (File file : context.getRootFiles()) {
            FileInformation info = this.cache.getStatus(file);
            if (!info.containsStatus(STATUS_IS_IMPORTANT) || !Annotator.isMoreImportant(info, mostImportantInfo)) continue;
            mostImportantInfo = info;
        }
        if (mostImportantInfo == null) {
            return null;
        }
        String tooltip = null;
        String statusText = mostImportantInfo.getStatusText(FileInformation.Mode.HEAD_VS_WORKING_TREE);
        if (mostImportantInfo.containsStatus(FileInformation.Status.NOTVERSIONED_EXCLUDED)) {
            tooltip = this.getAnnotationProvider().EXCLUDED_FILE_TOOLTIP.getFormat().format(new Object[]{statusText});
        } else if (mostImportantInfo.getStatus().equals(EnumSet.of(FileInformation.Status.NEW_HEAD_INDEX, FileInformation.Status.REMOVED_INDEX_WORKING_TREE))) {
            tooltip = this.getAnnotationProvider().UP_TO_DATE_FILE_TOOLTIP.getFormat().format(new Object[]{statusText});
        } else if (mostImportantInfo.getStatus().equals(EnumSet.of(FileInformation.Status.MODIFIED_HEAD_INDEX, FileInformation.Status.MODIFIED_INDEX_WORKING_TREE))) {
            tooltip = this.getAnnotationProvider().UP_TO_DATE_FILE_TOOLTIP.getFormat().format(new Object[]{statusText});
        } else if (mostImportantInfo.containsStatus(FileInformation.Status.REMOVED_HEAD_WORKING_TREE)) {
            tooltip = this.getAnnotationProvider().REMOVED_FILE_TOOLTIP.getFormat().format(new Object[]{statusText});
        } else if (mostImportantInfo.getStatus().equals(EnumSet.of(FileInformation.Status.NEW_INDEX_WORKING_TREE, FileInformation.Status.REMOVED_HEAD_INDEX))) {
            tooltip = this.getAnnotationProvider().UP_TO_DATE_FILE_TOOLTIP.getFormat().format(new Object[]{statusText});
        } else if (mostImportantInfo.getStatus().equals(EnumSet.of(FileInformation.Status.NEW_INDEX_WORKING_TREE, FileInformation.Status.REMOVED_HEAD_INDEX, FileInformation.Status.MODIFIED_HEAD_WORKING_TREE))) {
            tooltip = this.getAnnotationProvider().MODIFIED_FILE_TOOLTIP.getFormat().format(new Object[]{statusText});
        } else if (mostImportantInfo.containsStatus(FileInformation.Status.NEW_INDEX_WORKING_TREE)) {
            tooltip = this.getAnnotationProvider().NEW_FILE_TOOLTIP.getFormat().format(new Object[]{statusText});
        } else if (mostImportantInfo.containsStatus(FileInformation.Status.NEW_HEAD_INDEX)) {
            tooltip = this.getAnnotationProvider().ADDED_FILE_TOOLTIP.getFormat().format(new Object[]{statusText});
        } else if (mostImportantInfo.containsStatus(FileInformation.Status.MODIFIED_HEAD_WORKING_TREE)) {
            tooltip = this.getAnnotationProvider().MODIFIED_FILE_TOOLTIP.getFormat().format(new Object[]{statusText});
        } else if (mostImportantInfo.containsStatus(FileInformation.Status.UPTODATE)) {
            tooltip = null;
        } else if (mostImportantInfo.containsStatus(FileInformation.Status.IN_CONFLICT)) {
            tooltip = this.getAnnotationProvider().CONFLICT_FILE_TOOLTIP.getFormat().format(new Object[]{statusText});
        } else if (mostImportantInfo.containsStatus(FileInformation.Status.NOTVERSIONED_NOTMANAGED)) {
            tooltip = null;
        } else if (mostImportantInfo.containsStatus(FileInformation.Status.UNKNOWN)) {
            tooltip = null;
        } else {
            throw new IllegalStateException("Unknown status: " + mostImportantInfo.getStatus());
        }
        return tooltip != null ? ImageUtilities.addToolTipToImage((Image)icon, (String)tooltip) : null;
    }

    private Image annotateFolderIcon(VCSContext context, Image icon) {
        File repository;
        File root = null;
        for (File file : context.getRootFiles()) {
            FileInformation info = this.cache.getStatus(file);
            if (!info.containsStatus(STATUS_BADGEABLE)) continue;
            root = file;
            break;
        }
        if (root == null) {
            return null;
        }
        String branchLabel = null;
        Set roots = context.getRootFiles();
        Set<File> repositories = GitUtils.getRepositoryRoots(roots);
        File file = repository = repositories.isEmpty() ? null : repositories.iterator().next();
        if (repository != null && (roots.size() > 1 || root.equals(repository))) {
            RepositoryInfo info = RepositoryInfo.getInstance(repository);
            this.addFileWithRepositoryAnnotation(info, root);
            GitBranch branch = info.getActiveBranch();
            if (branch != null) {
                RepositoryInfo.TrackingInfo tracking;
                String branchName = branch.getName();
                branchLabel = tooltipBranch;
                branchLabel = branchName == "(no branch)" ? branchLabel + Bundle.MSG_Annotator_tooltip_nobranch() : ((tracking = info.getTracking()).isKnown() ? branchLabel + Bundle.MSG_Annotator_tooltip_branch_withTracking(branchName, tracking.getDescription()) : branchLabel + Bundle.MSG_Annotator_tooltip_branch(branchName));
            }
        }
        Image retval = icon;
        if (branchLabel != null) {
            retval = ImageUtilities.addToolTipToImage((Image)retval, branchLabel);
        }
        Image badge = null;
        if (this.cache.containsFiles(context, EnumSet.of(FileInformation.Status.IN_CONFLICT), false)) {
            badge = ImageUtilities.assignToolTipToImage((Image)ImageUtilities.loadImage((String)badgeConflicts, (boolean)true), (String)toolTipConflict);
        } else if (this.cache.containsFiles(context, FileInformation.STATUS_LOCAL_CHANGES, false)) {
            badge = ImageUtilities.assignToolTipToImage((Image)ImageUtilities.loadImage((String)badgeModified, (boolean)true), (String)toolTipModified);
        }
        if (badge != null) {
            retval = ImageUtilities.mergeImages((Image)retval, (Image)badge, (int)16, (int)9);
        }
        return retval;
    }

    private String annotateFolderNameHtml(String name, VCSContext context, FileInformation mostImportantInfo, File mostImportantFile) {
        boolean annotationsVisible = VersioningSupport.getPreferences().getBoolean("textAnnotationsVisible", false);
        String nameHtml = Annotator.htmlEncode(name);
        File repository = Git.getInstance().getRepositoryRoot(mostImportantFile);
        if (!mostImportantFile.equals(repository) && mostImportantInfo.containsStatus(FileInformation.Status.NOTVERSIONED_EXCLUDED)) {
            return this.getAnnotationProvider().EXCLUDED_FILE.getFormat().format(new Object[]{nameHtml, ""});
        }
        String folderAnnotation = "";
        Set roots = context.getRootFiles();
        if (repository == null) {
            Git.STATUS_LOG.log(Level.WARNING, "annotateFolderNameHtml: null repository for {0} having status {1}", new Object[]{mostImportantFile, mostImportantInfo});
        } else if (annotationsVisible && (roots.size() > 1 || mostImportantFile.equals(repository))) {
            String repositoryStateStr;
            String branchLabel = "";
            RepositoryInfo info = RepositoryInfo.getInstance(repository);
            this.addFileWithRepositoryAnnotation(info, mostImportantFile);
            GitBranch branch = info.getActiveBranch();
            if (branch != null && (branchLabel = branch.getName()) == "(no branch)") {
                Map<String, GitTag> tags = info.getTags();
                StringBuilder tagLabel = new StringBuilder();
                for (GitTag tag : tags.values()) {
                    if (!tag.getTaggedObjectId().equals(branch.getId())) continue;
                    tagLabel.append(",").append(tag.getTagName());
                }
                if (tagLabel.length() <= 1) {
                    branchLabel = branch.getId();
                    if (branchLabel.length() > 7) {
                        branchLabel = branchLabel.substring(0, 7) + "...";
                    }
                } else {
                    tagLabel.delete(0, 1);
                    branchLabel = tagLabel.toString();
                }
            }
            GitRepositoryState repositoryState = info.getRepositoryState();
            String format = Annotator.getAnnotationProjectFormat();
            String trackingStatus = "";
            if (this.hasAnnotationFor(LABEL_VARIABLE_TRACKING)) {
                RepositoryInfo.TrackingInfo tracking = info.getTracking();
                int in = tracking.getIncomingCommits();
                int out = tracking.getOutgoingCommits();
                StringBuilder sb = new StringBuilder();
                if (out > 0) {
                    sb.append('\u2191').append(out);
                }
                if (in > 0) {
                    if (sb.length() > 0) {
                        sb.append(' ');
                    }
                    sb.append('\u2193').append(in);
                }
                trackingStatus = sb.toString();
            }
            String string = repositoryStateStr = repositoryState == GitRepositoryState.SAFE ? "" : repositoryState.toString();
            if (repositoryStateStr.isEmpty()) {
                format = format.replaceAll("\\{0\\} | \\{0\\}", "\\{0\\}");
            }
            if (branchLabel.isEmpty()) {
                format = format.replaceAll("\\{1\\} | \\{1\\}", "\\{1\\}");
            }
            if (trackingStatus.isEmpty()) {
                format = format.replaceAll("\\{2\\} | \\{2\\}", "\\{2\\}");
            }
            folderAnnotation = MessageFormat.format(format, repositoryStateStr, branchLabel, trackingStatus);
        }
        MessageFormat uptodateFormat = this.getAnnotationProvider().UP_TO_DATE_FILE.getFormat();
        return uptodateFormat.format(new Object[]{nameHtml, folderAnnotation.isEmpty() ? "" : this.getAnnotationProvider().TEXT_ANNOTATION.getFormat().format(new Object[]{" " + folderAnnotation + ""})});
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void addFileWithRepositoryAnnotation(RepositoryInfo info, File file) {
        info.removePropertyChangeListener(this);
        Map<RepositoryInfo, Set<File>> map = this.filesWithRepositoryAnnotations;
        synchronized (map) {
            Set<File> files = this.filesWithRepositoryAnnotations.get(info);
            if (files == null) {
                files = new HashSet<File>();
                this.filesWithRepositoryAnnotations.put(info, files);
            }
            files.add(file);
        }
        info.addPropertyChangeListener(this);
    }

    @Override
    public void propertyChange(final PropertyChangeEvent evt) {
        if (evt.getPropertyName() == "prop.activeBranch" || evt.getPropertyName() == "prop.state" || evt.getPropertyName() == "prop.head" && ((GitBranch)evt.getNewValue()).getName() == "(no branch)" || evt.getPropertyName() == "prop.trackingInfo" && this.hasAnnotationFor(LABEL_VARIABLE_TRACKING)) {
            Utils.post((Runnable)new Runnable(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void run() {
                    Set filesToRefresh;
                    RepositoryInfo info = (RepositoryInfo)evt.getSource();
                    Map map = Annotator.this.filesWithRepositoryAnnotations;
                    synchronized (map) {
                        filesToRefresh = (Set)Annotator.this.filesWithRepositoryAnnotations.remove(info);
                    }
                    if (filesToRefresh != null && !filesToRefresh.isEmpty()) {
                        Git.getInstance().headChanged(filesToRefresh);
                    }
                }
            }, (int)400);
        }
    }

    public String annotateNameHtml(String name, FileInformation mostImportantInfo, File mostImportantFile) {
        String textAnnotation;
        name = Annotator.htmlEncode(name);
        boolean annotationsVisible = VersioningSupport.getPreferences().getBoolean("textAnnotationsVisible", false);
        if (annotationsVisible && mostImportantFile != null && mostImportantInfo.containsStatus(STATUS_IS_IMPORTANT)) {
            String statusText = mostImportantInfo.getShortStatusText();
            if (!statusText.isEmpty()) {
                textAnnotation = " [" + mostImportantInfo.getShortStatusText() + "]";
                textAnnotation = this.getAnnotationProvider().TEXT_ANNOTATION.getFormat().format(new Object[]{textAnnotation});
            } else {
                textAnnotation = "";
            }
        } else {
            textAnnotation = "";
        }
        if (mostImportantInfo.containsStatus(FileInformation.Status.NOTVERSIONED_EXCLUDED)) {
            return this.getAnnotationProvider().EXCLUDED_FILE.getFormat().format(new Object[]{name, textAnnotation});
        }
        if (mostImportantInfo.getStatus().equals(EnumSet.of(FileInformation.Status.NEW_HEAD_INDEX, FileInformation.Status.REMOVED_INDEX_WORKING_TREE))) {
            return this.getAnnotationProvider().UP_TO_DATE_FILE.getFormat().format(new Object[]{name, textAnnotation});
        }
        if (mostImportantInfo.getStatus().equals(EnumSet.of(FileInformation.Status.MODIFIED_HEAD_INDEX, FileInformation.Status.MODIFIED_INDEX_WORKING_TREE))) {
            return this.getAnnotationProvider().UP_TO_DATE_FILE.getFormat().format(new Object[]{name, textAnnotation});
        }
        if (mostImportantInfo.containsStatus(FileInformation.Status.REMOVED_HEAD_WORKING_TREE)) {
            return this.getAnnotationProvider().REMOVED_FILE.getFormat().format(new Object[]{name, textAnnotation});
        }
        if (mostImportantInfo.getStatus().equals(EnumSet.of(FileInformation.Status.NEW_INDEX_WORKING_TREE, FileInformation.Status.REMOVED_HEAD_INDEX))) {
            return this.getAnnotationProvider().UP_TO_DATE_FILE.getFormat().format(new Object[]{name, textAnnotation});
        }
        if (mostImportantInfo.getStatus().equals(EnumSet.of(FileInformation.Status.NEW_INDEX_WORKING_TREE, FileInformation.Status.REMOVED_HEAD_INDEX, FileInformation.Status.MODIFIED_HEAD_WORKING_TREE))) {
            return this.getAnnotationProvider().MODIFIED_FILE.getFormat().format(new Object[]{name, textAnnotation});
        }
        if (mostImportantInfo.containsStatus(FileInformation.Status.NEW_INDEX_WORKING_TREE)) {
            return this.getAnnotationProvider().NEW_FILE.getFormat().format(new Object[]{name, textAnnotation});
        }
        if (mostImportantInfo.containsStatus(FileInformation.Status.NEW_HEAD_INDEX)) {
            return this.getAnnotationProvider().ADDED_FILE.getFormat().format(new Object[]{name, textAnnotation});
        }
        if (mostImportantInfo.containsStatus(FileInformation.Status.MODIFIED_HEAD_WORKING_TREE)) {
            return this.getAnnotationProvider().MODIFIED_FILE.getFormat().format(new Object[]{name, textAnnotation});
        }
        if (mostImportantInfo.containsStatus(FileInformation.Status.UPTODATE)) {
            return this.getAnnotationProvider().UP_TO_DATE_FILE.getFormat().format(new Object[]{name, textAnnotation});
        }
        if (mostImportantInfo.containsStatus(FileInformation.Status.IN_CONFLICT)) {
            return this.getAnnotationProvider().CONFLICT_FILE.getFormat().format(new Object[]{name, textAnnotation});
        }
        if (mostImportantInfo.containsStatus(FileInformation.Status.NOTVERSIONED_NOTMANAGED)) {
            return name;
        }
        if (mostImportantInfo.containsStatus(FileInformation.Status.UNKNOWN)) {
            return name;
        }
        throw new IllegalStateException("Unknown status: " + mostImportantInfo.getStatus());
    }

    public Color getAnnotatedColor(FileInformation info) {
        if (info.containsStatus(FileInformation.Status.NOTVERSIONED_EXCLUDED)) {
            return this.getAnnotationProvider().EXCLUDED_FILE.getActualColor();
        }
        if (info.getStatus().equals(EnumSet.of(FileInformation.Status.NEW_HEAD_INDEX, FileInformation.Status.REMOVED_INDEX_WORKING_TREE))) {
            return this.getAnnotationProvider().UP_TO_DATE_FILE.getActualColor();
        }
        if (info.getStatus().equals(EnumSet.of(FileInformation.Status.MODIFIED_HEAD_INDEX, FileInformation.Status.MODIFIED_INDEX_WORKING_TREE))) {
            return this.getAnnotationProvider().UP_TO_DATE_FILE.getActualColor();
        }
        if (info.containsStatus(FileInformation.Status.REMOVED_HEAD_WORKING_TREE)) {
            return this.getAnnotationProvider().REMOVED_FILE.getActualColor();
        }
        if (info.getStatus().equals(EnumSet.of(FileInformation.Status.NEW_INDEX_WORKING_TREE, FileInformation.Status.REMOVED_HEAD_INDEX))) {
            return this.getAnnotationProvider().UP_TO_DATE_FILE.getActualColor();
        }
        if (info.getStatus().equals(EnumSet.of(FileInformation.Status.NEW_INDEX_WORKING_TREE, FileInformation.Status.REMOVED_HEAD_INDEX, FileInformation.Status.MODIFIED_HEAD_WORKING_TREE))) {
            return this.getAnnotationProvider().MODIFIED_FILE.getActualColor();
        }
        if (info.containsStatus(FileInformation.Status.NEW_INDEX_WORKING_TREE)) {
            return this.getAnnotationProvider().NEW_FILE.getActualColor();
        }
        if (info.containsStatus(FileInformation.Status.NEW_HEAD_INDEX)) {
            return this.getAnnotationProvider().ADDED_FILE.getActualColor();
        }
        if (info.containsStatus(FileInformation.Status.MODIFIED_HEAD_WORKING_TREE)) {
            return this.getAnnotationProvider().MODIFIED_FILE.getActualColor();
        }
        if (info.containsStatus(FileInformation.Status.UPTODATE)) {
            return this.getAnnotationProvider().UP_TO_DATE_FILE.getActualColor();
        }
        if (info.containsStatus(FileInformation.Status.IN_CONFLICT)) {
            return this.getAnnotationProvider().CONFLICT_FILE.getActualColor();
        }
        return null;
    }

    private static String htmlEncode(String name) {
        if (name.indexOf(60) == -1) {
            return name;
        }
        return lessThan.matcher(name).replaceAll("&lt;");
    }

    private AnnotationColorProvider getAnnotationProvider() {
        return AnnotationColorProvider.getInstance();
    }

    private static String getAnnotationProjectFormat() {
        if (projectFormat == null) {
            String format = GitModuleConfig.getDefault().getProjectAnnotationFormat();
            format = Utils.skipUnsupportedVariables((String)format, (String[])PROJECT_ANNOTATION_VARIABLES.toPatterns());
            try {
                int i = 0;
                for (LabelVariable var : PROJECT_ANNOTATION_VARIABLES) {
                    format = format.replaceAll("\\{" + var.getVariable() + "\\}", "\\{" + i++ + "\\}");
                }
                MessageFormat f = new MessageFormat(format);
                projectFormat = format;
            }
            catch (IllegalArgumentException ex) {
                Logger.getLogger(Annotator.class.getName()).log(Level.INFO, "Invalid annotation format: {0}", GitModuleConfig.getDefault().getProjectAnnotationFormat());
                format = DEFAULT_ANNOTATION_PROJECT;
                int i = 0;
                for (LabelVariable var : PROJECT_ANNOTATION_VARIABLES) {
                    format = format.replaceAll("\\{" + var.getVariable() + "\\}", "\\{" + i++ + "\\}");
                }
                projectFormat = format;
            }
        }
        return projectFormat;
    }

    private boolean hasAnnotationFor(String variable) {
        return DEFAULT_ANNOTATION_PROJECT.equals(Annotator.getAnnotationProjectFormat()) || GitModuleConfig.getDefault().getProjectAnnotationFormat().contains(variable);
    }

    static {
        STATUS_IS_IMPORTANT.addAll(FileInformation.STATUS_LOCAL_CHANGES);
        STATUS_IS_IMPORTANT.addAll(EnumSet.of(FileInformation.Status.UPTODATE, FileInformation.Status.NOTVERSIONED_EXCLUDED));
        lessThan = Pattern.compile("<");
        tooltipBranch = "<img src=\"" + Annotator.class.getClassLoader().getResource("org/netbeans/modules/git/resources/icons/branch-badge.png") + "\">&nbsp;";
        toolTipModified = "<img src=\"" + Annotator.class.getClassLoader().getResource(badgeModified) + "\">&nbsp;" + NbBundle.getMessage(Annotator.class, (String)"MSG_Contains_Modified");
        toolTipConflict = "<img src=\"" + Annotator.class.getClassLoader().getResource(badgeConflicts) + "\">&nbsp;" + NbBundle.getMessage(Annotator.class, (String)"MSG_Contains_Conflicts");
        PROJECT_ANNOTATION_VARIABLES = new LabelVariables(new LabelVariable("repository_state", "{repository_state}", Bundle.Annotator_variable_repositoryState()), new LabelVariable("branch", "{branch}", Bundle.Annotator_variable_branch()), new LabelVariable(LABEL_VARIABLE_TRACKING, "{tracking_status}", Bundle.Annotator_variable_trackingStatus()));
    }

    private static class LabelVariables
    extends LinkedHashSet<LabelVariable> {
        public LabelVariables(LabelVariable ... initVars) {
            for (LabelVariable var : initVars) {
                this.add(var);
            }
        }

        String[] toPatterns() {
            ArrayList<String> patterns = new ArrayList<String>(this.size());
            for (LabelVariable var : this) {
                patterns.add(var.getPattern());
            }
            return patterns.toArray(new String[patterns.size()]);
        }
    }

    public static class LabelVariable {
        private final String variable;
        private final String pattern;
        private final String description;

        public LabelVariable(String variable, String pattern, String description) {
            this.variable = variable;
            this.pattern = pattern;
            this.description = description;
        }

        public String getDescription() {
            return this.description;
        }

        public String getPattern() {
            return this.pattern;
        }

        public String getVariable() {
            return this.variable;
        }

        public String toString() {
            return this.getPattern();
        }
    }
}

