/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.cpplite.debugger.breakpoints;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.IdentityHashMap;
import java.util.Map;
import java.util.Set;
import org.netbeans.api.debugger.Breakpoint;
import org.netbeans.api.debugger.DebuggerManager;
import org.netbeans.api.debugger.DebuggerManagerAdapter;
import org.netbeans.api.debugger.DebuggerManagerListener;
import org.netbeans.modules.cpplite.debugger.DebuggerBreakpointAnnotation;
import org.netbeans.modules.cpplite.debugger.breakpoints.CPPLiteBreakpoint;
import org.openide.filesystems.FileObject;
import org.openide.loaders.DataObject;
import org.openide.text.Annotation;
import org.openide.text.AnnotationProvider;
import org.openide.text.Line;
import org.openide.util.Lookup;
import org.openide.util.RequestProcessor;
import org.openide.util.WeakListeners;
import org.openide.util.WeakSet;

public class BreakpointAnnotationProvider
extends DebuggerManagerAdapter
implements AnnotationProvider {
    private final Map<CPPLiteBreakpoint, Set<Annotation>> breakpointToAnnotations = new IdentityHashMap<CPPLiteBreakpoint, Set<Annotation>>();
    private final Set<FileObject> annotatedFiles = new WeakSet();
    private Set<PropertyChangeListener> dataObjectListeners;
    private volatile boolean breakpointsActive = true;
    private final RequestProcessor annotationProcessor = new RequestProcessor("CPP BP Annotation Refresh", 1);

    public BreakpointAnnotationProvider() {
        DebuggerManager.getDebuggerManager().addDebuggerListener("breakpoints", (DebuggerManagerListener)this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void annotate(Line.Set set, Lookup lookup) {
        FileObject fo = (FileObject)lookup.lookup(FileObject.class);
        if (fo != null) {
            DataObject dobj = (DataObject)lookup.lookup(DataObject.class);
            if (dobj != null) {
                PropertyChangeListener pchl = new PropertyChangeListener(){

                    @Override
                    public void propertyChange(PropertyChangeEvent evt) {
                        if ("primaryFile".equals(evt.getPropertyName())) {
                            DataObject dobj = (DataObject)evt.getSource();
                            final FileObject newFO = dobj.getPrimaryFile();
                            BreakpointAnnotationProvider.this.annotationProcessor.post(new Runnable(){

                                @Override
                                public void run() {
                                    BreakpointAnnotationProvider.this.annotate(newFO);
                                }
                            });
                        }
                    }
                };
                dobj.addPropertyChangeListener(WeakListeners.propertyChange((PropertyChangeListener)pchl, (Object)dobj));
                BreakpointAnnotationProvider breakpointAnnotationProvider = this;
                synchronized (breakpointAnnotationProvider) {
                    if (this.dataObjectListeners == null) {
                        this.dataObjectListeners = new HashSet<PropertyChangeListener>();
                    }
                    this.dataObjectListeners.add(pchl);
                }
            }
            this.annotate(fo);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void annotate(FileObject fo) {
        Map<CPPLiteBreakpoint, Set<Annotation>> map = this.breakpointToAnnotations;
        synchronized (map) {
            for (Breakpoint breakpoint : DebuggerManager.getDebuggerManager().getBreakpoints()) {
                CPPLiteBreakpoint b;
                if (!(breakpoint instanceof CPPLiteBreakpoint) || (b = (CPPLiteBreakpoint)breakpoint).isHidden() || !BreakpointAnnotationProvider.isAt(b, fo)) continue;
                if (!this.breakpointToAnnotations.containsKey((Object)b)) {
                    b.addPropertyChangeListener((PropertyChangeListener)((Object)this));
                }
                this.removeAnnotations(b);
                this.addAnnotationTo(b);
            }
            this.annotatedFiles.add(fo);
        }
    }

    private static boolean isAt(CPPLiteBreakpoint b, FileObject fo) {
        FileObject bfo = b.getFileObject();
        return fo.equals(bfo);
    }

    public void breakpointAdded(Breakpoint breakpoint) {
        if (breakpoint instanceof CPPLiteBreakpoint && !((CPPLiteBreakpoint)breakpoint).isHidden()) {
            this.postAnnotationRefresh((CPPLiteBreakpoint)breakpoint, false, true);
            breakpoint.addPropertyChangeListener((PropertyChangeListener)((Object)this));
        }
    }

    public void breakpointRemoved(Breakpoint breakpoint) {
        if (breakpoint instanceof CPPLiteBreakpoint && !((CPPLiteBreakpoint)breakpoint).isHidden()) {
            breakpoint.removePropertyChangeListener((PropertyChangeListener)((Object)this));
            this.postAnnotationRefresh((CPPLiteBreakpoint)breakpoint, true, false);
        }
    }

    public void propertyChange(PropertyChangeEvent evt) {
        Object source = evt.getSource();
        if (source instanceof CPPLiteBreakpoint) {
            String propertyName;
            switch (propertyName = evt.getPropertyName()) {
                case "enabled": 
                case "validity": 
                case "condition": {
                    this.postAnnotationRefresh((CPPLiteBreakpoint)((Object)source), true, true);
                }
            }
        }
    }

    void setBreakpointsActive(boolean active) {
        if (this.breakpointsActive == active) {
            return;
        }
        this.breakpointsActive = active;
        this.annotationProcessor.post((Runnable)new AnnotationRefresh(null, true, true));
    }

    private void postAnnotationRefresh(CPPLiteBreakpoint b, boolean remove, boolean add) {
        this.annotationProcessor.post((Runnable)new AnnotationRefresh(b, remove, add));
    }

    private static String getAnnotationType(CPPLiteBreakpoint b, boolean isConditional, boolean active) {
        String annotationType;
        boolean isInvalid;
        boolean bl = isInvalid = b.getValidity() == Breakpoint.VALIDITY.INVALID;
        String string = b.isEnabled() ? (isConditional ? "CondBreakpoint" : "Breakpoint") : (annotationType = isConditional ? "DisabledCondBreakpoint" : "DisabledBreakpoint");
        if (!active) {
            annotationType = annotationType + "_stroke";
        } else if (isInvalid && b.isEnabled()) {
            annotationType = annotationType + "_broken";
        }
        return annotationType;
    }

    private void addAnnotationTo(CPPLiteBreakpoint b) {
        assert (Thread.holdsLock(this.breakpointToAnnotations));
        String condition = BreakpointAnnotationProvider.getCondition(b);
        boolean isConditional = condition.trim().length() > 0 || b.getHitCountFilteringStyle() != null;
        String annotationType = BreakpointAnnotationProvider.getAnnotationType(b, isConditional, this.breakpointsActive);
        DebuggerBreakpointAnnotation annotation = DebuggerBreakpointAnnotation.create(annotationType, b);
        if (annotation == null) {
            return;
        }
        Set<Annotation> bpAnnotations = this.breakpointToAnnotations.get((Object)b);
        if (bpAnnotations == null) {
            WeakSet set = new WeakSet();
            set.add(annotation);
            this.breakpointToAnnotations.put(b, (Set<Annotation>)set);
        } else {
            bpAnnotations.add((Annotation)annotation);
            this.breakpointToAnnotations.put(b, bpAnnotations);
        }
    }

    private void removeAnnotations(CPPLiteBreakpoint b) {
        assert (Thread.holdsLock(this.breakpointToAnnotations));
        Set<Annotation> annotations = this.breakpointToAnnotations.remove((Object)b);
        if (annotations == null) {
            return;
        }
        for (Annotation a : annotations) {
            a.detach();
        }
    }

    static String getCondition(Breakpoint b) {
        if (b instanceof CPPLiteBreakpoint) {
            return "";
        }
        throw new IllegalStateException(b.toString());
    }

    private final class AnnotationRefresh
    implements Runnable {
        private final CPPLiteBreakpoint b;
        private final boolean remove;
        private final boolean add;

        public AnnotationRefresh(CPPLiteBreakpoint b, boolean remove, boolean add) {
            this.b = b;
            this.remove = remove;
            this.add = add;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            Map map = BreakpointAnnotationProvider.this.breakpointToAnnotations;
            synchronized (map) {
                if (this.b != null) {
                    this.refreshAnnotation(this.b);
                } else {
                    ArrayList bpts = new ArrayList(BreakpointAnnotationProvider.this.breakpointToAnnotations.keySet());
                    for (CPPLiteBreakpoint bp : bpts) {
                        this.refreshAnnotation(bp);
                    }
                }
            }
        }

        private void refreshAnnotation(CPPLiteBreakpoint b) {
            assert (Thread.holdsLock(BreakpointAnnotationProvider.this.breakpointToAnnotations));
            BreakpointAnnotationProvider.this.removeAnnotations(b);
            if (this.remove && !this.add) {
                BreakpointAnnotationProvider.this.breakpointToAnnotations.remove((Object)b);
            }
            if (this.add) {
                BreakpointAnnotationProvider.this.breakpointToAnnotations.put(b, new WeakSet());
                for (FileObject fo : BreakpointAnnotationProvider.this.annotatedFiles) {
                    if (!BreakpointAnnotationProvider.isAt(b, fo)) continue;
                    BreakpointAnnotationProvider.this.addAnnotationTo(b);
                }
            }
        }
    }
}

