/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.docker.ui.pull;

import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.atomic.AtomicReference;
import javax.swing.DefaultListModel;
import javax.swing.GroupLayout;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import javax.swing.LayoutStyle;
import javax.swing.ListCellRenderer;
import javax.swing.SwingUtilities;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import org.netbeans.modules.docker.api.DockerAction;
import org.netbeans.modules.docker.api.DockerInstance;
import org.netbeans.modules.docker.api.DockerRegistryImage;
import org.netbeans.modules.docker.ui.pull.DockerHubImageItem;
import org.openide.awt.HtmlRenderer;
import org.openide.awt.Mnemonics;
import org.openide.util.NbBundle;
import org.openide.util.RequestProcessor;

public class DockerHubSearchPanel
extends JPanel {
    private static final int SEARCH_DELAY = 1000;
    private final DockerInstance instance;
    private final JButton pullButton;
    private final AtomicReference<String> searchTerm = new AtomicReference();
    private final RequestProcessor.Task searchTask = RequestProcessor.getDefault().create(new Runnable(){

        @Override
        public void run() {
            DockerHubSearchPanel.this.search((String)DockerHubSearchPanel.this.searchTerm.get());
        }
    });
    private JList<DockerHubImageItem> imageList;
    private JLabel imageListLabel;
    private JScrollPane imageListScrollPane;
    private JLabel messageLabel;
    private JPanel messagePanel;
    private JLabel resultLabel;
    private JTextField resultTextField;
    private JTextField searchTextField;
    private JLabel searchTextLabel;

    public DockerHubSearchPanel(DockerInstance instance, JButton pullButton) {
        this.instance = instance;
        this.pullButton = pullButton;
        this.initComponents();
        this.pullButton.setEnabled(false);
        this.imageListScrollPane.setViewportView(null);
        HtmlRenderer.Renderer renderer = HtmlRenderer.createRenderer();
        renderer.setHtml(true);
        this.imageList.setCellRenderer((ListCellRenderer<DockerHubImageItem>)renderer);
        this.imageList.addListSelectionListener(new SelectionListener());
        this.searchTextField.getDocument().addDocumentListener(new SearchListener());
    }

    private void search(final String searchTerm) {
        assert (!SwingUtilities.isEventDispatchThread());
        assert (searchTerm != null && !searchTerm.isEmpty());
        DockerAction facade = new DockerAction(this.instance);
        List images = facade.search(searchTerm);
        final ArrayList<DockerHubImageItem> fresh = new ArrayList<DockerHubImageItem>(images.size());
        for (DockerRegistryImage info : images) {
            fresh.add(new DockerHubImageItem(info));
        }
        Collections.sort(fresh);
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                if (!searchTerm.equals(DockerHubSearchPanel.this.searchTerm.get())) {
                    return;
                }
                DefaultListModel<DockerHubImageItem> model = new DefaultListModel<DockerHubImageItem>();
                for (DockerHubImageItem image : fresh) {
                    model.addElement(image);
                }
                if (model.isEmpty()) {
                    DockerHubSearchPanel.this.messageLabel.setText(NbBundle.getMessage(DockerHubSearchPanel.class, (String)"DockerHubSearchPanel.noImagesFound"));
                    DockerHubSearchPanel.this.imageListScrollPane.setViewportView(DockerHubSearchPanel.this.messagePanel);
                } else {
                    DockerHubSearchPanel.this.imageListScrollPane.setViewportView(DockerHubSearchPanel.this.imageList);
                    DockerHubSearchPanel.this.imageList.clearSelection();
                    DockerHubSearchPanel.this.imageList.setModel(model);
                }
                DockerHubSearchPanel.this.repaint();
                DockerHubSearchPanel.this.revalidate();
            }
        });
    }

    public String getImage() {
        DockerHubImageItem selected = this.imageList.getSelectedValue();
        String toPull = selected != null ? selected.getHubImage().getName() : this.searchTextField.getText().trim();
        toPull = DockerHubSearchPanel.appendLatestTag(toPull);
        return toPull;
    }

    public static String appendLatestTag(String image) {
        String ret = image;
        if (!image.contains(":") && !image.contains("@")) {
            ret = ret + ":latest";
        }
        return ret;
    }

    private void initComponents() {
        this.messagePanel = new JPanel();
        this.messageLabel = new JLabel();
        this.searchTextField = new JTextField();
        this.imageListScrollPane = new JScrollPane();
        this.imageList = new JList();
        this.searchTextLabel = new JLabel();
        this.imageListLabel = new JLabel();
        this.resultTextField = new JTextField();
        this.resultLabel = new JLabel();
        this.messagePanel.setLayout(new GridBagLayout());
        this.messageLabel.setHorizontalAlignment(0);
        this.messagePanel.add((Component)this.messageLabel, new GridBagConstraints());
        this.imageList.setSelectionMode(0);
        this.imageListScrollPane.setViewportView(this.imageList);
        this.searchTextLabel.setLabelFor(this.searchTextField);
        Mnemonics.setLocalizedText((JLabel)this.searchTextLabel, (String)NbBundle.getMessage(DockerHubSearchPanel.class, (String)"DockerHubSearchPanel.searchTextLabel.text"));
        this.imageListLabel.setLabelFor(this.imageList);
        Mnemonics.setLocalizedText((JLabel)this.imageListLabel, (String)NbBundle.getMessage(DockerHubSearchPanel.class, (String)"DockerHubSearchPanel.imageListLabel.text"));
        this.resultTextField.setEditable(false);
        this.resultTextField.setFocusable(false);
        this.resultLabel.setLabelFor(this.resultTextField);
        Mnemonics.setLocalizedText((JLabel)this.resultLabel, (String)NbBundle.getMessage(DockerHubSearchPanel.class, (String)"DockerHubSearchPanel.resultLabel.text"));
        GroupLayout layout = new GroupLayout(this);
        this.setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.imageListScrollPane, -1, 721, Short.MAX_VALUE).addComponent(this.searchTextField).addComponent(this.resultTextField).addGroup(layout.createSequentialGroup().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.searchTextLabel).addComponent(this.imageListLabel).addComponent(this.resultLabel)).addGap(0, 0, Short.MAX_VALUE))).addContainerGap()));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addComponent(this.searchTextLabel).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.searchTextField, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.imageListLabel).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.imageListScrollPane, -1, 363, Short.MAX_VALUE).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.resultLabel).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.resultTextField, -2, -1, -2).addContainerGap()));
    }

    private class SelectionListener
    implements ListSelectionListener {
        private SelectionListener() {
        }

        @Override
        public void valueChanged(ListSelectionEvent e) {
            if (e.getValueIsAdjusting()) {
                return;
            }
            DockerHubSearchPanel.this.resultTextField.setText(DockerHubSearchPanel.this.getImage());
        }
    }

    private class SearchListener
    implements DocumentListener {
        private SearchListener() {
        }

        @Override
        public void insertUpdate(DocumentEvent e) {
            this.update(e);
        }

        @Override
        public void removeUpdate(DocumentEvent e) {
            this.update(e);
        }

        @Override
        public void changedUpdate(DocumentEvent e) {
            this.update(e);
        }

        private void update(DocumentEvent e) {
            String text = DockerHubSearchPanel.this.searchTextField.getText().trim();
            DockerHubSearchPanel.this.pullButton.setEnabled(!text.isEmpty());
            DockerHubSearchPanel.this.imageList.clearSelection();
            if (text.isEmpty()) {
                DockerHubSearchPanel.this.searchTask.cancel();
                DockerHubSearchPanel.this.imageListScrollPane.setViewportView(null);
                DockerHubSearchPanel.this.resultTextField.setText("");
            } else {
                DockerHubSearchPanel.this.messageLabel.setText(NbBundle.getMessage(DockerHubSearchPanel.class, (String)"DockerHubSearchPanel.searching"));
                DockerHubSearchPanel.this.imageListScrollPane.setViewportView(DockerHubSearchPanel.this.messagePanel);
                DockerHubSearchPanel.this.searchTerm.set(text);
                DockerHubSearchPanel.this.searchTask.schedule(1000);
                DockerHubSearchPanel.this.resultTextField.setText(DockerHubSearchPanel.this.getImage());
            }
            DockerHubSearchPanel.this.repaint();
            DockerHubSearchPanel.this.revalidate();
        }
    }
}

