/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.libs.git.jgit.commands;

import java.io.File;
import java.io.IOException;
import org.eclipse.jgit.dircache.DirCache;
import org.eclipse.jgit.dircache.DirCacheBuilder;
import org.eclipse.jgit.lib.Repository;
import org.netbeans.libs.git.GitException;
import org.netbeans.libs.git.jgit.GitClassFactory;
import org.netbeans.libs.git.jgit.commands.GitCommand;
import org.netbeans.libs.git.jgit.utils.CheckoutIndex;
import org.netbeans.libs.git.progress.FileListener;
import org.netbeans.libs.git.progress.ProgressMonitor;

public class CheckoutIndexCommand
extends GitCommand {
    private final File[] roots;
    private final FileListener listener;
    private final ProgressMonitor monitor;
    private final boolean recursively;

    public CheckoutIndexCommand(Repository repository, GitClassFactory gitFactory, File[] roots, boolean recursively, ProgressMonitor monitor, FileListener listener) {
        super(repository, gitFactory, monitor);
        this.roots = roots;
        this.listener = listener;
        this.monitor = monitor;
        this.recursively = recursively;
    }

    @Override
    protected void run() throws GitException {
        Repository repository = this.getRepository();
        DirCache cache = null;
        try {
            cache = repository.lockDirCache();
            DirCacheBuilder builder = cache.builder();
            if (cache.getEntryCount() > 0) {
                builder.keep(0, cache.getEntryCount());
            }
            builder.finish();
            new CheckoutIndex(repository, cache, this.roots, this.recursively, this.listener, this.monitor, true).checkout();
            builder.commit();
        }
        catch (IOException ex) {
            throw new GitException(ex);
        }
        finally {
            if (cache != null) {
                cache.unlock();
            }
        }
    }

    @Override
    protected String getCommandDescription() {
        StringBuilder sb = new StringBuilder("git checkout -- ");
        for (File root : this.roots) {
            sb.append(" ").append(root);
        }
        return sb.toString();
    }
}

