/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.java.disco;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import javax.swing.AbstractButton;
import javax.swing.GroupLayout;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.JToggleButton;
import javax.swing.LayoutStyle;
import org.checkerframework.checker.guieffect.qual.UIEffect;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.netbeans.modules.java.disco.Client;
import org.netbeans.modules.java.disco.OS;
import org.netbeans.modules.java.disco.SwingWorker2;
import org.netbeans.modules.java.disco.WizardState;
import org.openide.awt.Mnemonics;
import org.openide.util.NbBundle;

public class BrowsePanel
extends JPanel {
    private final WizardState state;
    private final Client discoClient;
    private JToggleButton chooseButton;
    private JTextField downloadPathText;
    private JLabel jLabel1;
    private JLabel jLabel2;
    private JLabel jdkDescription;

    @UIEffect
    public static BrowsePanel create(WizardState state) {
        BrowsePanel d = new BrowsePanel(state);
        d.init();
        return d;
    }

    public BrowsePanel(WizardState state) {
        this.state = state;
        this.discoClient = Client.getInstance();
    }

    @UIEffect
    private void init() {
        this.setName("Browse");
        this.initComponents();
    }

    @Override
    @UIEffect
    public void addNotify() {
        super.addNotify();
        this.jdkDescription.setText(this.state.selection.getFileName());
        if (this.state.selection.get(null) == null) {
            SwingWorker2.submit(() -> this.state.selection.get(this.discoClient)).then(pkg -> this.jdkDescription.setText(this.state.selection.getFileName())).execute();
        }
    }

    public boolean isOK() {
        return !this.downloadPathText.getText().isEmpty();
    }

    public @NonNull String getDefaultDownloadFolder() {
        File f = OS.getDefaultDownloadFolder();
        if (f == null) {
            return "";
        }
        return f.getAbsolutePath();
    }

    public String getUserDownloadFolder() {
        return this.downloadPathText.getText();
    }

    private void initComponents() {
        this.jLabel1 = new JLabel();
        this.jdkDescription = new JLabel();
        this.jLabel2 = new JLabel();
        this.downloadPathText = new JTextField();
        this.chooseButton = new JToggleButton();
        Mnemonics.setLocalizedText((JLabel)this.jLabel1, (String)NbBundle.getMessage(BrowsePanel.class, (String)"BrowsePanel.jLabel1.text"));
        Mnemonics.setLocalizedText((JLabel)this.jdkDescription, (String)NbBundle.getMessage(BrowsePanel.class, (String)"BrowsePanel.jdkDescription.text"));
        Mnemonics.setLocalizedText((JLabel)this.jLabel2, (String)NbBundle.getMessage(BrowsePanel.class, (String)"BrowsePanel.jLabel2.text"));
        this.downloadPathText.setEditable(false);
        this.downloadPathText.setText(this.getDefaultDownloadFolder());
        Mnemonics.setLocalizedText((AbstractButton)this.chooseButton, (String)NbBundle.getMessage(BrowsePanel.class, (String)"BrowsePanel.chooseButton.text"));
        this.chooseButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                BrowsePanel.this.chooseButtonActionPerformed(evt);
            }
        });
        GroupLayout layout = new GroupLayout(this);
        this.setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(GroupLayout.Alignment.TRAILING, layout.createSequentialGroup().addComponent(this.jLabel2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.downloadPathText, -1, 194, Short.MAX_VALUE).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.chooseButton)).addGroup(layout.createSequentialGroup().addComponent(this.jLabel1).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jdkDescription, -1, -1, Short.MAX_VALUE).addContainerGap()))));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jLabel1).addComponent(this.jdkDescription)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jLabel2).addComponent(this.downloadPathText, -2, -1, -2).addComponent(this.chooseButton)).addContainerGap(-1, Short.MAX_VALUE)));
    }

    private void chooseButtonActionPerformed(ActionEvent evt) {
        File folder;
        JFileChooser fileChooser = new JFileChooser();
        fileChooser.setCurrentDirectory(new File("."));
        fileChooser.setDialogTitle("Select destination folder");
        fileChooser.setFileSelectionMode(1);
        fileChooser.setAcceptAllFileFilterUsed(false);
        if (fileChooser.showOpenDialog(this) == 0 && (folder = fileChooser.getSelectedFile()) != null) {
            String destinationFolder = folder.getAbsolutePath();
            this.downloadPathText.setText(destinationFolder);
        }
    }
}

