/*
 * Decompiled with CFR 0.152.
 */
package org.apache.struts.faces.taglib;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import java.util.Locale;
import java.util.Map;
import javax.faces.component.UIComponent;
import javax.faces.context.FacesContext;
import javax.faces.webapp.UIComponentTag;
import javax.servlet.ServletContext;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.jsp.JspException;
import javax.servlet.jsp.JspWriter;
import javax.servlet.jsp.tagext.BodyTagSupport;
import javax.servlet.jsp.tagext.Tag;
import org.apache.commons.validator.Field;
import org.apache.commons.validator.Form;
import org.apache.commons.validator.ValidatorAction;
import org.apache.commons.validator.ValidatorResources;
import org.apache.commons.validator.Var;
import org.apache.commons.validator.util.ValidatorUtils;
import org.apache.struts.config.ModuleConfig;
import org.apache.struts.faces.component.FormComponent;
import org.apache.struts.taglib.TagUtils;
import org.apache.struts.util.MessageResources;
import org.apache.struts.util.ModuleUtils;
import org.apache.struts.validator.Resources;

public class JavascriptValidatorTag
extends BodyTagSupport {
    protected String bundle = "org.apache.struts.action.MESSAGE";
    protected static Locale defaultLocale = Locale.getDefault();
    protected String formName = null;
    protected static String lineEnd = System.getProperty("line.separator");
    protected int page = 0;
    protected String methodName = null;
    protected String staticJavascript = "true";
    protected String dynamicJavascript = "true";
    protected String src = null;
    protected String htmlComment = "true";
    protected String cdata = "true";
    private String htmlBeginComment = "\n<!-- Begin \n";
    private String htmlEndComment = "//End --> \n";
    private String formClientId = null;
    private static boolean struts11;

    public String getFormName() {
        return this.formName;
    }

    public void setFormName(String formName) {
        this.formName = formName;
    }

    public int getPage() {
        return this.page;
    }

    public void setPage(int page) {
        this.page = page;
    }

    public String getMethod() {
        return this.methodName;
    }

    public void setMethod(String methodName) {
        this.methodName = methodName;
    }

    public String getStaticJavascript() {
        return this.staticJavascript;
    }

    public void setStaticJavascript(String staticJavascript) {
        this.staticJavascript = staticJavascript;
    }

    public String getDynamicJavascript() {
        return this.dynamicJavascript;
    }

    public void setDynamicJavascript(String dynamicJavascript) {
        this.dynamicJavascript = dynamicJavascript;
    }

    public String getHtmlComment() {
        return this.htmlComment;
    }

    public void setHtmlComment(String htmlComment) {
        this.htmlComment = htmlComment;
    }

    public String getSrc() {
        return this.src;
    }

    public void setSrc(String src) {
        this.src = src;
    }

    public int doStartTag() throws JspException {
        Locale locale;
        StringBuffer results = new StringBuffer();
        HttpServletRequest request = (HttpServletRequest)this.pageContext.getRequest();
        ServletContext servletContext = this.pageContext.getServletContext();
        ModuleConfig config = ModuleUtils.getInstance().getModuleConfig(request, servletContext);
        ValidatorResources resources = (ValidatorResources)this.pageContext.getAttribute("org.apache.commons.validator.VALIDATOR_RESOURCES" + config.getPrefix(), 4);
        Form form = resources.getForm(locale = TagUtils.getInstance().getUserLocale(this.pageContext, null), this.formName);
        if (form != null) {
            if ("true".equalsIgnoreCase(this.dynamicJavascript)) {
                ValidatorAction va;
                MessageResources messages = (MessageResources)this.pageContext.getAttribute(this.bundle + config.getPrefix(), 4);
                ArrayList<ValidatorAction> lActions = new ArrayList<ValidatorAction>();
                ArrayList lActionMethods = new ArrayList();
                Iterator i = form.getFields().iterator();
                while (i.hasNext()) {
                    Field field = (Field)i.next();
                    Iterator x = field.getDependencyList().iterator();
                    while (x.hasNext()) {
                        Object o = x.next();
                        if (o == null || lActionMethods.contains(o)) continue;
                        lActionMethods.add(o);
                    }
                }
                i = lActionMethods.iterator();
                while (i.hasNext()) {
                    String depends = (String)i.next();
                    va = resources.getValidatorAction(depends);
                    if (va == null) {
                        throw new NullPointerException("Depends string \"" + depends + "\" was not found in validator-rules.xml.");
                    }
                    String javascript = va.getJavascript();
                    if (javascript != null && javascript.length() > 0) {
                        lActions.add(va);
                        continue;
                    }
                    i.remove();
                }
                Collections.sort(lActions, new Comparator(){

                    public int compare(Object o1, Object o2) {
                        ValidatorAction va1 = (ValidatorAction)o1;
                        ValidatorAction va2 = (ValidatorAction)o2;
                        if (!(va1.getDepends() != null && va1.getDepends().length() != 0 || va2.getDepends() != null && va2.getDepends().length() != 0)) {
                            return 0;
                        }
                        if (va1.getDepends() != null && va1.getDepends().length() > 0 && (va2.getDepends() == null || va2.getDepends().length() == 0)) {
                            return 1;
                        }
                        if ((va1.getDepends() == null || va1.getDepends().length() == 0) && va2.getDepends() != null && va2.getDepends().length() > 0) {
                            return -1;
                        }
                        return va1.getDependencyList().size() - va2.getDependencyList().size();
                    }
                });
                String methods = null;
                Iterator i2 = lActions.iterator();
                while (i2.hasNext()) {
                    va = (ValidatorAction)i2.next();
                    if (methods == null) {
                        methods = va.getMethod() + "(form)";
                        continue;
                    }
                    methods = methods + " && " + va.getMethod() + "(form)";
                }
                results.append(this.getJavascriptBegin(methods));
                i2 = lActions.iterator();
                while (i2.hasNext()) {
                    va = (ValidatorAction)i2.next();
                    String jscriptVar = null;
                    String functionName = null;
                    functionName = va.getJsFunctionName() != null && va.getJsFunctionName().length() > 0 ? va.getJsFunctionName() : va.getName();
                    if (JavascriptValidatorTag.isStruts11()) {
                        results.append("    function " + functionName + " () { \n");
                    } else {
                        results.append("    function " + this.formName + "_" + functionName + " () { \n");
                    }
                    Iterator x = form.getFields().iterator();
                    while (x.hasNext()) {
                        Field field = (Field)x.next();
                        if (field.isIndexed() || field.getPage() != this.page || !field.isDependency(va.getName())) continue;
                        String message = Resources.getMessage((MessageResources)messages, (Locale)locale, (ValidatorAction)va, (Field)field);
                        message = message != null ? message : "";
                        jscriptVar = this.getNextVar(jscriptVar);
                        results.append("     this." + jscriptVar + " = new Array(\"" + this.getFormClientId() + ":" + field.getKey() + "\", \"" + message + "\", ");
                        results.append("new Function (\"varName\", \"");
                        Map vars = field.getVars();
                        Iterator varsIterator = vars.keySet().iterator();
                        while (varsIterator.hasNext()) {
                            String varName = (String)varsIterator.next();
                            Var var = (Var)vars.get(varName);
                            String varValue = var.getValue();
                            String jsType = var.getJsType();
                            if (varName.startsWith("field")) continue;
                            if ("int".equalsIgnoreCase(jsType)) {
                                results.append("this." + varName + "=" + ValidatorUtils.replace((String)varValue, (String)"\\", (String)"\\\\") + "; ");
                                continue;
                            }
                            if ("regexp".equalsIgnoreCase(jsType)) {
                                results.append("this." + varName + "=/" + ValidatorUtils.replace((String)varValue, (String)"\\", (String)"\\\\") + "/; ");
                                continue;
                            }
                            if ("string".equalsIgnoreCase(jsType)) {
                                results.append("this." + varName + "='" + ValidatorUtils.replace((String)varValue, (String)"\\", (String)"\\\\") + "'; ");
                                continue;
                            }
                            if ("mask".equalsIgnoreCase(varName)) {
                                results.append("this." + varName + "=/" + ValidatorUtils.replace((String)varValue, (String)"\\", (String)"\\\\") + "/; ");
                                continue;
                            }
                            results.append("this." + varName + "='" + ValidatorUtils.replace((String)varValue, (String)"\\", (String)"\\\\") + "'; ");
                        }
                        results.append(" return this[varName];\"));\n");
                    }
                    results.append("    } \n\n");
                }
            } else if ("true".equalsIgnoreCase(this.staticJavascript)) {
                results.append(this.getStartElement());
                if ("true".equalsIgnoreCase(this.htmlComment)) {
                    results.append(this.htmlBeginComment);
                }
            }
        }
        if ("true".equalsIgnoreCase(this.staticJavascript)) {
            results.append(this.getJavascriptStaticMethods(resources));
        }
        if (form != null && ("true".equalsIgnoreCase(this.dynamicJavascript) || "true".equalsIgnoreCase(this.staticJavascript))) {
            results.append(this.getJavascriptEnd());
        }
        JspWriter writer = this.pageContext.getOut();
        try {
            writer.print(results.toString());
        }
        catch (IOException e) {
            throw new JspException(e.getMessage());
        }
        return 2;
    }

    public void release() {
        super.release();
        this.bundle = "org.apache.struts.action.MESSAGE";
        this.formName = null;
        this.page = 0;
        this.methodName = null;
        this.staticJavascript = "true";
        this.dynamicJavascript = "true";
        this.htmlComment = "true";
        this.cdata = "true";
        this.src = null;
        this.formClientId = null;
    }

    protected String getJavascriptBegin(String methods) {
        StringBuffer sb = new StringBuffer();
        String name = this.formName.substring(0, 1).toUpperCase() + this.formName.substring(1, this.formName.length());
        sb.append(this.getStartElement());
        if (this.isXhtml() && "true".equalsIgnoreCase(this.cdata)) {
            sb.append("<![CDATA[\r\n");
        }
        if (!this.isXhtml() && "true".equals(this.htmlComment)) {
            sb.append(this.htmlBeginComment);
        }
        sb.append("\n     var bCancel = false; \n\n");
        if (this.methodName == null || this.methodName.length() == 0) {
            sb.append("    function validate" + name + "(form) {                                          " + "                         \n");
        } else {
            sb.append("    function " + this.methodName + "(form) {                                          " + "                         \n");
        }
        sb.append("        if (bCancel) \n");
        sb.append("      return true; \n");
        sb.append("        else \n");
        if (methods == null || methods.length() == 0) {
            sb.append("       return true; \n");
        } else {
            sb.append("       return " + methods + "; \n");
        }
        sb.append("   } \n\n");
        return sb.toString();
    }

    protected String getJavascriptStaticMethods(ValidatorResources resources) {
        StringBuffer sb = new StringBuffer();
        sb.append("\n\n");
        Iterator actions = resources.getValidatorActions().values().iterator();
        while (actions.hasNext()) {
            String javascript;
            ValidatorAction va = (ValidatorAction)actions.next();
            if (va == null || (javascript = va.getJavascript()) == null || javascript.length() <= 0) continue;
            sb.append(javascript + "\n");
        }
        return sb.toString();
    }

    protected String getJavascriptEnd() {
        StringBuffer sb = new StringBuffer();
        sb.append("\n");
        if (!this.isXhtml() && "true".equals(this.htmlComment)) {
            sb.append(this.htmlEndComment);
        }
        if (this.isXhtml() && "true".equalsIgnoreCase(this.cdata)) {
            sb.append("]]>\r\n");
        }
        sb.append("</script>\n\n");
        return sb.toString();
    }

    private String getNextVar(String input) {
        if (input == null) {
            return "aa";
        }
        input = input.toLowerCase();
        for (int i = input.length(); i > 0; --i) {
            int pos = i - 1;
            char c = input.charAt(pos);
            if ((c = (char)(c + '\u0001')) <= 'z') {
                if (i == 0) {
                    return c + input.substring(pos, input.length());
                }
                if (i == input.length()) {
                    return input.substring(0, pos) + c;
                }
                return input.substring(0, pos) + c + input.substring(pos, input.length() - 1);
            }
            input = this.replaceChar(input, pos, 'a');
        }
        return null;
    }

    private String replaceChar(String input, int pos, char c) {
        if (pos == 0) {
            return c + input.substring(pos, input.length());
        }
        if (pos == input.length()) {
            return input.substring(0, pos) + c;
        }
        return input.substring(0, pos) + c + input.substring(pos, input.length() - 1);
    }

    private String getStartElement() {
        StringBuffer start = new StringBuffer("<script type=\"text/javascript\"");
        if (!this.isXhtml()) {
            start.append(" language=\"Javascript1.1\"");
        }
        if (this.src != null) {
            start.append(" src=\"" + this.src + "\"");
        }
        start.append("> \n");
        return start.toString();
    }

    private boolean isXhtml() {
        return TagUtils.getInstance().isXhtml(this.pageContext);
    }

    public String getCdata() {
        return this.cdata;
    }

    public void setCdata(String cdata) {
        this.cdata = cdata;
    }

    private String getFormClientId() {
        Tag parent;
        if (this.formClientId != null) {
            return this.formClientId;
        }
        for (parent = this.getParent(); parent != null && !(parent instanceof UIComponentTag); parent = parent.getParent()) {
        }
        if (parent == null) {
            throw new IllegalArgumentException("Not nested inside a UIComponentTag");
        }
        UIComponent parentComponent = ((UIComponentTag)parent).getComponentInstance();
        if (parentComponent instanceof FormComponent && this.formName.equals(parentComponent.getAttributes().get("beanName"))) {
            this.formClientId = parentComponent.getClientId(FacesContext.getCurrentInstance());
            return this.formClientId;
        }
        Iterator kids = ((UIComponentTag)parent).getComponentInstance().getChildren().iterator();
        while (kids.hasNext()) {
            UIComponent kid = (UIComponent)kids.next();
            if (!(kid instanceof FormComponent) || !this.formName.equals(kid.getAttributes().get("beanName"))) continue;
            this.formClientId = kid.getClientId(FacesContext.getCurrentInstance());
            return this.formClientId;
        }
        throw new IllegalArgumentException("Cannot find child FormComponent for form '" + this.formName + "'");
    }

    private static boolean isStruts11() {
        return struts11;
    }

    static {
        try {
            JavascriptValidatorTag.class.getClassLoader().loadClass("org.apache.struts.taglib.TagUtils");
            struts11 = false;
        }
        catch (Exception e) {
            struts11 = true;
        }
    }
}

