/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.java.api.common.project.ui;

import java.io.IOException;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Set;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.stream.Collectors;
import org.netbeans.api.progress.ProgressUtils;
import org.netbeans.api.project.Project;
import org.netbeans.api.project.ProjectManager;
import org.openide.nodes.Node;
import org.openide.util.Exceptions;
import org.openide.util.HelpCtx;
import org.openide.util.NbBundle;
import org.openide.util.actions.NodeAction;

final class RemoveClassPathRootAction
extends NodeAction {
    RemoveClassPathRootAction() {
    }

    protected void performAction(Node[] activatedNodes) {
        assert (!ProjectManager.mutex().isReadAccess());
        AtomicBoolean cancel = new AtomicBoolean();
        Runnable action = () -> {
            Set<Removable> removables = Arrays.stream(activatedNodes).map(n -> (Removable)n.getLookup().lookup(Removable.class)).filter(r -> r != null).collect(Collectors.toSet());
            removables.forEach(Removable::beforeRemove);
            try {
                ProjectManager.mutex().writeAccess(() -> {
                    if (cancel.get()) {
                        return;
                    }
                    HashSet<Project> changedProjectsSet = new HashSet<Project>();
                    for (Removable removable : removables) {
                        if (cancel.get()) break;
                        Project p = removable.remove();
                        if (p == null) continue;
                        changedProjectsSet.add(p);
                    }
                    for (Project p : changedProjectsSet) {
                        try {
                            ProjectManager.getDefault().saveProject(p);
                        }
                        catch (IOException e) {
                            Exceptions.printStackTrace((Throwable)e);
                        }
                    }
                });
            }
            finally {
                removables.forEach(Removable::afterRemove);
            }
        };
        ProgressUtils.runOffEventDispatchThread((Runnable)action, (String)NbBundle.getMessage(RemoveClassPathRootAction.class, (String)"TXT_RemovingClassPathRoots"), (AtomicBoolean)cancel, (boolean)false);
    }

    protected boolean enable(Node[] activatedNodes) {
        for (int i = 0; i < activatedNodes.length; ++i) {
            Removable removable = (Removable)activatedNodes[i].getLookup().lookup(Removable.class);
            if (removable == null) {
                return false;
            }
            if (removable.canRemove()) continue;
            return false;
        }
        return true;
    }

    public String getName() {
        return NbBundle.getMessage(RemoveClassPathRootAction.class, (String)"CTL_RemoveProject");
    }

    public HelpCtx getHelpCtx() {
        return new HelpCtx(RemoveClassPathRootAction.class);
    }

    protected boolean asynchronous() {
        return false;
    }

    static interface Removable {
        public boolean canRemove();

        public Project remove();

        default public void beforeRemove() {
        }

        default public void afterRemove() {
        }
    }
}

