/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.gradle.loaders;

import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedHashSet;
import org.netbeans.modules.gradle.GradleProject;
import org.netbeans.modules.gradle.api.NbGradleProject;
import org.netbeans.modules.gradle.loaders.AbstractProjectLoader;
import org.netbeans.modules.gradle.spi.GradleFiles;
import org.netbeans.modules.gradle.spi.ProjectInfoExtractor;
import org.openide.util.Lookup;

public class FallbackProjectLoader
extends AbstractProjectLoader {
    final GradleFiles files;

    FallbackProjectLoader(AbstractProjectLoader.ReloadContext ctx) {
        super(ctx);
        this.files = ctx.project.getGradleFiles();
    }

    @Override
    public GradleProject load() {
        return FallbackProjectLoader.createFallbackProject(this.files);
    }

    public static GradleProject createFallbackProject(GradleFiles files) {
        Collection extractors = Lookup.getDefault().lookupAll(ProjectInfoExtractor.class);
        HashMap infos = new HashMap();
        LinkedHashSet<String> problems = new LinkedHashSet<String>();
        for (ProjectInfoExtractor extractor : extractors) {
            ProjectInfoExtractor.Result result = extractor.fallback(files);
            problems.addAll(result.getProblems());
            for (Object extract : result.getExtract()) {
                infos.put(extract.getClass(), extract);
            }
        }
        return new GradleProject(NbGradleProject.Quality.FALLBACK, problems, infos.values());
    }

    @Override
    boolean isEnabled() {
        return true;
    }

    @Override
    boolean needsTrust() {
        return false;
    }
}

