/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.cpplite.project;

import java.io.File;
import java.util.Collections;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import org.netbeans.api.extexecution.ExecutionDescriptor;
import org.netbeans.api.extexecution.ExecutionService;
import org.netbeans.api.extexecution.print.ConvertedLine;
import org.netbeans.api.extexecution.print.LineConvertor;
import org.netbeans.api.project.Project;
import org.netbeans.api.project.ProjectUtils;
import org.netbeans.modules.cpplite.debugger.api.Debugger;
import org.netbeans.modules.cpplite.project.BuildConfiguration;
import org.netbeans.modules.cpplite.project.CPPLiteProject;
import org.netbeans.modules.cpplite.project.runner.Runner;
import org.netbeans.spi.project.ActionProvider;
import org.openide.LifecycleManager;
import org.openide.cookies.LineCookie;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.modules.InstalledFileLocator;
import org.openide.text.Line;
import org.openide.util.Lookup;
import org.openide.windows.OutputEvent;
import org.openide.windows.OutputListener;

public class ActionProviderImpl
implements ActionProvider {
    private static final String[] SUPPORTED_ACTIONS = new String[]{"build", "rebuild", "run", "debug"};
    private final CPPLiteProject prj;
    private static final Pattern ERROR_LINE = Pattern.compile("(.*):(\\d+):(\\d+):.*");

    public ActionProviderImpl(CPPLiteProject prj) {
        this.prj = prj;
    }

    public String[] getSupportedActions() {
        return SUPPORTED_ACTIONS;
    }

    public void invokeAction(String command, Lookup context) throws IllegalArgumentException {
        BuildConfiguration config = this.prj.getActiveBuildConfiguration();
        File module = InstalledFileLocator.getDefault().locate("modules/org-netbeans-modules-cpplite-project.jar", "org.netbeans.modules.cpplite.project", false);
        ExecutionDescriptor executionDescriptor = new ExecutionDescriptor().showProgress(true).showSuspended(true).frontWindowOnError(true).controllable(true).errConvertorFactory(() -> new ErrorLineConvertor()).outConvertorFactory(() -> new ErrorLineConvertor());
        ExecutionService.newService(() -> {
            LifecycleManager.getDefault().saveAll();
            if ("debug".equals(command)) {
                List<List<String>> executablesFor = config.executablesFor("run");
                return Debugger.startInDebugger(executablesFor.get(0), (File)FileUtil.toFile((FileObject)this.prj.getProjectDirectory()));
            }
            List<List<String>> executablesFor = config.executablesFor(command);
            String arg = executablesFor.stream().map(c -> ActionProviderImpl.quote(c.stream().map(p -> ActionProviderImpl.quote(p)).collect(Collectors.joining(" ")))).collect(Collectors.joining(" "));
            return new ProcessBuilder("java", "-classpath", module.getAbsolutePath(), Runner.class.getName(), arg).directory(FileUtil.toFile((FileObject)this.prj.getProjectDirectory())).start();
        }, (ExecutionDescriptor)executionDescriptor, (String)(ProjectUtils.getInformation((Project)this.prj).getDisplayName() + " - " + command)).run();
    }

    private static String quote(String s) {
        return s.replace("_", "_u_").replace(" ", "_s_");
    }

    public boolean isActionEnabled(String command, Lookup context) throws IllegalArgumentException {
        if ("debug".equals(command)) {
            command = "run";
        }
        return this.prj.getActiveBuildConfiguration().executablesFor(command) != null;
    }

    private static class ErrorLineConvertor
    implements LineConvertor {
        private ErrorLineConvertor() {
        }

        public List<ConvertedLine> convert(String line) {
            Matcher matcher = ERROR_LINE.matcher(line);
            if (matcher.matches()) {
                final String fileName = matcher.group(1);
                final int lineNum = Integer.parseInt(matcher.group(2)) - 1;
                final int columnNum = Integer.parseInt(matcher.group(3)) - 1;
                return Collections.singletonList(ConvertedLine.forText((String)line, (OutputListener)new OutputListener(){

                    public void outputLineSelected(OutputEvent ev) {
                    }

                    public void outputLineAction(OutputEvent ev) {
                        FileObject file = FileUtil.toFileObject((File)new File(fileName));
                        if (file == null) {
                            return;
                        }
                        LineCookie lc = (LineCookie)file.getLookup().lookup(LineCookie.class);
                        lc.getLineSet().getCurrent(lineNum).show(Line.ShowOpenType.OPEN, Line.ShowVisibilityType.FOCUS, columnNum);
                    }

                    public void outputLineCleared(OutputEvent ev) {
                    }
                }));
            }
            return Collections.singletonList(ConvertedLine.forText((String)line, null));
        }
    }
}

