/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.js.runtime.array.dyn;

import com.oracle.truffle.api.Assumption;
import com.oracle.truffle.api.object.DynamicObject;
import com.oracle.truffle.js.runtime.array.DynamicArray;
import com.oracle.truffle.js.runtime.array.ScriptArray;
import com.oracle.truffle.js.runtime.array.dyn.AbstractConstantEmptyArray;
import com.oracle.truffle.js.runtime.array.dyn.AbstractDoubleArray;
import com.oracle.truffle.js.runtime.array.dyn.AbstractIntArray;
import com.oracle.truffle.js.runtime.array.dyn.AbstractJSObjectArray;
import com.oracle.truffle.js.runtime.array.dyn.AbstractObjectArray;
import com.oracle.truffle.js.runtime.objects.JSObject;

public final class ConstantEmptyPrototypeArray
extends AbstractConstantEmptyArray {
    public static ScriptArray createConstantEmptyPrototypeArray() {
        return new ConstantEmptyPrototypeArray(0, ConstantEmptyPrototypeArray.createCache());
    }

    private ConstantEmptyPrototypeArray(int integrityLevel, DynamicArray.DynamicArrayCache cache) {
        super(integrityLevel, cache);
    }

    private static Assumption getArrayPrototypeNoElementsAssumption(DynamicObject object) {
        return JSObject.getJSContext(object).getArrayPrototypeNoElementsAssumption();
    }

    @Override
    public ScriptArray setLengthImpl(DynamicObject object, long length, boolean condition, ScriptArray.ProfileHolder profile) {
        ConstantEmptyPrototypeArray.setCapacity(object, length);
        return this;
    }

    @Override
    public AbstractIntArray createWriteableInt(DynamicObject object, long index, int value, boolean condition, ScriptArray.ProfileHolder profile) {
        ConstantEmptyPrototypeArray.getArrayPrototypeNoElementsAssumption(object).invalidate("Array.prototype no element assumption");
        return super.createWriteableInt(object, index, value, condition, profile);
    }

    @Override
    public AbstractDoubleArray createWriteableDouble(DynamicObject object, long index, double value, boolean condition, ScriptArray.ProfileHolder profile) {
        ConstantEmptyPrototypeArray.getArrayPrototypeNoElementsAssumption(object).invalidate("Array.prototype no element assumption");
        return super.createWriteableDouble(object, index, value, condition, profile);
    }

    @Override
    public AbstractJSObjectArray createWriteableJSObject(DynamicObject object, long index, DynamicObject value, boolean condition, ScriptArray.ProfileHolder profile) {
        ConstantEmptyPrototypeArray.getArrayPrototypeNoElementsAssumption(object).invalidate("Array.prototype no element assumption");
        return super.createWriteableJSObject(object, index, value, condition, profile);
    }

    @Override
    public AbstractObjectArray createWriteableObject(DynamicObject object, long index, Object value, boolean condition, ScriptArray.ProfileHolder profile) {
        ConstantEmptyPrototypeArray.getArrayPrototypeNoElementsAssumption(object).invalidate("Array.prototype no element assumption");
        return super.createWriteableObject(object, index, value, condition, profile);
    }

    @Override
    public ScriptArray removeRangeImpl(DynamicObject object, long start, long end) {
        ConstantEmptyPrototypeArray.setCapacity(object, ConstantEmptyPrototypeArray.getCapacity(object) - (end - start));
        return this;
    }

    @Override
    public ScriptArray addRangeImpl(DynamicObject object, long offset, int size) {
        ConstantEmptyPrototypeArray.setCapacity(object, ConstantEmptyPrototypeArray.getCapacity(object) + (long)size);
        return this;
    }

    @Override
    protected DynamicArray withIntegrityLevel(int newIntegrityLevel) {
        return new ConstantEmptyPrototypeArray(newIntegrityLevel, this.cache);
    }
}

