/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.groovy.editor.hints;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.prefs.Preferences;
import javax.swing.JComponent;
import javax.swing.text.BadLocationException;
import javax.swing.text.Document;
import org.codehaus.groovy.ast.ASTNode;
import org.codehaus.groovy.ast.ImportNode;
import org.codehaus.groovy.ast.ModuleNode;
import org.netbeans.editor.BaseDocument;
import org.netbeans.editor.Finder;
import org.netbeans.editor.FinderFactory;
import org.netbeans.modules.csl.api.EditList;
import org.netbeans.modules.csl.api.Hint;
import org.netbeans.modules.csl.api.HintFix;
import org.netbeans.modules.csl.api.HintSeverity;
import org.netbeans.modules.csl.api.Rule;
import org.netbeans.modules.csl.api.RuleContext;
import org.netbeans.modules.editor.NbEditorUtilities;
import org.netbeans.modules.groovy.editor.api.ASTUtils;
import org.netbeans.modules.groovy.editor.api.lexer.GroovyTokenId;
import org.netbeans.modules.groovy.editor.api.lexer.LexUtilities;
import org.netbeans.modules.groovy.editor.hints.infrastructure.GroovyAstRule;
import org.netbeans.modules.groovy.editor.hints.infrastructure.GroovyHintsProvider;
import org.openide.util.Exceptions;

public class RemoveUnusedImportHint
extends GroovyAstRule {
    @Override
    public void computeHints(GroovyHintsProvider.GroovyRuleContext context, List<Hint> result) {
        ModuleNode moduleNode = context.getGroovyParserResult().getRootElement().getModuleNode();
        if (null == moduleNode) {
            return;
        }
        List importNodes = moduleNode.getImports();
        for (ImportNode importNode : importNodes) {
            String alias = importNode.getAlias();
            try {
                int find = 0;
                FinderFactory.StringFwdFinder stringFwdFinder = new FinderFactory.StringFwdFinder(alias, true);
                while (-1 != (find = context.doc.find((Finder)stringFwdFinder, find + 1, -1)) && this.skipUsage(find, context.doc)) {
                }
                if (-1 != find) continue;
                result.add(new Hint((Rule)this, "Unused Import", NbEditorUtilities.getFileObject((Document)context.doc), ASTUtils.getRangeFull((ASTNode)importNode, context.doc), Collections.singletonList(new RemoveUnusedImportFix("Remove unused import", context.doc, importNode)), 1));
            }
            catch (BadLocationException ex) {
                Exceptions.printStackTrace((Throwable)ex);
            }
        }
    }

    private boolean skipUsage(int position, BaseDocument doc) {
        int lineNo = NbEditorUtilities.getLine((BaseDocument)doc, (int)position, (boolean)true).getLineNumber();
        if (0 == lineNo) {
            return true;
        }
        GroovyTokenId tokenIdAtPosition = (GroovyTokenId)LexUtilities.getToken(doc, position).id();
        return GroovyTokenId.LITERAL_import == LexUtilities.getToken(doc, ASTUtils.getOffset(doc, lineNo + 1, 2)).id() || GroovyTokenId.SH_COMMENT == tokenIdAtPosition || GroovyTokenId.SL_COMMENT == tokenIdAtPosition || GroovyTokenId.LINE_COMMENT == tokenIdAtPosition || GroovyTokenId.BLOCK_COMMENT == tokenIdAtPosition;
    }

    @Override
    public Set<?> getKinds() {
        return new HashSet<String>(Arrays.asList("Import Hints"));
    }

    public String getId() {
        return "imports.unused.hint";
    }

    public String getDescription() {
        return "Remove unused Import";
    }

    public boolean getDefaultEnabled() {
        return true;
    }

    public JComponent getCustomizer(Preferences node) {
        return null;
    }

    public boolean appliesTo(RuleContext context) {
        return context instanceof GroovyHintsProvider.GroovyRuleContext;
    }

    public String getDisplayName() {
        return "Remove unused import";
    }

    public boolean showInTasklist() {
        return false;
    }

    public HintSeverity getDefaultSeverity() {
        return HintSeverity.INFO;
    }

    private static class RemoveUnusedImportFix
    implements HintFix {
        final BaseDocument baseDoc;
        final String desc;
        final ImportNode importNode;

        public RemoveUnusedImportFix(String desc, BaseDocument baseDoc, ImportNode importNode) {
            this.desc = desc;
            this.baseDoc = baseDoc;
            this.importNode = importNode;
        }

        public String getDescription() {
            return this.desc;
        }

        public void implement() throws Exception {
            EditList edits = new EditList(this.baseDoc);
            int offset = ASTUtils.getOffset(this.baseDoc, this.importNode.getLineNumber(), 1);
            int removeLen = ASTUtils.getOffset(this.baseDoc, this.importNode.getLineNumber() + 1, 1) - offset;
            edits.replace(offset, removeLen, "", true, 0);
            edits.apply();
        }

        public boolean isSafe() {
            return false;
        }

        public boolean isInteractive() {
            return false;
        }
    }
}

