/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.web.monitor.data;

import java.beans.PropertyChangeListener;
import java.io.InputStream;
import java.util.StringTokenizer;
import java.util.Vector;
import org.netbeans.modules.schema2beans.BaseBean;
import org.netbeans.modules.schema2beans.BeanComparator;
import org.netbeans.modules.schema2beans.BeanProp;
import org.netbeans.modules.schema2beans.GraphManager;
import org.netbeans.modules.schema2beans.Version;
import org.netbeans.modules.web.monitor.data.Headers;
import org.netbeans.modules.web.monitor.data.Param;
import org.netbeans.modules.web.monitor.data.RequestAttributesIn;
import org.netbeans.modules.web.monitor.data.RequestAttributesOut;
import org.w3c.dom.Document;
import org.w3c.dom.Node;

public class RequestData
extends BaseBean {
    static Vector<BeanComparator> comparators = new Vector();
    public static final String PARAM = "Param";
    public static final String HEADERS = "Headers";
    public static final String REQUESTATTRIBUTESIN = "RequestAttributesIn";
    public static final String REQUESTATTRIBUTESOUT = "RequestAttributesOut";
    public static final String REQUESTDATA = "RequestData";
    public static final String JSESSIONID = "JSESSIONID";
    public static final String COOKIE = "cookie";
    private static final boolean debug = false;

    public RequestData() {
        this(1);
    }

    public RequestData(Node doc, int options) {
        super(comparators, new Version(1, 0, 6));
        if (doc == null && (doc = GraphManager.createRootElementNode((String)REQUESTDATA)) == null) {
            throw new RuntimeException("failed to create a new DOM root!");
        }
        Node n = GraphManager.getElementNode((String)REQUESTDATA, (Node)doc);
        if (n == null) {
            throw new RuntimeException("doc root not found in the DOM graph!");
        }
        this.graphManager.setXmlDocument(doc);
        this.createBean(n, this.graphManager());
        this.initialize(options);
    }

    public RequestData(int options) {
        super(comparators, new Version(1, 0, 6));
        this.createProperty(HEADERS, HEADERS, 66080, Headers.class);
        this.createProperty(REQUESTATTRIBUTESIN, REQUESTATTRIBUTESIN, 66080, RequestAttributesIn.class);
        this.createProperty(REQUESTATTRIBUTESOUT, REQUESTATTRIBUTESOUT, 66080, RequestAttributesOut.class);
        this.createProperty(PARAM, PARAM, 66096, Param.class);
        this.createAttribute(PARAM, "name", "Name", 257, null, null);
        this.createAttribute(PARAM, "value", "Value", 513, null, null);
        this.initialize(options);
    }

    void initialize(int options) {
    }

    public void setHeaders(Headers value) {
        this.setValue(HEADERS, (Object)value);
    }

    public Headers getHeaders() {
        return (Headers)((Object)this.getValue(HEADERS));
    }

    public void setRequestAttributesIn(RequestAttributesIn value) {
        this.setValue(REQUESTATTRIBUTESIN, (Object)value);
    }

    public RequestAttributesIn getRequestAttributesIn() {
        return (RequestAttributesIn)((Object)this.getValue(REQUESTATTRIBUTESIN));
    }

    public void setRequestAttributesOut(RequestAttributesOut value) {
        this.setValue(REQUESTATTRIBUTESOUT, (Object)value);
    }

    public RequestAttributesOut getRequestAttributesOut() {
        return (RequestAttributesOut)((Object)this.getValue(REQUESTATTRIBUTESOUT));
    }

    public void setParam(int index, Param value) {
        this.setValue(PARAM, index, (Object)value);
    }

    public Param getParam(int index) {
        return (Param)((Object)this.getValue(PARAM, index));
    }

    public void setParam(Param[] value) {
        try {
            this.setValue(PARAM, (Object[])value);
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    public Param[] getParam() {
        return (Param[])this.getValues(PARAM);
    }

    public int sizeParam() {
        return this.size(PARAM);
    }

    public int addParam(Param value) {
        return this.addValue(PARAM, (Object)value);
    }

    public int removeParam(Param value) {
        return this.removeValue(PARAM, (Object)value);
    }

    public void setReplaceSessionCookie(boolean value) {
        this.setAttributeValue("replace", String.valueOf(value));
    }

    public boolean getReplaceSessionCookie() {
        try {
            if (this.getAttributeValue("replace").equals("true")) {
                return true;
            }
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
        return false;
    }

    public String getSessionID() {
        return RequestData.findSessionID(this.getCookieString());
    }

    public String getCookieString() {
        Param[] headers = this.getHeaders().getParam();
        StringBuffer cookieStr = new StringBuffer();
        int len = headers.length;
        for (int j = 0; j < len; ++j) {
            if (!headers[j].getName().equalsIgnoreCase(COOKIE)) continue;
            cookieStr.append(headers[j].getValue());
            cookieStr.append(";");
        }
        return cookieStr.toString();
    }

    public static String findSessionID(String cookieStr) {
        if (cookieStr == null || cookieStr.equals("")) {
            return "";
        }
        StringTokenizer tok = new StringTokenizer(cookieStr, ";", false);
        while (tok.hasMoreTokens()) {
            String name;
            String token = tok.nextToken();
            int i = token.indexOf("=");
            if (i <= -1 || !(name = token.substring(0, i).trim()).equals(JSESSIONID)) continue;
            String value = token.substring(i + 1, token.length()).trim();
            value = RequestData.stripQuote(value);
            return value;
        }
        return "";
    }

    public Param[] getCookiesAsParams() {
        String cookieStr = this.getCookieString();
        if (cookieStr == null || cookieStr.equals("")) {
            return new Param[0];
        }
        Vector<Param> cookies = new Vector<Param>();
        StringTokenizer tok = new StringTokenizer(cookieStr, ";", false);
        while (tok.hasMoreTokens()) {
            String token = tok.nextToken();
            int i = token.indexOf("=");
            if (i <= -1) continue;
            String name = token.substring(0, i).trim();
            String value = token.substring(i + 1, token.length()).trim();
            value = RequestData.stripQuote(value);
            cookies.addElement(new Param(name, value));
        }
        int numCookies = cookies.size();
        Param[] params = new Param[numCookies];
        for (int k = 0; k < numCookies; ++k) {
            params[k] = (Param)((Object)cookies.elementAt(k));
        }
        return params;
    }

    public int addCookie(String ckname, String ckvalue) {
        int len;
        StringBuffer buf = new StringBuffer();
        Param[] headers = this.getHeaders().getParam();
        if (headers == null) {
            headers = new Param[]{};
        }
        if ((len = headers.length) == 0) {
            buf.append(ckname);
            buf.append("=");
            buf.append(ckvalue);
            this.setCookieHeader(buf.toString());
            return 1;
        }
        for (int i = 0; i < len; ++i) {
            if (!headers[i].getName().equalsIgnoreCase(COOKIE)) continue;
            String oldCookies = headers[i].getValue();
            if (oldCookies != null && !oldCookies.trim().equals("")) {
                buf.append(oldCookies.trim());
                buf.append(";");
            }
            buf.append(ckname);
            buf.append("=");
            buf.append(ckvalue);
            headers[i].setValue(buf.toString());
            return 1;
        }
        buf.append(ckname);
        buf.append("=");
        buf.append(ckvalue);
        this.setCookieHeader(buf.toString());
        return 0;
    }

    public int addCookie(String ckstr) {
        int index = ckstr.indexOf("=");
        if (index == -1) {
            return this.addCookie(ckstr, "");
        }
        if (index == ckstr.length() - 1) {
            return this.addCookie(ckstr, "");
        }
        return this.addCookie(ckstr.substring(0, index), ckstr.substring(index + 1));
    }

    public void setCookieHeader(String cookies) {
        Param[] headers = this.getHeaders().getParam();
        if (headers == null) {
            headers = new Param[]{};
        }
        int len = headers.length;
        for (int i = 0; i < len; ++i) {
            if (!headers[i].getName().equalsIgnoreCase(COOKIE)) continue;
            headers[i].setValue(cookies);
            return;
        }
        Param p = new Param(COOKIE, cookies);
        this.getHeaders().addParam(p);
    }

    public void deleteCookie(String ckname, String ckvalue) {
        Param[] headers = this.getHeaders().getParam();
        boolean noCookie = false;
        if (headers == null || headers.length == 0) {
            return;
        }
        int len = headers.length;
        for (int i = 0; i < len; ++i) {
            if (!headers[i].getName().equalsIgnoreCase(COOKIE)) continue;
            String oldCookies = headers[i].getValue();
            if (oldCookies == null || oldCookies.trim().equals("")) {
                return;
            }
            StringBuffer buf = new StringBuffer();
            StringTokenizer tok = new StringTokenizer(headers[i].getValue(), ";", false);
            while (tok.hasMoreTokens()) {
                String token = tok.nextToken();
                int j = token.indexOf("=");
                if (j <= -1) continue;
                String name = token.substring(0, j).trim();
                String value = token.substring(j + 1, token.length()).trim();
                value = RequestData.stripQuote(value);
                if (name.equalsIgnoreCase(ckname) && value.equalsIgnoreCase(ckvalue)) continue;
                buf.append(name);
                buf.append("=");
                buf.append(value);
                buf.append(";");
            }
            if (buf.toString().equals("")) {
                this.getHeaders().removeParam(headers[i]);
                break;
            }
            headers[i].setValue(buf.toString());
            break;
        }
    }

    public void deleteCookie(String ckname) {
        Param[] headers = this.getHeaders().getParam();
        if (headers == null || headers.length == 0) {
            return;
        }
        int len = headers.length;
        for (int i = 0; i < len; ++i) {
            if (!headers[i].getName().equalsIgnoreCase(COOKIE)) continue;
            String oldCookies = headers[i].getValue();
            if (oldCookies == null || oldCookies.trim().equals("")) {
                return;
            }
            StringBuffer buf = new StringBuffer();
            StringTokenizer tok = new StringTokenizer(headers[i].getValue(), ";", false);
            while (tok.hasMoreTokens()) {
                String name;
                String token = tok.nextToken();
                int j = token.indexOf("=");
                if (j <= -1 || (name = token.substring(0, j).trim()).equalsIgnoreCase(ckname)) continue;
                String value = token.substring(j + 1, token.length()).trim();
                value = RequestData.stripQuote(value);
                buf.append(name);
                buf.append("=");
                buf.append(value);
                buf.append(";");
            }
            if (buf.toString().equals("")) {
                this.getHeaders().removeParam(headers[i]);
            } else {
                headers[i].setValue(buf.toString());
            }
            return;
        }
    }

    public static String stripQuote(String value) {
        if (value.startsWith("\"") && value.endsWith("\"") || value.startsWith("'") && value.endsWith("'")) {
            try {
                return value.substring(1, value.length() - 1);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return value;
    }

    public boolean verify() {
        return true;
    }

    public static void addComparator(BeanComparator c) {
        comparators.add(c);
    }

    public static void removeComparator(BeanComparator c) {
        comparators.remove(c);
    }

    public void addPropertyChangeListener(PropertyChangeListener l) {
        BeanProp p = this.beanProp();
        if (p != null) {
            p.addPCListener(l);
        }
    }

    public void removePropertyChangeListener(PropertyChangeListener l) {
        BeanProp p = this.beanProp();
        if (p != null) {
            p.removePCListener(l);
        }
    }

    public void addPropertyChangeListener(String n, PropertyChangeListener l) {
        BeanProp p = this.beanProp(n);
        if (p != null) {
            p.addPCListener(l);
        }
    }

    public void removePropertyChangeListener(String n, PropertyChangeListener l) {
        BeanProp p = this.beanProp(n);
        if (p != null) {
            p.removePCListener(l);
        }
    }

    public void dump(StringBuffer str, String indent) {
        str.append(indent);
        str.append(HEADERS);
        BaseBean n = this.getHeaders();
        if (n != null) {
            n.dump(str, indent + "\t");
        } else {
            str.append(indent + "\tnull");
        }
        this.dumpAttributes(HEADERS, 0, str, indent);
        str.append(indent);
        str.append("Param[" + this.sizeParam() + "]");
        for (int i = 0; i < this.sizeParam(); ++i) {
            str.append(indent + "\t");
            str.append("#" + i + ":");
            n = this.getParam(i);
            if (n != null) {
                n.dump(str, indent + "\t");
            } else {
                str.append(indent + "\tnull");
            }
            this.dumpAttributes(PARAM, i, str, indent);
        }
    }

    public String dumpBeanNode() {
        StringBuffer str = new StringBuffer();
        str.append("RequestData\n");
        this.dump(str, "\n  ");
        return str.toString();
    }

    public static RequestData createGraph(Node doc) {
        return new RequestData(doc, 2);
    }

    public static RequestData createGraph(InputStream in) {
        return RequestData.createGraph(in, false);
    }

    public static RequestData createGraph(InputStream in, boolean validate) {
        try {
            Document doc = GraphManager.createXmlDocument((InputStream)in, (boolean)validate);
            return RequestData.createGraph(doc);
        }
        catch (Throwable t) {
            throw new RuntimeException("DOM graph creation failed: " + t.getMessage());
        }
    }

    public static RequestData createGraph() {
        return new RequestData();
    }

    public void log(String s) {
        System.out.println("RequestData::" + s);
    }
}

