/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.websvc.jaxwsmodel.project;

import java.io.BufferedReader;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.URL;
import java.nio.charset.Charset;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.netbeans.api.project.Project;
import org.netbeans.api.project.ProjectManager;
import org.netbeans.api.project.ant.AntBuildExtender;
import org.netbeans.modules.websvc.api.jaxws.project.JaxWsBuildScriptExtensionProvider;
import org.netbeans.modules.websvc.api.jaxws.project.WSUtils;
import org.netbeans.modules.websvc.api.jaxws.project.WebServiceNotifier;
import org.netbeans.modules.websvc.api.jaxws.project.config.JaxWsModel;
import org.netbeans.modules.websvc.jaxwsmodel.project.EjbBuildScriptExtensionProvider;
import org.netbeans.modules.websvc.jaxwsmodel.project.TransformerUtils;
import org.netbeans.spi.project.support.ant.EditableProperties;
import org.netbeans.spi.project.ui.ProjectOpenedHook;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;

public class EjbJaxWsOpenHook
extends ProjectOpenedHook {
    private Project prj;
    private JaxWsModel.ServiceListener serviceListener;

    public EjbJaxWsOpenHook(Project prj) {
        block2: {
            this.prj = prj;
            try {
                Class.forName(WSUtils.class.getName());
            }
            catch (ClassNotFoundException e) {
                if ($assertionsDisabled) break block2;
                throw new AssertionError();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void projectOpened() {
        JaxWsModel jaxWsModel = (JaxWsModel)this.prj.getLookup().lookup(JaxWsModel.class);
        if (jaxWsModel != null) {
            this.serviceListener = new JaxWsModel.ServiceListener(){

                @Override
                public void serviceAdded(String name, String implementationClass) {
                    WebServiceNotifier servicesNotifier = (WebServiceNotifier)EjbJaxWsOpenHook.this.prj.getLookup().lookup(WebServiceNotifier.class);
                    if (servicesNotifier != null) {
                        servicesNotifier.serviceAdded(name, implementationClass);
                    }
                }

                @Override
                public void serviceRemoved(String name) {
                    WebServiceNotifier servicesNotifier = (WebServiceNotifier)EjbJaxWsOpenHook.this.prj.getLookup().lookup(WebServiceNotifier.class);
                    if (servicesNotifier != null) {
                        servicesNotifier.serviceRemoved(name);
                    }
                }
            };
            jaxWsModel.addServiceListener(this.serviceListener);
            JaxWsBuildScriptExtensionProvider extProvider = (JaxWsBuildScriptExtensionProvider)this.prj.getLookup().lookup(JaxWsBuildScriptExtensionProvider.class);
            AntBuildExtender ext = (AntBuildExtender)this.prj.getLookup().lookup(AntBuildExtender.class);
            if (extProvider != null && ext != null) {
                boolean buildScriptGenerated = false;
                FileObject jaxws_build = this.prj.getProjectDirectory().getFileObject("nbproject/jaxws-build.xml");
                FileObject jaxWsFo = jaxWsModel.getJaxWsFile();
                try {
                    boolean hasServiceOrClient = jaxWsFo != null && WSUtils.hasServiceOrClient(jaxWsFo);
                    AntBuildExtender.Extension extension = ext.getExtension("jaxws");
                    if (jaxws_build == null || extension == null) {
                        if (hasServiceOrClient) {
                            extProvider.addJaxWsExtension(ext);
                            ProjectManager.getDefault().saveProject(this.prj);
                            buildScriptGenerated = true;
                        }
                    } else if (!hasServiceOrClient) {
                        extProvider.removeJaxWsExtension(ext);
                        ProjectManager.getDefault().saveProject(this.prj);
                        buildScriptGenerated = true;
                    } else {
                        FileObject project_xml = this.prj.getProjectDirectory().getFileObject("nbproject/project.xml");
                        if (project_xml != null) {
                            this.removeCompileDependencies(this.prj, project_xml, ext);
                        }
                    }
                }
                catch (IOException ex) {
                    ex.printStackTrace();
                }
                if (jaxWsFo != null && !buildScriptGenerated) {
                    URL stylesheet = EjbJaxWsOpenHook.class.getResource(EjbBuildScriptExtensionProvider.JAX_WS_STYLESHEET_RESOURCE);
                    assert (stylesheet != null);
                    try {
                        String oldCrc32;
                        EditableProperties ep;
                        boolean needToCallTransformer = false;
                        String crc32 = null;
                        try (InputStream is = stylesheet.openStream();){
                            crc32 = TransformerUtils.getCrc32(is);
                        }
                        if (crc32 != null && (ep = WSUtils.getEditableProperties(this.prj, "nbproject/genfiles.properties")) != null && !crc32.equals(oldCrc32 = ep.getProperty("nbproject/jaxws-build.xml.stylesheet.CRC32"))) {
                            ep.setProperty("nbproject/jaxws-build.xml.stylesheet.CRC32", crc32);
                            WSUtils.storeEditableProperties(this.prj, "nbproject/genfiles.properties", ep);
                            needToCallTransformer = true;
                        }
                        if (needToCallTransformer) {
                            TransformerUtils.transformClients(this.prj.getProjectDirectory(), EjbBuildScriptExtensionProvider.JAX_WS_STYLESHEET_RESOURCE, true);
                        }
                    }
                    catch (IOException ex) {
                        Logger.getLogger(((Object)((Object)this)).getClass().getName()).log(Level.FINE, "failed to generate jaxws-build.xml from stylesheet", ex);
                    }
                }
            }
        }
    }

    protected void projectClosed() {
        JaxWsModel jaxWsModel = (JaxWsModel)this.prj.getLookup().lookup(JaxWsModel.class);
        if (jaxWsModel != null) {
            jaxWsModel.removeServiceListener(this.serviceListener);
        }
    }

    private void removeCompileDependencies(Project prj, FileObject project_xml, AntBuildExtender ext) throws IOException {
        BufferedReader br = new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(FileUtil.toFile((FileObject)project_xml)), Charset.forName("UTF-8")));
        String line = null;
        boolean isOldVersion = false;
        while ((line = br.readLine()) != null) {
            if (!line.contains("wsimport-client-compile") && !line.contains("wsimport-service-compile")) continue;
            isOldVersion = true;
            break;
        }
        br.close();
        if (isOldVersion) {
            TransformerUtils.transformClients(prj.getProjectDirectory(), EjbBuildScriptExtensionProvider.JAX_WS_STYLESHEET_RESOURCE);
            AntBuildExtender.Extension extension = ext.getExtension("jaxws");
            if (extension != null) {
                extension.removeDependency("-do-compile", "wsimport-client-compile");
                extension.removeDependency("-do-compile-single", "wsimport-client-compile");
                extension.removeDependency("-do-compile", "wsimport-service-compile");
                extension.removeDependency("-do-compile-single", "wsimport-service-compile");
                ProjectManager.getDefault().saveProject(prj);
            }
        }
    }
}

