/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.j2ee.persistence.jpqleditor;

import java.net.URL;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.SwingUtilities;
import org.netbeans.api.db.explorer.ConnectionManager;
import org.netbeans.api.db.explorer.DatabaseConnection;
import org.netbeans.api.progress.ProgressHandle;
import org.netbeans.modules.j2ee.persistence.api.PersistenceEnvironment;
import org.netbeans.modules.j2ee.persistence.dd.common.PersistenceUnit;
import org.netbeans.modules.j2ee.persistence.editor.JPAEditorUtil;
import org.netbeans.modules.j2ee.persistence.jpqleditor.JPQLExecutor;
import org.netbeans.modules.j2ee.persistence.jpqleditor.JPQLResult;
import org.netbeans.modules.j2ee.persistence.jpqleditor.Utils;
import org.netbeans.modules.j2ee.persistence.jpqleditor.ui.JPQLEditorTopComponent;
import org.netbeans.modules.j2ee.persistence.provider.Provider;
import org.netbeans.modules.j2ee.persistence.provider.ProviderUtil;
import org.netbeans.modules.j2ee.persistence.wizard.Util;
import org.openide.nodes.Node;
import org.openide.util.Exceptions;
import org.openide.util.Mutex;
import org.openide.util.NbBundle;

public class JPQLEditorController {
    private static final Logger logger = Logger.getLogger(JPQLEditorController.class.getName());
    private JPQLEditorTopComponent editorTopComponent = null;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void executeJPQLQuery(final String jpql, final PersistenceUnit pu, final PersistenceEnvironment pe, final int maxRowCount, final ProgressHandle ph) {
        ArrayList<URL> localResourcesURLList = new ArrayList<URL>();
        final HashMap<String, String> props = new HashMap<String, String>();
        final ArrayList<String> initialProblems = new ArrayList<String>();
        final DatabaseConnection dbconn = JPAEditorUtil.findDatabaseConnection(pu, pe.getProject());
        if (dbconn != null && dbconn.getJDBCConnection() == null) {
            Mutex.EVENT.readAccess((Mutex.Action)new Mutex.Action<DatabaseConnection>(){

                public DatabaseConnection run() {
                    ConnectionManager.getDefault().showConnectionDialog(dbconn);
                    return dbconn;
                }
            });
        }
        boolean containerManaged = Util.isSupportedJavaEEVersion(pe.getProject());
        final Provider provider = ProviderUtil.getProvider(pu.getProvider(), pe.getProject());
        if (containerManaged && provider != null) {
            Utils.substitutePersistenceProperties(pe, pu, dbconn, props);
        }
        final ClassLoader defClassLoader = Thread.currentThread().getContextClassLoader();
        try {
            ph.progress(10);
            ph.setDisplayName(NbBundle.getMessage(JPQLEditorTopComponent.class, (String)"queryExecutionPrepare"));
            initialProblems.addAll(Utils.collectClassPathURLs(pe, pu, dbconn, localResourcesURLList));
            ClassLoader customClassLoader = pe.getProjectClassLoader(localResourcesURLList.toArray(new URL[0]));
            Thread.currentThread().setContextClassLoader(customClassLoader);
            Thread t = new Thread(){

                @Override
                public void run() {
                    ClassLoader customClassLoader = Thread.currentThread().getContextClassLoader();
                    JPQLResult jpqlResult = new JPQLResult();
                    if (initialProblems.isEmpty()) {
                        JPQLExecutor queryExecutor = new JPQLExecutor();
                        try {
                            ph.progress(50);
                            ph.setDisplayName(NbBundle.getMessage(JPQLEditorTopComponent.class, (String)"queryExecutionPassControlToProvider"));
                            jpqlResult = queryExecutor.execute(jpql, pu, pe, props, provider, maxRowCount, ph, true);
                            ph.progress(80);
                            ph.setDisplayName(NbBundle.getMessage(JPQLEditorTopComponent.class, (String)"queryExecutionProcessResults"));
                        }
                        catch (Exception e) {
                            logger.log(Level.INFO, "Problem in executing JPQL", e);
                            jpqlResult.getExceptions().add(e);
                        }
                    } else {
                        StringBuilder sb = new StringBuilder();
                        for (String txt : initialProblems) {
                            sb.append(txt).append("\n");
                        }
                        jpqlResult.setQueryProblems(sb.toString());
                        jpqlResult.getExceptions().add(new Exception(sb.toString()));
                    }
                    final JPQLResult jpqlResult0 = jpqlResult;
                    final ClassLoader customClassLoader0 = customClassLoader;
                    SwingUtilities.invokeLater(new Runnable(){

                        @Override
                        public void run() {
                            JPQLEditorController.this.editorTopComponent.setResult(jpqlResult0, customClassLoader0);
                        }
                    });
                    Thread.currentThread().setContextClassLoader(defClassLoader);
                }
            };
            t.setContextClassLoader(customClassLoader);
            t.start();
        }
        catch (Exception ex) {
            Exceptions.printStackTrace((Throwable)ex);
        }
        finally {
            Thread.currentThread().setContextClassLoader(defClassLoader);
        }
    }

    public void init(Node[] activatedNodes) {
        this.editorTopComponent = new JPQLEditorTopComponent(this);
        this.editorTopComponent.open();
        this.editorTopComponent.requestActive();
        this.editorTopComponent.setFocusToEditor();
        this.editorTopComponent.fillPersistenceConfigurations(activatedNodes);
    }

    private static enum AnnotationAccessType {
        FIELD_TYPE,
        METHOD_TYPE;

    }
}

