/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.java.lsp.server.debugging;

import java.io.File;
import java.io.IOException;
import java.io.InputStreamReader;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.eclipse.lsp4j.debug.Source;
import org.netbeans.api.java.classpath.ClassPath;
import org.netbeans.modules.java.lsp.server.debugging.DebugAdapterContext;
import org.openide.filesystems.FileObject;

public final class NbSourceProvider {
    private static final Logger LOG = Logger.getLogger(NbSourceProvider.class.getName());
    private final Map<String, String> fqnToURI = Collections.synchronizedMap(new CacheMap());
    private final Map<String, Source> uriToSource = Collections.synchronizedMap(new CacheMap());
    private final DebugAdapterContext context;
    private ClassPath sources = ClassPath.EMPTY;

    NbSourceProvider(DebugAdapterContext context) {
        this.context = context;
    }

    public void setSourcePath(ClassPath sources) {
        this.sources = sources;
    }

    private String getSourceFileURI(String fqn, String relativePathName) {
        return this.fqnToURI.computeIfAbsent(fqn, name -> {
            FileObject source = this.sources.findResource(relativePathName);
            if (source != null) {
                return source.toURI().toString();
            }
            if (new File(relativePathName).exists()) {
                return relativePathName;
            }
            return "";
        });
    }

    public String getSourceContents(URI uri) {
        URL url;
        LOG.log(Level.INFO, "SourceContent {0}", uri);
        try {
            url = uri.toURL();
        }
        catch (MalformedURLException ex) {
            return ex.getLocalizedMessage();
        }
        StringBuilder content = new StringBuilder();
        char[] buffer = new char[8192];
        try (InputStreamReader r = new InputStreamReader(url.openConnection().getInputStream());){
            int l;
            while ((l = r.read(buffer)) > 0) {
                content.append(buffer, 0, l);
            }
        }
        catch (IOException ex) {
            return ex.getLocalizedMessage();
        }
        return content.toString();
    }

    public Source getSource(String sourceName, String debuggerURI) {
        return this.uriToSource.computeIfAbsent(debuggerURI, uri -> {
            Source source = new Source();
            source.setName(sourceName);
            source.setSourceReference(0);
            if (uri.startsWith("file:")) {
                String clientPath = this.context.getClientPath((String)uri);
                source.setPath(clientPath);
            } else {
                source.setPath((String)uri);
            }
            return source;
        });
    }

    public static Source convertDebuggerSourceToClient(String fullyQualifiedName, String sourceName, String relativeSourcePath, DebugAdapterContext context) throws URISyntaxException {
        String[] sourcePaths;
        NbSourceProvider sourceProvider = context.getSourceProvider();
        String uri = sourceProvider.getSourceFileURI(fullyQualifiedName, relativeSourcePath);
        if ((uri == null || uri.isEmpty()) && (sourcePaths = context.getSourcePaths()) != null) {
            for (String path : sourcePaths) {
                Path fullpath = Paths.get(path, relativeSourcePath);
                if (!Files.isRegularFile(fullpath, new LinkOption[0])) continue;
                uri = fullpath.toString();
                break;
            }
        }
        if (uri != null && !uri.isEmpty()) {
            return sourceProvider.getSource(sourceName, uri);
        }
        return null;
    }

    private static final class CacheMap<K, V>
    extends LinkedHashMap<K, V> {
        private static final int SIZE_LIMIT = 5000;

        private CacheMap() {
        }

        @Override
        protected boolean removeEldestEntry(Map.Entry<K, V> eldest) {
            return this.size() > 5000;
        }
    }
}

