/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.javascript2.editor.ui;

import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.util.Objects;
import javax.swing.AbstractButton;
import javax.swing.DefaultComboBoxModel;
import javax.swing.GroupLayout;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.LayoutStyle;
import javax.swing.event.ChangeListener;
import org.netbeans.api.project.Project;
import org.netbeans.modules.javascript2.editor.JsPreferences;
import org.netbeans.modules.javascript2.editor.JsVersion;
import org.netbeans.modules.javascript2.editor.ui.Bundle;
import org.netbeans.modules.javascript2.json.spi.support.JsonPreferences;
import org.netbeans.spi.project.ui.support.ProjectCustomizer;
import org.openide.awt.Mnemonics;
import org.openide.util.ChangeSupport;
import org.openide.util.HelpCtx;
import org.openide.util.NbBundle;

public class ECMAScriptPanel
extends JPanel
implements HelpCtx.Provider {
    public static final String IDENTIFIER = "ecma";
    private final ChangeSupport changeSupport = new ChangeSupport((Object)this);
    private final Project project;
    private final ProjectCustomizer.Category category;
    private JCheckBox allowJsonComments;
    private JComboBox cbVersion;
    private JLabel lVersion;

    public ECMAScriptPanel(Project project, ProjectCustomizer.Category category) {
        this.project = project;
        this.category = category;
        this.initComponents();
        this.initData();
    }

    private void initData() {
        DefaultComboBoxModel<DisplayVersion> model = new DefaultComboBoxModel<DisplayVersion>();
        for (JsVersion version : JsPreferences.getECMAScriptAvailableVersions()) {
            model.addElement(new DisplayVersion(version));
        }
        model.setSelectedItem(new DisplayVersion(JsPreferences.getECMAScriptVersion(this.project)));
        this.cbVersion.setModel(model);
        this.allowJsonComments.setSelected(JsonPreferences.forProject((Project)this.project).isCommentSupported());
        this.category.setStoreListener(e -> this.save());
    }

    private void initComponents() {
        this.cbVersion = new JComboBox();
        this.lVersion = new JLabel();
        this.allowJsonComments = new JCheckBox();
        this.cbVersion.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent evt) {
                ECMAScriptPanel.this.cbVersionItemStateChanged(evt);
            }
        });
        this.lVersion.setLabelFor(this.cbVersion);
        Mnemonics.setLocalizedText((JLabel)this.lVersion, (String)NbBundle.getMessage(ECMAScriptPanel.class, (String)"ECMAScriptPanel.lVersion.text"));
        Mnemonics.setLocalizedText((AbstractButton)this.allowJsonComments, (String)NbBundle.getMessage(ECMAScriptPanel.class, (String)"ECMAScriptPanel.allowJsonComments.text"));
        GroupLayout layout = new GroupLayout(this);
        this.setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addComponent(this.lVersion).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.cbVersion, 0, 265, Short.MAX_VALUE)).addGroup(layout.createSequentialGroup().addComponent(this.allowJsonComments).addGap(0, 0, Short.MAX_VALUE))).addContainerGap()));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.cbVersion, -2, -1, -2).addComponent(this.lVersion)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.allowJsonComments).addContainerGap(240, Short.MAX_VALUE)));
        this.allowJsonComments.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(ECMAScriptPanel.class, (String)"ECMAScriptPanel.allowJsonComments.ad"));
    }

    private void cbVersionItemStateChanged(ItemEvent evt) {
        this.changeSupport.fireChange();
    }

    public String getIdentifier() {
        return IDENTIFIER;
    }

    public String getDisplayName() {
        return Bundle.ECMAScriptPanel_name();
    }

    public void addChangeListener(ChangeListener listener) {
        this.changeSupport.addChangeListener(listener);
    }

    public void removeChangeListener(ChangeListener listener) {
        this.changeSupport.removeChangeListener(listener);
    }

    public void save() {
        JsPreferences.putECMAScriptVersion(this.project, ((DisplayVersion)this.cbVersion.getSelectedItem()).getVersion());
        JsonPreferences.forProject((Project)this.project).setCommentSupported(this.allowJsonComments.isSelected());
    }

    public HelpCtx getHelpCtx() {
        return new HelpCtx("org.netbeans.modules.javascript2.editor.ui.ECMAScriptPanel");
    }

    private static class DisplayVersion {
        private final JsVersion version;

        public DisplayVersion(JsVersion version) {
            this.version = version;
        }

        public JsVersion getVersion() {
            return this.version;
        }

        public String toString() {
            return this.version.getDisplayName();
        }

        public int hashCode() {
            int hash = 5;
            hash = 41 * hash + Objects.hashCode((Object)this.version);
            return hash;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            DisplayVersion other = (DisplayVersion)obj;
            return this.version == other.version;
        }
    }
}

