/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.gradle.javaee.api.ui.support;

import java.util.Collections;
import java.util.TreeSet;
import javax.swing.AbstractListModel;
import javax.swing.ComboBoxModel;
import org.netbeans.api.j2ee.core.Profile;
import org.netbeans.modules.j2ee.deployment.devmodules.api.Deployment;
import org.netbeans.modules.j2ee.deployment.devmodules.api.InstanceRemovedException;
import org.netbeans.modules.j2ee.deployment.devmodules.api.J2eeModule;
import org.netbeans.modules.j2ee.deployment.devmodules.api.J2eePlatform;

public final class JavaEEServerComboBoxModel
extends AbstractListModel<J2eePlatform>
implements ComboBoxModel<J2eePlatform> {
    final J2eePlatformModel[] platforms;
    J2eePlatformModel selectedPlatform;

    private JavaEEServerComboBoxModel(J2eeModule.Type moduleType, Profile javaeeProfile) {
        String[] serverInstanceIDs = Deployment.getDefault().getServerInstanceIDs(Collections.singleton(moduleType), javaeeProfile);
        TreeSet<J2eePlatformModel> order = new TreeSet<J2eePlatformModel>();
        for (String serverInstanceID : serverInstanceIDs) {
            try {
                order.add(new J2eePlatformModel(serverInstanceID));
            }
            catch (InstanceRemovedException instanceRemovedException) {
                // empty catch block
            }
        }
        this.platforms = order.toArray(new J2eePlatformModel[order.size()]);
    }

    public static ComboBoxModel<J2eePlatform> createJavaEEServerComboBoxModel(String selectedinstanceId, J2eeModule.Type moduleType, Profile javaeeProfile) {
        JavaEEServerComboBoxModel model = new JavaEEServerComboBoxModel(moduleType, javaeeProfile);
        model.setSelectedItem(selectedinstanceId);
        return model;
    }

    public static String getServerInstanceID(J2eePlatform platform) {
        String[] serverInstanceIDs;
        if (platform == null) {
            return null;
        }
        for (String serverInstanceID : serverInstanceIDs = Deployment.getDefault().getServerInstanceIDs()) {
            try {
                J2eePlatform p = Deployment.getDefault().getServerInstance(serverInstanceID).getJ2eePlatform();
                if (!platform.equals((Object)p)) continue;
                return serverInstanceID;
            }
            catch (InstanceRemovedException instanceRemovedException) {
                // empty catch block
            }
        }
        return null;
    }

    @Override
    public int getSize() {
        return this.platforms.length;
    }

    @Override
    public J2eePlatform getElementAt(int index) {
        return this.platforms[index].platform;
    }

    @Override
    public void setSelectedItem(Object anItem) {
        if (anItem != null) {
            for (J2eePlatformModel model : this.platforms) {
                if (!model.platform.equals(anItem)) continue;
                this.selectedPlatform = model;
                return;
            }
        }
        this.selectedPlatform = null;
    }

    void setSelectedItem(String anItem) {
        if (anItem != null) {
            for (J2eePlatformModel model : this.platforms) {
                if (!model.serverInstanceId.equals(anItem)) continue;
                this.selectedPlatform = model;
                break;
            }
        } else {
            this.selectedPlatform = null;
        }
    }

    public J2eePlatform getSelectedItem() {
        return this.selectedPlatform != null ? this.selectedPlatform.platform : null;
    }

    private static class J2eePlatformModel
    implements Comparable<J2eePlatformModel> {
        final String serverInstanceId;
        final J2eePlatform platform;

        public J2eePlatformModel(String serverInstanceId) throws InstanceRemovedException {
            this.serverInstanceId = serverInstanceId;
            this.platform = Deployment.getDefault().getServerInstance(serverInstanceId).getJ2eePlatform();
        }

        public String toString() {
            String ret = this.platform.getDisplayName();
            return ret != null ? ret : "";
        }

        @Override
        public int compareTo(J2eePlatformModel o) {
            return this.toString().compareTo(o.toString());
        }
    }
}

