/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.js.parser.ir;

import com.oracle.js.parser.ir.Block;
import com.oracle.js.parser.ir.Expression;
import com.oracle.js.parser.ir.LexicalContext;
import com.oracle.js.parser.ir.Node;
import com.oracle.js.parser.ir.Statement;
import com.oracle.js.parser.ir.visitor.NodeVisitor;
import com.oracle.js.parser.ir.visitor.TranslatorNodeVisitor;

public final class IfNode
extends Statement {
    private final Expression test;
    private final Block pass;
    private final Block fail;

    public IfNode(int n, long l, int n2, Expression expression, Block block, Block block2) {
        super(n, l, n2);
        this.test = expression;
        this.pass = block;
        this.fail = block2;
    }

    private IfNode(IfNode ifNode, Expression expression, Block block, Block block2) {
        super(ifNode);
        this.test = expression;
        this.pass = block;
        this.fail = block2;
    }

    @Override
    public boolean isTerminal() {
        return this.pass.isTerminal() && this.fail != null && this.fail.isTerminal();
    }

    @Override
    public Node accept(NodeVisitor<? extends LexicalContext> nodeVisitor) {
        if (nodeVisitor.enterIfNode(this)) {
            return nodeVisitor.leaveIfNode(this.setTest((Expression)this.test.accept(nodeVisitor)).setPass((Block)this.pass.accept(nodeVisitor)).setFail(this.fail == null ? null : (Block)this.fail.accept(nodeVisitor)));
        }
        return this;
    }

    @Override
    public <R> R accept(TranslatorNodeVisitor<? extends LexicalContext, R> translatorNodeVisitor) {
        return translatorNodeVisitor.enterIfNode(this);
    }

    @Override
    public void toString(StringBuilder stringBuilder, boolean bl) {
        stringBuilder.append("if (");
        this.test.toString(stringBuilder, bl);
        stringBuilder.append(')');
    }

    public Block getFail() {
        return this.fail;
    }

    private IfNode setFail(Block block) {
        if (this.fail == block) {
            return this;
        }
        return new IfNode(this, this.test, this.pass, block);
    }

    public Block getPass() {
        return this.pass;
    }

    private IfNode setPass(Block block) {
        if (this.pass == block) {
            return this;
        }
        return new IfNode(this, this.test, block, this.fail);
    }

    public Expression getTest() {
        return this.test;
    }

    public IfNode setTest(Expression expression) {
        if (this.test == expression) {
            return this;
        }
        return new IfNode(this, expression, this.pass, this.fail);
    }
}

