/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.regex.tregex.nodes.dfa;

import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.frame.VirtualFrame;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.regex.RegexBodyNode;
import com.oracle.truffle.regex.RegexLanguage;
import com.oracle.truffle.regex.RegexProfile;
import com.oracle.truffle.regex.RegexSource;
import com.oracle.truffle.regex.result.LazyCaptureGroupsResult;
import com.oracle.truffle.regex.tregex.nodes.TRegexExecutorEntryNode;

public class TRegexLazyCaptureGroupsRootNode
extends RegexBodyNode {
    @Node.Child
    private TRegexExecutorEntryNode entryNode;
    private final RegexProfile.TracksRegexProfile profiler;

    public TRegexLazyCaptureGroupsRootNode(RegexLanguage language, RegexSource source, TRegexExecutorEntryNode captureGroupNode, RegexProfile.TracksRegexProfile profiler) {
        super(language, source);
        this.entryNode = (TRegexExecutorEntryNode)this.insert(captureGroupNode);
        this.profiler = profiler;
    }

    public final Void execute(VirtualFrame frame) {
        Object[] args = frame.getArguments();
        assert (args.length == 3);
        LazyCaptureGroupsResult receiver = (LazyCaptureGroupsResult)args[0];
        int startIndex = (Integer)args[1];
        int max = (Integer)args[2];
        int[] result = (int[])this.entryNode.execute(receiver.getInput(), receiver.getFromIndex(), startIndex, max);
        if (CompilerDirectives.inInterpreter()) {
            RegexProfile profile = this.profiler.getRegexProfile();
            profile.profileCaptureGroupAccess(result[1] - result[0], result[1] - (receiver.getFromIndex() + 1));
        }
        receiver.setResult(result);
        return null;
    }

    @Override
    protected String getEngineLabel() {
        return "TRegex cg";
    }
}

