/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.regex;

import com.oracle.truffle.api.TruffleException;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.regex.RegexSource;

public final class UnsupportedRegexException
extends RuntimeException
implements TruffleException {
    private String reason;
    private RegexSource regexSrc;

    public UnsupportedRegexException(String reason) {
        this.reason = reason;
    }

    public UnsupportedRegexException(String reason, Throwable cause) {
        super(cause);
        this.reason = reason;
    }

    public UnsupportedRegexException(String reason, RegexSource regexSrc) {
        this(reason);
        this.regexSrc = regexSrc;
    }

    public RegexSource getRegex() {
        return this.regexSrc;
    }

    public void setRegex(RegexSource regexSrc) {
        this.regexSrc = regexSrc;
    }

    public String getReason() {
        return this.reason;
    }

    public void setReason(String reason) {
        this.reason = reason;
    }

    @Override
    public String getMessage() {
        StringBuilder sb = new StringBuilder();
        sb.append("Unsupported regular expression");
        if (this.regexSrc != null) {
            sb.append(" /");
            sb.append(this.regexSrc.getPattern());
            sb.append("/");
            sb.append(this.regexSrc.getFlags());
        }
        if (this.reason != null) {
            sb.append(": ");
            sb.append(this.reason);
        }
        return sb.toString();
    }

    @Override
    public Throwable fillInStackTrace() {
        return this;
    }

    public boolean isSyntaxError() {
        return true;
    }

    public Node getLocation() {
        return null;
    }
}

