/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.polyglot;

import com.oracle.truffle.api.CallTarget;
import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.Scope;
import com.oracle.truffle.api.Truffle;
import com.oracle.truffle.api.TruffleException;
import com.oracle.truffle.api.TruffleFile;
import com.oracle.truffle.api.TruffleLanguage;
import com.oracle.truffle.api.TruffleOptions;
import com.oracle.truffle.api.frame.VirtualFrame;
import com.oracle.truffle.api.interop.InteropLibrary;
import com.oracle.truffle.api.interop.InvalidArrayIndexException;
import com.oracle.truffle.api.interop.TruffleObject;
import com.oracle.truffle.api.interop.UnsupportedMessageException;
import com.oracle.truffle.api.library.ExportLibrary;
import com.oracle.truffle.api.library.ExportMessage;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.nodes.RootNode;
import com.oracle.truffle.polyglot.EngineAccessor;
import com.oracle.truffle.polyglot.FileSystems;
import com.oracle.truffle.polyglot.HostClassLoader;
import com.oracle.truffle.polyglot.HostObject;
import com.oracle.truffle.polyglot.PolyglotLanguageContext;
import com.oracle.truffle.polyglot.ToHostNode;
import java.io.IOException;
import java.lang.reflect.Array;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.function.Predicate;

class HostLanguage
extends TruffleLanguage<HostContext> {
    HostLanguage() {
    }

    @Override
    @CompilerDirectives.TruffleBoundary
    protected Object getLanguageView(HostContext context, Object value) {
        Object wrapped;
        if (value instanceof TruffleObject) {
            InteropLibrary lib = InteropLibrary.getFactory().getUncached(value);
            try {
                assert (!lib.hasLanguage(value) || lib.getLanguage(value) != HostLanguage.class);
            }
            catch (UnsupportedMessageException e) {
                throw CompilerDirectives.shouldNotReachHere(e);
            }
            wrapped = ToHostNode.convertToObject(value, context.internalContext, lib);
        } else {
            wrapped = value;
        }
        return HostObject.forObject(wrapped, context.internalContext);
    }

    @Override
    protected CallTarget parse(TruffleLanguage.ParsingRequest request) throws Exception {
        final String sourceString = request.getSource().getCharacters().toString();
        return Truffle.getRuntime().createCallTarget(new RootNode(this){
            @CompilerDirectives.CompilationFinal
            TruffleLanguage.ContextReference<HostContext> contextRef;

            @Override
            public Object execute(VirtualFrame frame) {
                if (this.contextRef == null) {
                    CompilerDirectives.transferToInterpreterAndInvalidate();
                    this.contextRef = this.lookupContextReference(HostLanguage.class);
                }
                HostContext context = this.contextRef.get();
                Class<?> allTarget = context.findClass(sourceString);
                return context.internalContext.toGuestValue(allTarget);
            }
        });
    }

    @Override
    protected void disposeContext(HostContext context) {
        HostClassLoader cl = context.classloader;
        if (cl != null) {
            try {
                cl.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
            context.classloader = null;
        }
        super.disposeContext(context);
    }

    @Override
    protected HostContext createContext(TruffleLanguage.Env env) {
        return new HostContext();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected Iterable<Scope> findTopScopes(HostContext context) {
        Set<Scope> topScopes = context.topScopes;
        if (topScopes == null) {
            HostContext hostContext = context;
            synchronized (hostContext) {
                topScopes = context.topScopes;
                if (topScopes == null) {
                    topScopes = Collections.singleton(Scope.newBuilder("Hosting top scope", new TopScopeObject(context)).build());
                    context.topScopes = topScopes;
                }
            }
        }
        return topScopes;
    }

    @Override
    protected boolean isThreadAccessAllowed(Thread thread, boolean singleThreaded) {
        return true;
    }

    @ExportLibrary(value=InteropLibrary.class)
    static final class ClassNamesObject
    implements TruffleObject {
        final ArrayList<String> names;

        private ClassNamesObject(Set<String> names) {
            this.names = new ArrayList<String>(names);
        }

        @ExportMessage
        boolean hasArrayElements() {
            return true;
        }

        @ExportMessage
        @CompilerDirectives.TruffleBoundary
        Object readArrayElement(long index) throws InvalidArrayIndexException {
            if (index < 0L || index > Integer.MAX_VALUE) {
                throw InvalidArrayIndexException.create(index);
            }
            try {
                return this.names.get((int)index);
            }
            catch (IndexOutOfBoundsException ioob) {
                throw InvalidArrayIndexException.create(index);
            }
        }

        @ExportMessage
        @CompilerDirectives.TruffleBoundary
        long getArraySize() {
            return this.names.size();
        }

        @ExportMessage
        boolean isArrayElementReadable(long index) {
            return index >= 0L && index < this.getArraySize();
        }
    }

    @ExportLibrary(value=InteropLibrary.class)
    static final class TopScopeObject
    implements TruffleObject {
        private final HostContext context;

        private TopScopeObject(HostContext context) {
            this.context = context;
        }

        @ExportMessage
        boolean hasMembers() {
            return true;
        }

        @ExportMessage
        @CompilerDirectives.TruffleBoundary
        Object getMembers(boolean includeInternal) {
            return new ClassNamesObject(this.context.classCache.keySet());
        }

        @ExportMessage
        @CompilerDirectives.TruffleBoundary
        boolean isMemberReadable(String member) {
            return this.context.findClass(member) != null;
        }

        @ExportMessage
        @CompilerDirectives.TruffleBoundary
        Object readMember(String member) {
            return HostObject.forStaticClass(this.context.findClass(member), this.context.internalContext);
        }
    }

    private static class HostLanguageException
    extends RuntimeException
    implements TruffleException {
        HostLanguageException(String message) {
            super(message);
        }

        @Override
        public Node getLocation() {
            return null;
        }
    }

    static final class HostContext {
        volatile PolyglotLanguageContext internalContext;
        final Map<String, Class<?>> classCache = new HashMap();
        private volatile Iterable<Scope> topScopes;
        private volatile HostClassLoader classloader;

        HostContext() {
        }

        @CompilerDirectives.TruffleBoundary
        Class<?> findClass(String className) {
            this.checkHostAccessAllowed();
            Class<?> loadedClass = this.classCache.get(className);
            if (loadedClass == null) {
                loadedClass = this.findClassImpl(className);
                this.classCache.put(className, loadedClass);
            }
            assert (loadedClass != null);
            return loadedClass;
        }

        private void checkHostAccessAllowed() {
            if (!this.internalContext.context.config.hostLookupAllowed) {
                throw new HostLanguageException(String.format("Host class access is not allowed.", new Object[0]));
            }
        }

        private HostClassLoader getClassloader() {
            if (this.classloader == null) {
                ClassLoader parentClassLoader = this.internalContext.context.config.hostClassLoader != null ? this.internalContext.context.config.hostClassLoader : this.internalContext.getEngine().contextClassLoader;
                this.classloader = new HostClassLoader(this, parentClassLoader);
            }
            return this.classloader;
        }

        private Class<?> findClassImpl(String className) {
            this.validateClass(className);
            if (className.endsWith("[]")) {
                Class<?> componentType = this.findClass(className.substring(0, className.length() - 2));
                return Array.newInstance(componentType, 0).getClass();
            }
            Class<?> primitiveType = HostContext.getPrimitiveTypeByName(className);
            if (primitiveType != null) {
                return primitiveType;
            }
            try {
                HostClassLoader classLoader = this.getClassloader();
                Class<?> foundClass = classLoader.loadClass(className);
                Object currentModule = EngineAccessor.JDKSERVICES.getUnnamedModule(classLoader);
                if (EngineAccessor.JDKSERVICES.verifyModuleVisibility(currentModule, foundClass)) {
                    return foundClass;
                }
                throw new HostLanguageException(String.format("Access to host class %s is not allowed or does not exist.", className));
            }
            catch (ClassNotFoundException e) {
                throw new HostLanguageException(String.format("Access to host class %s is not allowed or does not exist.", className));
            }
        }

        void validateClass(String className) {
            Predicate<String> classFilter = this.internalContext.context.config.classFilter;
            if (classFilter != null && !classFilter.test(className)) {
                throw new HostLanguageException(String.format("Access to host class %s is not allowed.", className));
            }
        }

        private static Class<?> getPrimitiveTypeByName(String className) {
            switch (className) {
                case "boolean": {
                    return Boolean.TYPE;
                }
                case "byte": {
                    return Byte.TYPE;
                }
                case "char": {
                    return Character.TYPE;
                }
                case "double": {
                    return Double.TYPE;
                }
                case "float": {
                    return Float.TYPE;
                }
                case "int": {
                    return Integer.TYPE;
                }
                case "long": {
                    return Long.TYPE;
                }
                case "short": {
                    return Short.TYPE;
                }
            }
            return null;
        }

        public void addToHostClasspath(TruffleFile classpathEntry) {
            this.checkHostAccessAllowed();
            if (TruffleOptions.AOT) {
                throw new HostLanguageException(String.format("Cannot add classpath entry %s in native mode.", classpathEntry.getName()));
            }
            if (!this.internalContext.context.config.hostClassLoadingAllowed) {
                throw new HostLanguageException(String.format("Host class loading is not allowed.", new Object[0]));
            }
            if (FileSystems.hasNoIOFileSystem(classpathEntry)) {
                throw new HostLanguageException("Host class loading is disabled without IO permissions.");
            }
            this.getClassloader().addClasspathRoot(classpathEntry);
        }
    }
}

