/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.api.debug;

import com.oracle.truffle.api.debug.DebugException;
import com.oracle.truffle.api.debug.DebugScope;
import com.oracle.truffle.api.debug.DebugValue;
import com.oracle.truffle.api.debug.DebuggerSession;
import com.oracle.truffle.api.interop.InteropLibrary;
import com.oracle.truffle.api.interop.UnsupportedMessageException;
import com.oracle.truffle.api.nodes.LanguageInfo;
import java.util.AbstractCollection;
import java.util.Iterator;
import java.util.NoSuchElementException;

final class ValuePropertiesCollection
extends AbstractCollection<DebugValue> {
    static final InteropLibrary INTEROP = InteropLibrary.getFactory().getUncached();
    private final DebuggerSession session;
    private final LanguageInfo language;
    private final Object object;
    private final DebugScope scope;
    private final Object keys;

    ValuePropertiesCollection(DebuggerSession session, LanguageInfo language, Object object, Object keys, DebugScope scope) {
        this.session = session;
        this.language = language;
        this.object = object;
        this.keys = keys;
        this.scope = scope;
    }

    @Override
    public Iterator<DebugValue> iterator() {
        return new PropertiesIterator();
    }

    @Override
    public int size() {
        try {
            return (int)INTEROP.getArraySize(this.keys);
        }
        catch (UnsupportedMessageException e) {
            return 0;
        }
    }

    DebugValue get(String name) {
        if (INTEROP.isMemberExisting(this.object, name)) {
            return new DebugValue.ObjectMemberValue(this.session, this.language, this.scope, this.object, name);
        }
        return null;
    }

    private final class PropertiesIterator
    implements Iterator<DebugValue> {
        private long currentIndex;

        private PropertiesIterator() {
        }

        @Override
        public boolean hasNext() {
            return INTEROP.isArrayElementExisting(ValuePropertiesCollection.this.keys, this.currentIndex);
        }

        @Override
        public DebugValue next() {
            if (!this.hasNext()) {
                throw new NoSuchElementException();
            }
            try {
                Object key = INTEROP.readArrayElement(ValuePropertiesCollection.this.keys, this.currentIndex);
                String member = INTEROP.asString(key);
                ++this.currentIndex;
                return new DebugValue.ObjectMemberValue(ValuePropertiesCollection.this.session, ValuePropertiesCollection.this.language, ValuePropertiesCollection.this.scope, ValuePropertiesCollection.this.object, member);
            }
            catch (ThreadDeath td) {
                throw td;
            }
            catch (Throwable ex) {
                throw new DebugException(ValuePropertiesCollection.this.session, ex, ValuePropertiesCollection.this.language, null, true, null);
            }
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException("remove not supported.");
        }
    }
}

