/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.api;

import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.nodes.ExplodeLoop;
import com.oracle.truffle.api.nodes.InvalidAssumptionException;

public interface Assumption {
    public void check() throws InvalidAssumptionException;

    public boolean isValid();

    public void invalidate();

    default public void invalidate(String message) {
        this.invalidate();
    }

    public String getName();

    public static boolean isValidAssumption(Assumption assumption) {
        return assumption != null && assumption.isValid();
    }

    @ExplodeLoop
    public static boolean isValidAssumption(Assumption[] assumptions) {
        CompilerDirectives.isPartialEvaluationConstant(assumptions);
        if (assumptions == null) {
            return false;
        }
        for (Assumption assumption : assumptions) {
            if (Assumption.isValidAssumption(assumption)) continue;
            return false;
        }
        return true;
    }
}

