/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.websvc.rest.wizard;

import com.sun.jersey.core.impl.provider.entity.Inflector;
import com.sun.source.tree.AnnotationTree;
import com.sun.source.tree.ClassTree;
import com.sun.source.tree.CompilationUnitTree;
import com.sun.source.tree.ExpressionTree;
import com.sun.source.tree.MethodTree;
import com.sun.source.tree.ModifiersTree;
import com.sun.source.tree.Tree;
import com.sun.source.tree.VariableTree;
import java.awt.Component;
import java.awt.Container;
import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.StringTokenizer;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.lang.model.element.AnnotationMirror;
import javax.lang.model.element.Element;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.Modifier;
import javax.lang.model.element.Name;
import javax.lang.model.element.TypeElement;
import javax.lang.model.element.VariableElement;
import javax.lang.model.type.DeclaredType;
import javax.lang.model.type.TypeKind;
import javax.lang.model.type.TypeMirror;
import javax.lang.model.util.ElementFilter;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.SwingUtilities;
import org.netbeans.api.java.classpath.ClassPath;
import org.netbeans.api.java.source.ClasspathInfo;
import org.netbeans.api.java.source.CompilationController;
import org.netbeans.api.java.source.JavaSource;
import org.netbeans.api.java.source.ModificationResult;
import org.netbeans.api.java.source.Task;
import org.netbeans.api.java.source.TreeMaker;
import org.netbeans.api.java.source.TreeUtilities;
import org.netbeans.api.java.source.WorkingCopy;
import org.netbeans.api.java.source.ui.ScanDialog;
import org.netbeans.api.project.FileOwnerQuery;
import org.netbeans.api.project.Project;
import org.netbeans.api.project.ProjectUtils;
import org.netbeans.api.project.SourceGroup;
import org.netbeans.api.project.Sources;
import org.netbeans.modules.j2ee.core.api.support.java.GenerationUtils;
import org.netbeans.modules.j2ee.metadata.model.api.MetadataModel;
import org.netbeans.modules.j2ee.metadata.model.api.MetadataModelAction;
import org.netbeans.modules.j2ee.persistence.api.EntityClassScope;
import org.netbeans.modules.j2ee.persistence.api.metadata.orm.Entity;
import org.netbeans.modules.j2ee.persistence.api.metadata.orm.EntityMappingsMetadata;
import org.netbeans.modules.j2ee.persistence.wizard.fromdb.FacadeGenerator;
import org.netbeans.modules.j2ee.persistence.wizard.fromdb.FacadeGeneratorProvider;
import org.netbeans.modules.web.api.webmodule.WebModule;
import org.netbeans.modules.websvc.api.support.java.SourceUtils;
import org.netbeans.modules.websvc.rest.codegen.model.EntityClassInfo;
import org.netbeans.modules.websvc.rest.codegen.model.EntityResourceBeanModel;
import org.netbeans.modules.websvc.rest.codegen.model.TypeUtil;
import org.netbeans.modules.websvc.rest.spi.MiscUtilities;
import org.netbeans.modules.websvc.rest.support.JavaSourceHelper;
import org.netbeans.modules.websvc.rest.support.PersistenceHelper;
import org.netbeans.modules.websvc.rest.support.SourceGroupSupport;
import org.netbeans.modules.websvc.rest.wizard.fromdb.EjbFacadeGeneratorProvider;
import org.openide.WizardDescriptor;
import org.openide.filesystems.FileObject;
import org.openide.util.Lookup;
import org.openide.util.NbBundle;
import org.openide.util.Utilities;

public class Util {
    public static final String XMLROOT_ANNOTATION = "javax.xml.bind.annotation.XmlRootElement";
    public static final String XML_TRANSIENT = "javax.xml.bind.annotation.XmlTransient";
    public static final String TYPE_DOC_ROOT = "doc_root";
    static final String WIZARD_PANEL_CONTENT_DATA = "WizardPanel_contentData";
    static final String WIZARD_PANEL_CONTENT_SELECTED_INDEX = "WizardPanel_contentSelectedIndex";
    private static final FacadeGeneratorProvider FACADE_GENERATOR = (FacadeGeneratorProvider)Lookup.getDefault().lookup(FacadeGeneratorProvider.class);

    public static void changeLabelInComponent(JComponent component, String oldLabel, String newLabel) {
        JLabel label = Util.findLabel(component, oldLabel);
        if (label != null) {
            label.setText(newLabel);
        }
    }

    public static void hideLabelAndLabelFor(JComponent component, String lab) {
        JLabel label = Util.findLabel(component, lab);
        if (label != null) {
            label.setVisible(false);
            Component c = label.getLabelFor();
            if (c != null) {
                c.setVisible(false);
            }
        }
    }

    public static void getAllComponents(Component[] components, Collection<Component> allComponents) {
        for (int i = 0; i < components.length; ++i) {
            if (components[i] == null) continue;
            allComponents.add(components[i]);
            if (((Container)components[i]).getComponentCount() == 0) continue;
            Util.getAllComponents(((Container)components[i]).getComponents(), allComponents);
        }
    }

    public static JLabel findLabel(JComponent comp, String labelText) {
        ArrayList<Component> allComponents = new ArrayList<Component>();
        Util.getAllComponents(comp.getComponents(), allComponents);
        for (Component c : allComponents) {
            JLabel label;
            if (!(c instanceof JLabel) || !(label = (JLabel)c).getText().equals(labelText)) continue;
            return label;
        }
        return null;
    }

    public static String getClassName(String fqClassName) {
        int dot = fqClassName.lastIndexOf(".");
        if (dot >= 0 && dot < fqClassName.length() - 1) {
            return fqClassName.substring(dot + 1);
        }
        return fqClassName;
    }

    public static String getPackageName(String fqClassName) {
        int dot = fqClassName.lastIndexOf(".");
        if (dot >= 0 && dot < fqClassName.length() - 1) {
            return fqClassName.substring(0, dot);
        }
        return "";
    }

    public static SourceGroup getClassSourceGroup(Project project, String fqClassName) {
        SourceGroup[] sourceGroups;
        String classFile = fqClassName.replace('.', '/') + ".java";
        for (SourceGroup sourceGroup : sourceGroups = SourceGroupSupport.getJavaSourceGroups(project)) {
            FileObject classFO = sourceGroup.getRootFolder().getFileObject(classFile);
            if (classFO == null) continue;
            return sourceGroup;
        }
        return null;
    }

    public static void mergeSteps(WizardDescriptor wizard, WizardDescriptor.Panel[] panels, String[] steps) {
        int offset;
        String[] beforeSteps;
        Object prop = wizard.getProperty(WIZARD_PANEL_CONTENT_DATA);
        if (prop instanceof String[]) {
            beforeSteps = (String[])prop;
            offset = beforeSteps.length;
            if (offset > 0 && "...".equals(beforeSteps[offset - 1])) {
                --offset;
            }
        } else {
            beforeSteps = null;
            offset = 0;
        }
        String[] resultSteps = new String[offset + panels.length];
        for (int i = 0; i < offset; ++i) {
            resultSteps[i] = beforeSteps[i];
        }
        Util.setSteps(panels, steps, resultSteps, offset);
    }

    private static void setSteps(WizardDescriptor.Panel[] panels, String[] steps, String[] resultSteps, int offset) {
        int n = steps == null ? 0 : steps.length;
        for (int i = 0; i < panels.length; ++i) {
            String step;
            JComponent component = (JComponent)panels[i].getComponent();
            String string = step = i < n ? steps[i] : null;
            if (step == null) {
                step = component.getName();
            }
            component.putClientProperty(WIZARD_PANEL_CONTENT_DATA, resultSteps);
            component.putClientProperty(WIZARD_PANEL_CONTENT_SELECTED_INDEX, i);
            component.getAccessibleContext().setAccessibleDescription(step);
            resultSteps[i + offset] = step;
        }
    }

    public static void setSteps(WizardDescriptor.Panel[] panels, String[] steps) {
        Util.setSteps(panels, steps, steps, 0);
    }

    public static String lowerFirstChar(String name) {
        if (name.length() == 0) {
            return name;
        }
        StringBuilder sb = new StringBuilder(name);
        sb.setCharAt(0, Character.toLowerCase(name.charAt(0)));
        return sb.toString();
    }

    public static String upperFirstChar(String name) {
        if (name.length() == 0) {
            return name;
        }
        StringBuilder sb = new StringBuilder(name);
        sb.setCharAt(0, Character.toUpperCase(name.charAt(0)));
        return sb.toString();
    }

    public static String deriveResourceClassName(String resourceName) {
        return Util.upperFirstChar(resourceName) + "Resource";
    }

    public static String deriveUri(String resourceName, String currentUri) {
        if (resourceName.length() == 0 || currentUri == null || currentUri.length() == 0 || currentUri.charAt(0) != '/') {
            return currentUri;
        }
        resourceName = Util.lowerFirstChar(resourceName);
        resourceName = Util.pluralize(resourceName);
        String root = currentUri;
        String params = null;
        int lastIndex = currentUri.indexOf(123);
        if (lastIndex > -1) {
            params = root.substring(lastIndex - 1);
            if ((root = root.substring(0, lastIndex - 1)).length() == 0) {
                return currentUri;
            }
        }
        if ((lastIndex = root.lastIndexOf(47)) == -1) {
            return currentUri;
        }
        root = root.substring(0, lastIndex);
        String ret = root + "/" + resourceName;
        if (params != null) {
            ret = ret + params;
        }
        return ret;
    }

    public static String deriveContainerClassName(String resourceName) {
        return Util.deriveResourceClassName(Inflector.getInstance().pluralize(resourceName));
    }

    public static String pluralize(String name) {
        String pluralName = Inflector.getInstance().pluralize(name);
        if (name.equals(pluralName)) {
            return name + "Collection";
        }
        return pluralName;
    }

    public static String[] ensureTypes(String[] types) {
        if (types == null || types.length == 0 || types[0].length() == 0) {
            types = new String[]{String.class.getName()};
        }
        return types;
    }

    public static SourceGroup[] getSourceGroups(Project project) {
        SourceGroup[] sourceGroups = null;
        Sources sources = ProjectUtils.getSources((Project)project);
        SourceGroup[] docRoot = sources.getSourceGroups(TYPE_DOC_ROOT);
        SourceGroup[] srcRoots = SourceGroupSupport.getJavaSourceGroups(project);
        if (docRoot != null && srcRoots != null) {
            sourceGroups = new SourceGroup[docRoot.length + srcRoots.length];
            System.arraycopy(docRoot, 0, sourceGroups, 0, docRoot.length);
            System.arraycopy(srcRoots, 0, sourceGroups, docRoot.length, srcRoots.length);
        }
        if (sourceGroups == null || sourceGroups.length == 0) {
            sourceGroups = sources.getSourceGroups("generic");
        }
        return sourceGroups;
    }

    public static Class getType(Project project, String typeName) {
        List<ClassPath> classPaths = SourceGroupSupport.gerClassPath(project);
        for (ClassPath cp : classPaths) {
            try {
                Class ret = Util.getPrimitiveType(typeName);
                if (ret != null) {
                    return ret;
                }
                ClassLoader cl = cp.getClassLoader(true);
                ret = Util.getGenericRawType(typeName, cl);
                if (ret != null) {
                    return ret;
                }
                if (cl == null) continue;
                return cl.loadClass(typeName);
            }
            catch (ClassNotFoundException classNotFoundException) {
            }
        }
        return null;
    }

    public static Class<?> getPrimitiveType(String typeName) {
        return (Class)Lazy.primitiveTypes.get(typeName);
    }

    public static Class getGenericRawType(String typeName, ClassLoader loader) {
        int i = typeName.indexOf(60);
        if (i < 1) {
            return null;
        }
        String raw = typeName.substring(0, i);
        try {
            return loader.loadClass(raw);
        }
        catch (ClassNotFoundException ex) {
            Logger.global.log(Level.INFO, "", ex);
            return null;
        }
    }

    public static boolean isValidPackageName(String packageName) {
        String[] segments;
        if (packageName == null || packageName.endsWith(".")) {
            return false;
        }
        for (String s : segments = packageName.split("\\.")) {
            if (Utilities.isJavaIdentifier((String)s)) continue;
            return false;
        }
        return true;
    }

    public static ClasspathInfo getClasspathInfo(Project p) {
        FileObject fileObject = p.getProjectDirectory();
        return ClasspathInfo.create((ClassPath)ClassPath.getClassPath((FileObject)fileObject, (String)"classpath/boot"), (ClassPath)ClassPath.getClassPath((FileObject)fileObject, (String)"classpath/compile"), (ClassPath)ClassPath.getClassPath((FileObject)fileObject, (String)"classpath/source"));
    }

    public static PersistenceHelper.PersistenceUnit getPersistenceUnit(WizardDescriptor wizard, Project project) {
        PersistenceHelper.PersistenceUnit pu = (PersistenceHelper.PersistenceUnit)wizard.getProperty("PersistenceUnit");
        if (pu == null) {
            pu = new PersistenceHelper(project).getPersistenceUnit();
            wizard.putProperty("PersistenceUnit", (Object)pu);
        }
        return pu;
    }

    public static boolean isValidUri(String uri) {
        StringTokenizer segments = new StringTokenizer(uri, "/ ");
        HashSet<String> uriParts = new HashSet<String>();
        while (segments.hasMoreTokens()) {
            String segment = segments.nextToken();
            if (segment.startsWith("{")) {
                if (segment.length() > 2 && segment.endsWith("}")) {
                    String uriPart = segment.substring(1, segment.length() - 1);
                    if (!Utilities.isJavaIdentifier((String)uriPart)) {
                        return false;
                    }
                    if (uriParts.contains(uriPart)) {
                        return false;
                    }
                    uriParts.add(uriPart);
                    continue;
                }
                return false;
            }
            if (!segment.contains("{") && !segment.contains("}")) continue;
            return false;
        }
        return true;
    }

    public static boolean isCDIEnabled(FileObject fileObject) {
        Project project = FileOwnerQuery.getOwner((FileObject)fileObject);
        if (project != null) {
            return Util.isCDIEnabled(project);
        }
        return false;
    }

    public static boolean isCDIEnabled(Project project) {
        WebModule wm = WebModule.getWebModule((FileObject)project.getProjectDirectory());
        if (wm != null) {
            if (!MiscUtilities.isJavaEE6AndHigher((Project)project)) {
                return false;
            }
            FileObject confRoot = wm.getWebInf();
            if (confRoot != null && confRoot.getFileObject("beans.xml") != null) {
                return true;
            }
        }
        return false;
    }

    public static void generatePrimaryKeyMethod(FileObject restResourceClass, String entityFqn, EntityResourceBeanModel model) throws IOException {
        EntityClassInfo entityInfo = model.getEntityInfo(entityFqn);
        if (entityInfo == null) {
            return;
        }
        final EntityClassInfo.FieldInfo idFieldInfo = entityInfo.getIdFieldInfo();
        if (idFieldInfo != null && idFieldInfo.isEmbeddedId() && idFieldInfo.getType() != null) {
            final String idType = idFieldInfo.getType();
            JavaSource javaSource = JavaSource.forFileObject((FileObject)restResourceClass);
            Task<WorkingCopy> task = new Task<WorkingCopy>(){

                public void run(WorkingCopy workingCopy) throws Exception {
                    workingCopy.toPhase(JavaSource.Phase.RESOLVED);
                    CompilationUnitTree tree = workingCopy.getCompilationUnit();
                    TreeMaker maker = workingCopy.getTreeMaker();
                    ExpressionTree returnTypeTree = JavaSourceHelper.createTypeTree(workingCopy, idType);
                    ModifiersTree modifiersTree = JavaSourceHelper.createModifiersTree(workingCopy, new Modifier[]{Modifier.PRIVATE}, null, null);
                    ArrayList<VariableTree> vars = new ArrayList<VariableTree>();
                    VariableTree var = maker.Variable(maker.Modifiers(EnumSet.noneOf(Modifier.class)), (CharSequence)"pathSegment", (Tree)JavaSourceHelper.createTypeTree(workingCopy, "javax.ws.rs.core.PathSegment"), null);
                    vars.add(var);
                    MethodTree methodTree = maker.Method(modifiersTree, (CharSequence)"getPrimaryKey", (Tree)returnTypeTree, Collections.emptyList(), vars, Collections.emptyList(), this.getBody(idFieldInfo, workingCopy), null);
                    for (Tree tree2 : tree.getTypeDecls()) {
                        if (!TreeUtilities.CLASS_TREE_KINDS.contains((Object)tree2.getKind())) continue;
                        ClassTree classTree = (ClassTree)tree2;
                        ClassTree newTree = maker.addClassMember(classTree, (Tree)methodTree);
                        workingCopy.rewrite((Tree)classTree, (Tree)newTree);
                    }
                }

                private String getBody(EntityClassInfo.FieldInfo idField, WorkingCopy workingCopy) {
                    StringBuilder builder = new StringBuilder("{ ");
                    builder.append(" /* \n");
                    builder.append(" * pathSemgent represents a URI path segment ");
                    builder.append("and any associated matrix parameters.\n");
                    builder.append(" * URI path part is supposed to be in ");
                    builder.append("form of 'somePath");
                    Collection<EntityClassInfo.FieldInfo> fieldInfos = idField.getFieldInfos();
                    for (EntityClassInfo.FieldInfo fieldInfo : fieldInfos) {
                        String name = fieldInfo.getName();
                        builder.append(';');
                        builder.append(name);
                        builder.append('=');
                        builder.append(name);
                        builder.append("Value");
                    }
                    builder.append("'.\n");
                    builder.append(" * Here 'somePath' is a result of getPath() ");
                    builder.append("method invocation and \n");
                    builder.append(" * it is ignored in the following code.\n");
                    builder.append(" * Matrix parameters are used as field names");
                    builder.append(" to build a primary key instance.\n");
                    builder.append(" */");
                    if (idField.hasEmptyCtor()) {
                        builder.append(idField.getType());
                        builder.append(" key=new ");
                        builder.append(idField.getType());
                        builder.append("();");
                        boolean constructed = true;
                        StringBuilder keyBuidler = new StringBuilder("javax.ws.rs.core.MultivaluedMap<String,String>");
                        keyBuidler.append(" map = pathSegment.getMatrixParameters();");
                        for (EntityClassInfo.FieldInfo fieldInfo : fieldInfos) {
                            String name = fieldInfo.getName();
                            keyBuidler.append("java.util.List<String> ");
                            keyBuidler.append(name);
                            keyBuidler.append("=map.get(\"");
                            keyBuidler.append(name);
                            keyBuidler.append("\");");
                            keyBuidler.append("if ( ");
                            keyBuidler.append(name);
                            keyBuidler.append("!=null && !");
                            keyBuidler.append(name);
                            keyBuidler.append(".isEmpty()){");
                            String stringConverter = fieldInfo.getStringConverterMethod();
                            if (stringConverter == null) {
                                constructed = false;
                                keyBuidler.append(" // TODO : set ");
                                keyBuidler.append(name);
                                keyBuidler.append(" field value for key\n");
                                continue;
                            }
                            if (fieldInfo.isArray()) {
                                keyBuidler.append(fieldInfo.getType());
                                keyBuidler.append(" field=new ");
                                keyBuidler.append(fieldInfo.getType());
                                keyBuidler.deleteCharAt(keyBuidler.length() - 1);
                                keyBuidler.append(name);
                                keyBuidler.append(".size()];");
                                keyBuidler.append("for( int i=0;i<");
                                keyBuidler.append(name);
                                keyBuidler.append(".size();i++){");
                                keyBuidler.append("field[i]=");
                                keyBuidler.append(stringConverter);
                                keyBuidler.append('(');
                                keyBuidler.append(name);
                                keyBuidler.append(".get(i));");
                                keyBuidler.append('}');
                                keyBuidler.append("key.");
                                keyBuidler.append(Util.getSetterName(fieldInfo));
                                keyBuidler.append("(field);");
                            } else {
                                keyBuidler.append("key.");
                                keyBuidler.append(Util.getSetterName(fieldInfo));
                                keyBuidler.append('(');
                                if (String.class.getCanonicalName().equals(fieldInfo.getType())) {
                                    keyBuidler.append(name);
                                    keyBuidler.append(".get(0));");
                                } else {
                                    keyBuidler.append(stringConverter);
                                    keyBuidler.append('(');
                                    keyBuidler.append(name);
                                    keyBuidler.append(".get(0)));");
                                }
                            }
                            keyBuidler.append('}');
                        }
                        if (constructed) {
                            builder.append((CharSequence)keyBuidler);
                        } else {
                            builder.append("/*\n");
                            builder.append(" * TODO: put your code here to build");
                            builder.append(" a primary key instance.\n");
                            builder.append(" * See below the possible algorithm ");
                            builder.append("to do it.\n */");
                        }
                        builder.append("return key;");
                    } else {
                        this.addToDo(builder);
                        builder.append("return null;");
                    }
                    builder.append(" }");
                    return builder.toString();
                }

                private void addToDo(StringBuilder builder) {
                    builder.append(" // TODO: put your code here to create ");
                    builder.append("a primary key instance based on requested");
                    builder.append(" URI represented by pathSegment\n");
                }
            };
            javaSource.runModificationTask((Task)task).commit();
        }
    }

    public static String getGetterName(EntityClassInfo.FieldInfo fieldInfo) {
        return "get" + Util.capitalizeFirstLetter(fieldInfo.getName());
    }

    public static String getSetterName(EntityClassInfo.FieldInfo fieldInfo) {
        return "set" + Util.capitalizeFirstLetter(fieldInfo.getName());
    }

    public static void generateRESTFacades(Project project, Set<String> entities, EntityResourceBeanModel model, FileObject targetFolder, String resourcePackage) throws IOException {
        Util.generateRESTFacades(project, entities, model, targetFolder, resourcePackage, Util.getEjbFacadeGenerator(model));
    }

    public static void generateRESTFacades(Project project, Set<String> entities, EntityResourceBeanModel model, FileObject targetFolder, String resourcePackage, FacadeGenerator generator) throws IOException {
        HashMap<String, String> beanMap = new HashMap<String, String>();
        for (EntityClassInfo entityClassInfo : model.getEntityInfos()) {
            EntityClassInfo.FieldInfo fieldInfo = entityClassInfo.getIdFieldInfo();
            if (fieldInfo == null) continue;
            beanMap.put(entityClassInfo.getType(), fieldInfo.getType());
        }
        HashMap<String, String> selectedEntityNames = new HashMap<String, String>();
        Iterator<String> iterator = entities.iterator();
        while (iterator.hasNext()) {
            String entity;
            String primaryKeyType = (String)beanMap.get(entity = iterator.next());
            selectedEntityNames.put(entity, primaryKeyType == null ? String.class.getName() : primaryKeyType);
        }
        Map<String, String> map = Util.initEntityNames(project);
        for (Map.Entry entry : selectedEntityNames.entrySet()) {
            generator.generate(project, map, targetFolder, (String)entry.getKey(), (String)entry.getValue(), resourcePackage, false, false, true);
        }
    }

    public static Set<String> getEntities(Project project, Set<FileObject> files) throws IOException {
        final HashSet<String> entities = new HashSet<String>();
        for (FileObject file : files) {
            final JavaSource source = JavaSource.forFileObject((FileObject)file);
            if (source == null) continue;
            final EntityCollector collector = new EntityCollector();
            source.runUserActionTask((Task)collector, true);
            if (collector.isIncomplete() && org.netbeans.api.java.source.SourceUtils.isScanInProgress()) {
                final Runnable runnable = new Runnable(){

                    @Override
                    public void run() {
                        try {
                            source.runUserActionTask((Task)collector, true);
                            if (collector.getEntityFqn() != null) {
                                entities.add(collector.getEntityFqn());
                            }
                        }
                        catch (IOException e) {
                            Logger.getLogger(Util.class.getCanonicalName()).log(Level.WARNING, null, e);
                        }
                    }
                };
                if (SwingUtilities.isEventDispatchThread()) {
                    ScanDialog.runWhenScanFinished((Runnable)runnable, (String)NbBundle.getMessage(Util.class, (String)"LBL_AnalyzeEntities"));
                    continue;
                }
                SwingUtilities.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        ScanDialog.runWhenScanFinished((Runnable)runnable, (String)NbBundle.getMessage(Util.class, (String)"LBL_AnalyzeEntities"));
                    }
                });
                continue;
            }
            if (collector.getEntityFqn() == null) continue;
            entities.add(collector.getEntityFqn());
        }
        return entities;
    }

    public static Map<String, String> initEntityNames(Project project) throws IOException {
        final HashMap<String, String> entityNames = new HashMap<String, String>();
        EntityClassScope entityClassScope = EntityClassScope.getEntityClassScope((FileObject)project.getProjectDirectory());
        MetadataModel entityMappingsModel = entityClassScope.getEntityMappingsModel(true);
        entityMappingsModel.runReadAction((MetadataModelAction)new MetadataModelAction<EntityMappingsMetadata, Void>(){

            public Void run(EntityMappingsMetadata metadata) throws Exception {
                for (Entity entity : metadata.getRoot().getEntity()) {
                    entityNames.put(entity.getClass2(), entity.getName());
                }
                return null;
            }
        });
        return entityNames;
    }

    public static void modifyEntity(String entityFqn, Project project) {
        try {
            FileObject entityFileObject = SourceGroupSupport.getFileObjectFromClassName(entityFqn, project);
            if (entityFileObject == null) {
                return;
            }
            if (!entityFileObject.canWrite()) {
                return;
            }
            final JavaSource javaSource = JavaSource.forFileObject((FileObject)entityFileObject);
            if (javaSource == null) {
                return;
            }
            final boolean[] isIncomplete = new boolean[1];
            Task<CompilationController> task = new Task<CompilationController>(){

                public void run(CompilationController controller) throws Exception {
                    controller.toPhase(JavaSource.Phase.RESOLVED);
                    isIncomplete[0] = controller.getElements().getTypeElement(Util.XMLROOT_ANNOTATION) == null || controller.getElements().getTypeElement(Util.XML_TRANSIENT) == null;
                }
            };
            javaSource.runUserActionTask((Task)task, true);
            if (isIncomplete[0] && org.netbeans.api.java.source.SourceUtils.isScanInProgress()) {
                final Runnable runnable = new Runnable((Task)task){
                    final /* synthetic */ Task val$task;
                    {
                        this.val$task = task;
                    }

                    @Override
                    public void run() {
                        try {
                            javaSource.runUserActionTask(this.val$task, true);
                        }
                        catch (IOException e) {
                            Logger.getLogger(Util.class.getCanonicalName()).log(Level.WARNING, null, e);
                        }
                    }
                };
                if (SwingUtilities.isEventDispatchThread()) {
                    ScanDialog.runWhenScanFinished((Runnable)runnable, (String)NbBundle.getMessage(Util.class, (String)"LBL_EntityModification"));
                } else {
                    try {
                        SwingUtilities.invokeAndWait(new Runnable(){

                            @Override
                            public void run() {
                                ScanDialog.runWhenScanFinished((Runnable)runnable, (String)NbBundle.getMessage(Util.class, (String)"LBL_EntityModification"));
                            }
                        });
                    }
                    catch (InterruptedException e) {
                        return;
                    }
                    catch (InvocationTargetException e) {
                        return;
                    }
                }
            }
            if (isIncomplete[0]) {
                return;
            }
            ModificationResult result = javaSource.runModificationTask((Task)new Task<WorkingCopy>(){

                public void run(WorkingCopy working) throws IOException {
                    working.toPhase(JavaSource.Phase.RESOLVED);
                    TreeMaker maker = working.getTreeMaker();
                    Util.addXmlRootAnnotation(working, maker);
                    Util.addXmlTransientAnnotation(working, maker);
                }
            });
            result.commit();
        }
        catch (IOException e) {
            Logger.getLogger(Util.class.getName()).log(Level.SEVERE, null, e);
        }
    }

    private static String capitalizeFirstLetter(String str) {
        return str.substring(0, 1).toUpperCase() + str.substring(1, str.length());
    }

    private static void addXmlTransientAnnotation(WorkingCopy workingCopy, TreeMaker maker) {
        List<AnnotationTree> annotationTrees;
        GenerationUtils genUtils = GenerationUtils.newInstance((WorkingCopy)workingCopy);
        AnnotationTree xmlTransientAn = genUtils.createAnnotation(XML_TRANSIENT);
        TypeElement jsonIgnore = workingCopy.getElements().getTypeElement("org.codehaus.jackson.annotate.JsonIgnore");
        if (jsonIgnore == null) {
            annotationTrees = Collections.singletonList(xmlTransientAn);
        } else {
            AnnotationTree jsonIgnoreAn = genUtils.createAnnotation(jsonIgnore.getQualifiedName().toString());
            annotationTrees = new ArrayList<AnnotationTree>(2);
            annotationTrees.add(xmlTransientAn);
            annotationTrees.add(jsonIgnoreAn);
        }
        TypeElement entityElement = (TypeElement)workingCopy.getTopLevelElements().get(0);
        List<ExecutableElement> methods = ElementFilter.methodsIn(workingCopy.getElements().getAllMembers(entityElement));
        List<VariableElement> fields = ElementFilter.fieldsIn(workingCopy.getElements().getAllMembers(entityElement));
        HashMap<String, VariableElement> fieldsMap = new HashMap<String, VariableElement>();
        for (VariableElement variableElement : fields) {
            fieldsMap.put(variableElement.getSimpleName().toString(), variableElement);
        }
        for (ExecutableElement method : methods) {
            VariableElement field;
            if (!method.getModifiers().contains((Object)Modifier.PUBLIC)) continue;
            List<? extends AnnotationMirror> annotations = method.getAnnotationMirrors();
            boolean foundXmlTransient = false;
            for (AnnotationMirror annotationMirror : annotations) {
                Element annotation = annotationMirror.getAnnotationType().asElement();
                if (!(annotation instanceof TypeElement) || !((TypeElement)annotation).getQualifiedName().contentEquals(XML_TRANSIENT)) continue;
                foundXmlTransient = true;
                break;
            }
            if (foundXmlTransient || (field = Util.getField(method, fieldsMap, (CompilationController)workingCopy)) == null) continue;
            List<? extends AnnotationMirror> list = workingCopy.getElements().getAllAnnotationMirrors(field);
            for (AnnotationMirror annotationMirror : list) {
                MethodTree methodTree;
                String fqn;
                Element element = annotationMirror.getAnnotationType().asElement();
                if (!(element instanceof TypeElement) || !(fqn = ((TypeElement)element).getQualifiedName().toString()).equals("javax.persistence.OneToMany") && !fqn.equals("javax.persistence.ManyToMany")) continue;
                MethodTree newMethod = methodTree = workingCopy.getTrees().getTree(method);
                for (AnnotationTree annTree : annotationTrees) {
                    newMethod = genUtils.addAnnotation(newMethod, annTree);
                }
                workingCopy.rewrite((Tree)methodTree, (Tree)newMethod);
            }
        }
    }

    private static VariableElement getField(ExecutableElement method, Map<String, VariableElement> fields, CompilationController controller) {
        String name = method.getSimpleName().toString();
        TypeMirror returnType = method.getReturnType();
        if (returnType.getKind() == TypeKind.VOID) {
            return null;
        }
        if (!method.getParameters().isEmpty()) {
            return null;
        }
        int start = 0;
        if (name.startsWith("get")) {
            start = 3;
        } else if (name.startsWith("is")) {
            start = 2;
        }
        String fieldName = Util.lowerFirstLetter(name.substring(start));
        VariableElement field = fields.get(fieldName);
        if (field == null) {
            return null;
        }
        if (controller.getTypes().isSameType(field.asType(), returnType)) {
            return field;
        }
        return null;
    }

    private static String lowerFirstLetter(String name) {
        if (name.length() <= 1) {
            return name;
        }
        char firstLetter = name.charAt(0);
        if (Character.isUpperCase(firstLetter)) {
            return Character.toLowerCase(firstLetter) + name.substring(1);
        }
        return name;
    }

    private static void addXmlRootAnnotation(WorkingCopy working, TreeMaker make) {
        if (working.getElements().getTypeElement(XMLROOT_ANNOTATION) == null) {
            return;
        }
        TypeElement entityElement = (TypeElement)working.getTopLevelElements().get(0);
        List<? extends AnnotationMirror> annotationMirrors = working.getElements().getAllAnnotationMirrors(entityElement);
        boolean hasXmlRootAnnotation = false;
        for (AnnotationMirror annotationMirror : annotationMirrors) {
            Name annotationName;
            DeclaredType type = annotationMirror.getAnnotationType();
            Element annotationElement = type.asElement();
            if (!(annotationElement instanceof TypeElement) || !(annotationName = ((TypeElement)annotationElement).getQualifiedName()).contentEquals(XMLROOT_ANNOTATION)) continue;
            hasXmlRootAnnotation = true;
        }
        if (!hasXmlRootAnnotation) {
            ClassTree classTree = working.getTrees().getTree(entityElement);
            GenerationUtils generationUtils = GenerationUtils.newInstance((WorkingCopy)working);
            ModifiersTree modifiersTree = make.addModifiersAnnotation(classTree.getModifiers(), generationUtils.createAnnotation(XMLROOT_ANNOTATION));
            working.rewrite((Tree)classTree.getModifiers(), (Tree)modifiersTree);
        }
    }

    private static FacadeGenerator getEjbFacadeGenerator(EntityResourceBeanModel model) {
        if (FACADE_GENERATOR instanceof EjbFacadeGeneratorProvider) {
            return ((EjbFacadeGeneratorProvider)FACADE_GENERATOR).createGenerator(model);
        }
        return FACADE_GENERATOR.createGenerator();
    }

    private static class Lazy {
        private static final Map<String, Class<?>> primitiveTypes = new HashMap();

        private Lazy() {
        }

        static {
            primitiveTypes.put("int", Integer.class);
            primitiveTypes.put("int[]", int[].class);
            primitiveTypes.put("java.lang.Integer[]", Integer[].class);
            primitiveTypes.put("boolean", Boolean.class);
            primitiveTypes.put("boolean[]", boolean[].class);
            primitiveTypes.put("java.lang.Boolean[]", Boolean[].class);
            primitiveTypes.put("byte", Byte.class);
            primitiveTypes.put("byte[]", byte[].class);
            primitiveTypes.put("java.lang.Byte[]", Byte[].class);
            primitiveTypes.put("char", Character.class);
            primitiveTypes.put("char[]", char[].class);
            primitiveTypes.put("java.lang.Character[]", Character[].class);
            primitiveTypes.put("double", Double.class);
            primitiveTypes.put("double[]", double[].class);
            primitiveTypes.put("java.lang.Double[]", Double[].class);
            primitiveTypes.put("float", Float.class);
            primitiveTypes.put("float[]", float[].class);
            primitiveTypes.put("java.lang.Float[]", Float[].class);
            primitiveTypes.put("long", Long.class);
            primitiveTypes.put("long[]", long[].class);
            primitiveTypes.put("java.lang.Long[]", Long[].class);
            primitiveTypes.put("short", Short.class);
            primitiveTypes.put("short[]", short[].class);
            primitiveTypes.put("java.lang.Short[]", Short[].class);
        }
    }

    private static class EntityCollector
    implements Task<CompilationController> {
        private boolean isIncomplete;
        private String entityFqn;

        private EntityCollector() {
        }

        public void run(CompilationController controller) throws Exception {
            this.entityFqn = null;
            controller.toPhase(JavaSource.Phase.ELEMENTS_RESOLVED);
            TypeElement classElement = SourceUtils.getPublicTopLevelElement((CompilationController)controller);
            if (classElement == null) {
                return;
            }
            String entityName = null;
            TypeElement annotationElement = controller.getElements().getTypeElement("javax.persistence.Table");
            if (annotationElement == null) {
                this.isIncomplete = true;
            } else {
                entityName = TypeUtil.getAnnotationValueName(controller, classElement, annotationElement);
            }
            if (entityName == null) {
                annotationElement = controller.getElements().getTypeElement("javax.persistence.Entity");
                if (annotationElement == null) {
                    this.isIncomplete = true;
                    return;
                }
                entityName = TypeUtil.getAnnotationValueName(controller, classElement, annotationElement);
            }
            if (entityName != null) {
                this.entityFqn = classElement.getQualifiedName().toString();
            }
        }

        boolean isIncomplete() {
            return this.isIncomplete;
        }

        String getEntityFqn() {
            return this.entityFqn;
        }
    }
}

